/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.cache;

import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class OrganizationCacheHandler {
    private final ExoCache userCache;
    private final ExoCache userProfileCache;
    private final ExoCache membershipCache;
    private final ExoCache membershipTypeCache;
    private final ExoCache groupCache;

    public OrganizationCacheHandler(CacheService cservice) {
        this.userCache = cservice.getCacheInstance("portal.User");
        this.userProfileCache = cservice.getCacheInstance("portal.Profile");
        this.membershipCache = cservice.getCacheInstance("portal.Membership");
        this.membershipTypeCache = cservice.getCacheInstance("portal.Role");
        this.groupCache = cservice.getCacheInstance("portal.Group");
    }

    public OrganizationCacheHandler(CacheService cservice, long lifeTime) {
        this(cservice);
        this.userCache.setLiveTime(lifeTime);
        this.userProfileCache.setLiveTime(lifeTime);
        this.membershipCache.setLiveTime(lifeTime);
        this.membershipTypeCache.setLiveTime(lifeTime);
        this.groupCache.setLiveTime(lifeTime);
    }

    public ExoCache getUserProfileCache() {
        return this.userProfileCache;
    }

    public ExoCache getUserCache() {
        return this.userCache;
    }

    public ExoCache getMembershipTypeCache() {
        return this.membershipTypeCache;
    }

    public ExoCache getMembershipCache() {
        return this.membershipCache;
    }

    public ExoCache getGroupCache() {
        return this.groupCache;
    }
}

