/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.samples.xpath;

import java.io.StringReader;
import java.util.Iterator;
import org.xmlpull.v1.builder.XmlBuilderException;
import org.xmlpull.v1.builder.XmlDocument;
import org.xmlpull.v1.builder.XmlInfosetBuilder;
import org.xmlpull.v1.builder.xpath.Xb1XPath;
import org.xmlpull.v1.builder.xpath.jaxen.XPathSyntaxException;

public class Xb1XPathDemo {
    public static void main(String[] args) {
        int pos;
        String location = "<elem attr='value'><sub-elem>Text</sub-elem></elem>";
        String xpathExpr = "//";
        if (args.length != 2) {
            System.err.println("usage: " + Xb1XPathDemo.class.getName() + " <document url or XML content> <xpath expr>");
        }
        if (args.length > 0) {
            location = args[0];
        }
        if (args.length > 1) {
            xpathExpr = args[1];
        }
        boolean useUrl = (pos = location.indexOf("://")) >= 0 && pos < 6;
        try {
            XmlInfosetBuilder builder = XmlInfosetBuilder.newInstance();
            System.out.println("Evaluating XPath '" + xpathExpr + "' against '" + location + "'" + (useUrl ? " URL" : ""));
            XmlDocument doc = useUrl ? builder.parseLocation(location) : builder.parseReader(new StringReader(location));
            Xb1XPath xpath = new Xb1XPath(xpathExpr);
            Iterator resultsIter = xpath.selectNodes(doc).iterator();
            System.out.println("Results:");
            while (resultsIter.hasNext()) {
                Object infosetItem = resultsIter.next();
                System.out.println("----------------------------------");
                System.out.println(builder.serializeToString(infosetItem));
            }
            System.out.println("----------------------------------");
        }
        catch (XPathSyntaxException e) {
            System.err.println(e.getMultilineMessage());
        }
        catch (XmlBuilderException e) {
            e.printStackTrace();
        }
    }
}

