/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.impl;

import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.net.WebNotificationSender;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class SpaceNotificationImpl
extends SpaceListenerPlugin {
    private WebNotificationService webNotificationService;
    private static final Log LOG = ExoLogger.getExoLogger(SpaceNotificationImpl.class);

    public void spaceCreated(SpaceLifeCycleEvent event) {
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
        WebNotificationService webNotificationService = this.getWebNotificationService();
        if (webNotificationService != null) {
            Space space = event.getSpace();
            String userId = event.getTarget();
            WebNotificationFilter webNotificationFilter = new WebNotificationFilter(userId);
            webNotificationFilter.setParameter("spaceId", space.getId());
            PluginKey pluginKey = new PluginKey("SpaceInvitationPlugin");
            webNotificationFilter.setPluginKey(pluginKey);
            List webNotifs = webNotificationService.getNotificationInfos(webNotificationFilter, 0, -1);
            HashMap<String, String> ownerParameter = new HashMap<String, String>();
            ownerParameter.put("spaceId", space.getId());
            ownerParameter.put("status", "accepted");
            for (NotificationInfo info : webNotifs) {
                info.setTo(userId);
                info.key(new PluginKey("SpaceInvitationPlugin"));
                info.setOwnerParameter(ownerParameter);
                this.updateNotification(info);
            }
        } else {
            LOG.error((Object)"Cannot update web notfication. WebNotificationService is null");
        }
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String userId = event.getTarget();
        String senderRemoteId = space.getEditor();
        Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", senderRemoteId, false);
        String senderName = identity.getProfile().getFullName();
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(SocialNotificationUtils.REMOTE_ID, (Object)userId).append(SocialNotificationUtils.SPACE, (Object)space).append(SocialNotificationUtils.SENDER, (Object)senderName);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"SpaceInvitationPlugin"))).execute(ctx);
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String userId = event.getTarget();
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(SocialNotificationUtils.REMOTE_ID, (Object)userId).append(SocialNotificationUtils.SPACE, (Object)space);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"RequestJoinSpacePlugin"))).execute(ctx);
    }

    public void spaceBannerEdited(SpaceLifeCycleEvent event) {
    }

    private WebNotificationService getWebNotificationService() {
        if (this.webNotificationService == null) {
            this.webNotificationService = (WebNotificationService)CommonsUtils.getService(WebNotificationService.class);
        }
        return this.webNotificationService;
    }

    private MessageInfo updateNotification(NotificationInfo notification) {
        NotificationContext nCtx = NotificationContextImpl.cloneInstance().setNotificationInfo(notification);
        BaseNotificationPlugin plugin = nCtx.getPluginContainer().getPlugin(notification.getKey());
        if (plugin == null) {
            return null;
        }
        try {
            AbstractChannel channel = nCtx.getChannelManager().getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
            AbstractTemplateBuilder builder = channel.getTemplateBuilder(notification.getKey());
            MessageInfo msg = builder.buildMessage(nCtx);
            msg.setMoveTop(false);
            WebNotificationSender.sendJsonMessage((String)notification.getTo(), (MessageInfo)msg);
            notification.setTitle(msg.getBody());
            notification.with(NotificationMessageUtils.SHOW_POPOVER_PROPERTY.getKey(), "true").with(NotificationMessageUtils.READ_PORPERTY.getKey(), "false");
            this.getWebNotificationService().save(notification);
            return msg;
        }
        catch (Exception e) {
            LOG.error("Can not update space invitation notification.", new Object[]{e.getMessage()});
            return null;
        }
    }
}

