/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.transaction.xa.GlobalTransaction;

public class VersionedPrepareCommand
extends PrepareCommand {
    public static final byte COMMAND_ID = 26;
    private EntryVersionsMap versionsSeen = null;

    public VersionedPrepareCommand() {
        super("");
    }

    public VersionedPrepareCommand(String cacheName, GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhase) {
        super(cacheName, gtx, modifications, onePhase);
    }

    public VersionedPrepareCommand(String cacheName) {
        super(cacheName);
    }

    public EntryVersionsMap getVersionsSeen() {
        return this.versionsSeen;
    }

    public void setVersionsSeen(EntryVersionsMap versionsSeen) {
        this.versionsSeen = versionsSeen;
    }

    @Override
    public byte getCommandId() {
        return 26;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        super.writeTo(output);
        MarshallUtil.marshallMap((Map)this.versionsSeen, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readFrom(input);
        this.versionsSeen = (EntryVersionsMap)MarshallUtil.unmarshallMap((ObjectInput)input, EntryVersionsMap::new);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public String toString() {
        return "VersionedPrepareCommand {modifications=" + (this.modifications == null ? null : Arrays.asList(this.modifications)) + ", onePhaseCommit=" + this.onePhaseCommit + ", retried=" + this.retriedCommand + ", versionsSeen=" + this.versionsSeen + ", gtx=" + this.globalTx + ", cacheName='" + this.cacheName + '\'' + '}';
    }
}

