/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.DerivedScalar;
import org.apache.sis.measure.ScalarFactory;
import org.apache.sis.measure.ScalarFallback;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class Quantities
extends Static {
    private Quantities() {
    }

    public static Quantity<?> create(double d, String string) {
        return Quantities.create(d, Units.valueOf(string));
    }

    public static <Q extends Quantity<Q>> Q create(double d, Unit<Q> unit) {
        ArgumentChecks.ensureNonNull("unit", unit);
        Unit unit2 = unit.getSystemUnit();
        if (unit2 instanceof SystemUnit) {
            Object q;
            UnitConverter unitConverter = unit.getConverterTo(unit2);
            ScalarFactory<Q> scalarFactory = ((SystemUnit)unit2).factory;
            if (unitConverter.isLinear()) {
                if (scalarFactory != null) {
                    return scalarFactory.create(d, unit);
                }
                return ScalarFallback.factory(d, unit, ((SystemUnit)unit2).quantity);
            }
            if (scalarFactory != null && (q = scalarFactory.createDerived(d, unit, unit2, unitConverter)) != null) {
                return q;
            }
            return DerivedScalar.Fallback.factory(d, unit, unit2, unitConverter, ((SystemUnit)unit2).quantity);
        }
        throw new IllegalArgumentException(Errors.format((short)160, unit.getClass()));
    }

    public static <Q extends Quantity<Q>> Q castOrCopy(Quantity<Q> quantity) {
        if (quantity != null) {
            Unit unit = quantity.getUnit();
            Unit unit2 = unit.getSystemUnit();
            if (!(unit2 instanceof SystemUnit)) {
                throw new IllegalArgumentException(Errors.format((short)160, unit.getClass()));
            }
            Class clazz = ((SystemUnit)unit2).quantity;
            if (!clazz.isInstance(quantity)) {
                ScalarFactory scalarFactory = ((SystemUnit)unit2).factory;
                double d = AbstractConverter.doubleValue(quantity.getValue());
                if (scalarFactory != null) {
                    return scalarFactory.create(d, unit);
                }
                return ScalarFallback.factory(d, unit, clazz);
            }
        }
        return (Q)quantity;
    }
}

