/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.util.Arrays;
import java.util.function.Function;
import javax.measure.quantity.Dimensionless;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.Statistics;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.Matrix;

final class ResidualGrid
extends DatumShiftGrid<Dimensionless, Dimensionless> {
    private static final long serialVersionUID = 5207799661806374259L;
    static final int SOURCE_DIMENSION = 2;
    private static final ParameterDescriptorGroup PARAMETERS;
    private final int nx;
    private final float[] offsets;
    final LinearTransform gridToTarget;
    private final double accuracy;

    @Override
    public void getParameterValues(Parameters parameters) {
        Object object;
        Matrix matrix = this.gridToTarget.getMatrix();
        if (parameters instanceof ContextualParameters) {
            object = ((ContextualParameters)parameters).getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
            ((MatrixSIS)object).setMatrix(matrix);
        }
        object = this.getGridSize();
        parameters.parameter("num_row").setValue((int)object[1]);
        parameters.parameter("num_col").setValue((int)object[0]);
        parameters.parameter("grid_x").setValue((Object)new Data(0, matrix));
        parameters.parameter("grid_y").setValue((Object)new Data(1, matrix));
    }

    ResidualGrid(LinearTransform linearTransform, LinearTransform linearTransform2, int n, int n2, float[] fArray, double d) {
        super(Units.UNITY, linearTransform, new int[]{n, n2}, true, Units.UNITY);
        this.gridToTarget = linearTransform2;
        this.offsets = fArray;
        this.accuracy = d;
        this.nx = n;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return PARAMETERS;
    }

    @Override
    public int getTranslationDimensions() {
        return 2;
    }

    @Override
    public double getCellPrecision() {
        return this.accuracy;
    }

    @Override
    public double getCellValue(int n, int n2, int n3) {
        return this.offsets[(n2 + n3 * this.nx) * 2 + n];
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ResidualGrid residualGrid = (ResidualGrid)object;
            return Numerics.equals((double)this.accuracy, (double)residualGrid.accuracy) && this.gridToTarget.equals(residualGrid.gridToTarget) && Arrays.equals(this.offsets, residualGrid.offsets);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.offsets) + 37 * this.gridToTarget.hashCode();
    }

    static {
        ParameterBuilder parameterBuilder = new ParameterBuilder().setRequired(true);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{((ParameterBuilder)parameterBuilder.addName("num_row")).createBounded(Integer.class, Integer.valueOf(2), null, null), ((ParameterBuilder)parameterBuilder.addName("num_col")).createBounded(Integer.class, Integer.valueOf(2), null, null), ((ParameterBuilder)parameterBuilder.addName("grid_x")).create(Matrix.class, null), ((ParameterBuilder)parameterBuilder.addName("grid_y")).create(Matrix.class, null)};
        PARAMETERS = ((ParameterBuilder)parameterBuilder.addName("Localization grid")).createGroup((GeneralParameterDescriptor[])parameterDescriptorArray);
    }

    private final class Data
    extends FormattableObject
    implements Matrix,
    Function<int[], Number> {
        private final double c0;
        private final double c1;
        private final double c2;

        Data(int n, Matrix matrix) {
            this.c0 = matrix.getElement(n, 0);
            this.c1 = matrix.getElement(n, 1);
            this.c2 = matrix.getElement(n, 2);
        }

        public Matrix clone() {
            return this;
        }

        public boolean isIdentity() {
            return false;
        }

        public int getNumCol() {
            return ResidualGrid.this.nx;
        }

        public int getNumRow() {
            return ResidualGrid.this.getGridSize()[1];
        }

        @Override
        public Number apply(int[] nArray) {
            return this.getElement(nArray[1], nArray[0]);
        }

        public void setElement(int n, int n2, double d) {
            throw new UnsupportedOperationException();
        }

        public double getElement(int n, int n2) {
            return this.c0 * ((double)n2 + ResidualGrid.this.getCellValue(0, n2, n)) + this.c1 * ((double)n + ResidualGrid.this.getCellValue(1, n2, n)) + this.c2;
        }

        @Override
        public String toString() {
            int[] nArray = ResidualGrid.this.getGridSize();
            return new StringBuilder(80).append('[').append(this.getElement(0, 0)).append(", \u2026, ").append(this.getElement(nArray[1] - 1, nArray[0] - 1)).append(']').toString();
        }

        @Override
        protected String formatTo(Formatter formatter) {
            int n;
            Object[] objectArray = WKTUtilities.cornersAndCenter(this, ResidualGrid.this.getGridSize(), 3);
            Vector[] vectorArray = new Vector[objectArray.length];
            Statistics statistics = new Statistics(null);
            Vector vector = null;
            for (n = 0; n < vectorArray.length; ++n) {
                Vector vector2 = Vector.create((Object)objectArray[n], (boolean)false);
                Number number = null;
                int n2 = vector2.size();
                while (--n2 >= 0) {
                    Number number2 = vector2.get(n2);
                    if (number2 != null) {
                        Number number3;
                        double d = number2.doubleValue();
                        if (number != null) {
                            statistics.accept(Math.abs(number.doubleValue() - d));
                        }
                        if (vector != null && (number3 = vector.get(n2)) != null) {
                            statistics.accept(Math.abs(number3.doubleValue() - d));
                        }
                    }
                    number = number2;
                }
                vector = vector2;
                vectorArray[n] = vector2;
            }
            n = Numerics.suggestFractionDigits((Statistics)statistics);
            formatter.newLine();
            formatter.append(vectorArray, Math.max(0, n));
            formatter.setInvalidWKT(Matrix.class, null);
            return "Matrix";
        }
    }
}

