/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.addons.gamification.service.configuration.DomainService;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/gamification")
@Produces(value={"application/json"})
@RolesAllowed(value={"administrators"})
public class ManageDomainsEndpoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ManageDomainsEndpoint.class);
    private final CacheControl cacheControl = new CacheControl();
    protected DomainService domainService = null;
    protected IdentityManager identityManager = null;

    public ManageDomainsEndpoint() {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.domainService = (DomainService)CommonsUtils.getService(DomainService.class);
        this.identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Path(value="/domains")
    public Response getAllDomains(@Context UriInfo uriInfo, @Context HttpServletRequest request) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            try {
                List<DomainDTO> allDomains = this.domainService.getAllDomains();
                return Response.ok().cacheControl(this.cacheControl).entity(allDomains).build();
            }
            catch (Exception e) {
                LOG.error((Object)"Error listing all domains ", (Throwable)e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error listing all domains").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/domains")
    public Response addDomain(@Context SecurityContext securityContext, @Context UriInfo uriInfo, DomainDTO domainDTO) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String currentUserName = conversationState.getIdentity().getUserId();
            try {
                domainDTO.setId(null);
                domainDTO.setCreatedBy(currentUserName);
                domainDTO.setLastModifiedBy(currentUserName);
                domainDTO.setLastModifiedDate(new Date());
                domainDTO = this.domainService.addDomain(domainDTO);
                return Response.ok().cacheControl(this.cacheControl).entity((Object)domainDTO).build();
            }
            catch (Exception e) {
                LOG.error("Error adding new domain {} by {} ", new Object[]{domainDTO.getTitle(), currentUserName, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error adding new domain").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @PUT
    @RolesAllowed(value={"administrators"})
    @Path(value="/domains/{id}")
    public Response updateDomain(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="id") Long id, DomainDTO domainDTO) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String currentUserName = conversationState.getIdentity().getUserId();
            try {
                domainDTO.setLastModifiedBy(currentUserName);
                domainDTO.setLastModifiedDate(new Date());
                domainDTO = this.domainService.updateDomain(domainDTO);
                String actorId = this.identityManager.getOrCreateIdentity("organization", currentUserName, false).getId();
                LOG.info("service=gamification operation=edit-domain parameters=\"user_social_id:{},domain_id:{},domain_title:{},domain_description:{}\"", new Object[]{actorId, domainDTO.getId(), domainDTO.getTitle(), domainDTO.getDescription()});
                return Response.ok().cacheControl(this.cacheControl).entity((Object)domainDTO).build();
            }
            catch (Exception e) {
                LOG.error("Error updating domain {} by {} ", new Object[]{domainDTO.getTitle(), currentUserName, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error updating a domain").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @DELETE
    @RolesAllowed(value={"administrators"})
    @Path(value="/domains/{id}")
    public Response deleteRule(@Context UriInfo uriInfo, @PathParam(value="id") Long id) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String currentUserName = conversationState.getIdentity().getUserId();
            try {
                this.domainService.deleteDomain(id);
                return Response.ok().cacheControl(this.cacheControl).entity((Object)("Domain " + id + " has been removed successfully ")).build();
            }
            catch (Exception e) {
                LOG.error("Error deleting Domain {} by {} ", new Object[]{id, currentUserName, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error deleting a Domain").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }
}

