/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.referencing;

import javax.measure.Unit;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.PropertyType;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

public final class CC_OperationParameter
extends PropertyType<CC_OperationParameter, ParameterDescriptor<?>> {
    public Class<?> valueClass;
    public MeasurementRange<?> valueDomain;

    public CC_OperationParameter() {
    }

    protected Class<ParameterDescriptor<?>> getBoundType() {
        return ParameterDescriptor.class;
    }

    private CC_OperationParameter(ParameterDescriptor<?> parameterDescriptor) {
        super(parameterDescriptor);
    }

    protected CC_OperationParameter wrap(ParameterDescriptor<?> parameterDescriptor) {
        return new CC_OperationParameter(parameterDescriptor);
    }

    @XmlElement(name="OperationParameter")
    public DefaultParameterDescriptor<?> getElement() {
        return DefaultParameterDescriptor.castOrCopy((ParameterDescriptor)this.metadata);
    }

    public void setElement(DefaultParameterDescriptor<?> defaultParameterDescriptor) {
        this.metadata = defaultParameterDescriptor;
    }

    private void beforeUnmarshal(Unmarshaller unmarshaller, Object object) {
        Object object2;
        if (object instanceof ParameterValue && (object2 = ((ParameterValue)object).getValue()) != null) {
            this.valueClass = object2.getClass();
            Unit unit = ((ParameterValue)object).getUnit();
            if (unit != null) {
                if (Units.RADIAN.equals(unit = unit.getSystemUnit())) {
                    unit = Units.DEGREE;
                }
                assert (this.valueClass == Double.class || this.valueClass == double[].class) : this.valueClass;
                this.valueDomain = MeasurementRange.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)false, (Unit)unit);
            }
            Context.setWrapper((Context)Context.current(), (PropertyType)this);
        }
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
        Context.setWrapper((Context)Context.current(), null);
    }
}

