/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.extractor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.POIDocument;
import org.apache.poi.extractor.POIOLE2TextExtractor;
import org.apache.poi.hslf.usermodel.HSLFObjectShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.sl.extractor.SlideShowExtractor;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.sl.usermodel.SlideShowFactory;
import org.apache.poi.util.Removal;

@Deprecated
@Removal(version="5.0.0")
public final class PowerPointExtractor
extends POIOLE2TextExtractor {
    private final SlideShowExtractor<HSLFShape, HSLFTextParagraph> delegate;
    private boolean slidesByDefault = true;
    private boolean notesByDefault;
    private boolean commentsByDefault;
    private boolean masterByDefault;

    public static void main(String[] args) throws IOException {
        String file;
        if (args.length < 1) {
            System.err.println("Usage:");
            System.err.println("\tPowerPointExtractor [-notes] <file>");
            System.exit(1);
        }
        boolean notes = false;
        boolean comments = false;
        boolean master = true;
        if (args.length > 1) {
            notes = true;
            file = args[1];
            if (args.length > 2) {
                comments = true;
            }
        } else {
            file = args[0];
        }
        try (PowerPointExtractor ppe = new PowerPointExtractor(file);){
            System.out.println(ppe.getText(true, notes, comments, master));
        }
    }

    public PowerPointExtractor(HSLFSlideShow slideShow) {
        super((POIDocument)slideShow.getSlideShowImpl());
        this.setFilesystem(slideShow);
        this.delegate = new SlideShowExtractor((SlideShow)slideShow);
    }

    public PowerPointExtractor(String fileName) throws IOException {
        this(PowerPointExtractor.createHSLF(new File(fileName), Biff8EncryptionKey.getCurrentUserPassword(), true));
    }

    public PowerPointExtractor(InputStream iStream) throws IOException {
        this(PowerPointExtractor.createHSLF(iStream, Biff8EncryptionKey.getCurrentUserPassword()));
    }

    public PowerPointExtractor(POIFSFileSystem fs) throws IOException {
        this(PowerPointExtractor.createHSLF(fs, Biff8EncryptionKey.getCurrentUserPassword()));
    }

    public PowerPointExtractor(DirectoryNode dir) throws IOException {
        this(new HSLFSlideShow(dir));
    }

    public PowerPointExtractor(HSLFSlideShowImpl ss) {
        this(new HSLFSlideShow(ss));
    }

    public void setSlidesByDefault(boolean slidesByDefault) {
        this.slidesByDefault = slidesByDefault;
        this.delegate.setSlidesByDefault(slidesByDefault);
    }

    public void setNotesByDefault(boolean notesByDefault) {
        this.notesByDefault = notesByDefault;
        this.delegate.setNotesByDefault(notesByDefault);
    }

    public void setCommentsByDefault(boolean commentsByDefault) {
        this.commentsByDefault = commentsByDefault;
        this.delegate.setCommentsByDefault(commentsByDefault);
    }

    public void setMasterByDefault(boolean masterByDefault) {
        this.masterByDefault = masterByDefault;
        this.delegate.setMasterByDefault(masterByDefault);
    }

    public String getText() {
        return this.delegate.getText();
    }

    public String getText(boolean getSlideText, boolean getNoteText) {
        return this.getText(getSlideText, getNoteText, this.commentsByDefault, this.masterByDefault);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(boolean getSlideText, boolean getNoteText, boolean getCommentText, boolean getMasterText) {
        this.delegate.setSlidesByDefault(getSlideText);
        this.delegate.setNotesByDefault(getNoteText);
        this.delegate.setCommentsByDefault(getCommentText);
        this.delegate.setMasterByDefault(getMasterText);
        try {
            String string = this.delegate.getText();
            return string;
        }
        finally {
            this.delegate.setSlidesByDefault(this.slidesByDefault);
            this.delegate.setNotesByDefault(this.notesByDefault);
            this.delegate.setCommentsByDefault(this.commentsByDefault);
            this.delegate.setMasterByDefault(this.masterByDefault);
        }
    }

    public String getNotes() {
        return this.getText(false, true, false, false);
    }

    public List<HSLFObjectShape> getOLEShapes() {
        return this.delegate.getOLEShapes();
    }

    private static HSLFSlideShow createHSLF(POIFSFileSystem fs, String password) throws IOException, EncryptedDocumentException {
        SlideShow slideShowOrig = SlideShowFactory.create((POIFSFileSystem)fs, (String)password);
        return (HSLFSlideShow)slideShowOrig;
    }

    private static HSLFSlideShow createHSLF(InputStream inp, String password) throws IOException, EncryptedDocumentException {
        SlideShow slideShowOrig = SlideShowFactory.create((InputStream)inp, (String)password);
        return (HSLFSlideShow)slideShowOrig;
    }

    private static HSLFSlideShow createHSLF(File file, String password, boolean readOnly) throws IOException, EncryptedDocumentException {
        SlideShow slideShowOrig = SlideShowFactory.create((File)file, (String)password, (boolean)readOnly);
        return (HSLFSlideShow)slideShowOrig;
    }
}

