/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.dto.configuration;

import java.io.Serializable;
import java.util.Date;
import org.exoplatform.addons.gamification.entities.domain.configuration.RuleEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;

public class RuleDTO
implements Serializable {
    protected Long id;
    protected String title;
    protected String description;
    protected int score;
    protected String area;
    private DomainDTO domainDTO;
    protected boolean enabled;
    protected boolean deleted;
    private String createdBy;
    private Date createdDate;
    private String lastModifiedBy;
    private String event;
    private Date lastModifiedDate;

    public RuleDTO() {
    }

    public RuleDTO(RuleEntity rule) {
        this.id = rule.getId();
        this.title = rule.getTitle();
        this.description = rule.getDescription();
        this.score = rule.getScore();
        this.area = rule.getArea();
        this.domainDTO = rule.getDomainEntity() == null ? null : new DomainDTO(rule.getDomainEntity());
        this.enabled = rule.isEnabled();
        this.createdBy = rule.getCreatedBy();
        this.createdDate = rule.getCreatedDate();
        this.lastModifiedBy = rule.getLastModifiedBy();
        this.lastModifiedDate = rule.getLastModifiedDate();
        this.event = rule.getEvent();
        this.deleted = rule.isDeleted();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public String getArea() {
        if (this.domainDTO != null) {
            return this.domainDTO.getTitle();
        }
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public DomainDTO getDomainDTO() {
        return this.domainDTO;
    }

    public void setDomainDTO(DomainDTO domainDTO) {
        this.domainDTO = domainDTO;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String toString() {
        return "RuleDTO{title='" + this.title + "', description='" + this.description + "', score='" + this.score + "', area='" + this.area + "', createdBy=" + this.createdBy + ", createdDate=" + this.createdDate + ", lastModifiedBy='" + this.lastModifiedBy + "', lastModifiedDate=" + this.lastModifiedDate + ", deleted=" + this.deleted + ", enabled=" + this.enabled + "}";
    }
}

