/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.Serializable;
import java.text.Format;
import java.text.ParseException;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Locale;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public class Angle
implements Comparable<Angle>,
Formattable,
Serializable {
    private static final long serialVersionUID = 3701568577051191744L;
    private static Format format;
    private final double \u03b8;

    public Angle(double d) {
        this.\u03b8 = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Angle(String string) throws NumberFormatException {
        Object object;
        Class clazz;
        try {
            clazz = Angle.class;
            synchronized (Angle.class) {
                object = Angle.getAngleFormat().parseObject(string);
                // ** MonitorExit[var3_2 /* !! */ ] (shouldn't be in output)
            }
        }
        catch (ParseException parseException) {
            throw (NumberFormatException)new NumberFormatException(parseException.getMessage()).initCause(parseException);
        }
        {
            clazz = object.getClass();
            if (clazz != Angle.class && !this.getClass().isAssignableFrom(clazz)) {
                throw new NumberFormatException(string);
            }
            this.\u03b8 = ((Angle)object).\u03b8;
            return;
        }
    }

    static double valueOf(DirectPosition directPosition, AxisDirection axisDirection, AxisDirection axisDirection2) {
        CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem == null) {
            throw new IllegalArgumentException(Errors.format((short)157));
        }
        CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
        int n = coordinateSystem.getDimension();
        IncommensurableException incommensurableException = null;
        for (int i = 0; i < n; ++i) {
            Unit unit;
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            AxisDirection axisDirection3 = coordinateSystemAxis.getDirection();
            boolean bl = axisDirection3.equals((Object)axisDirection);
            if (!bl && !axisDirection3.equals((Object)axisDirection2)) continue;
            double d = directPosition.getOrdinate(i);
            if (!bl) {
                d = -d;
            }
            if ((unit = coordinateSystemAxis.getUnit()) != Units.DEGREE) {
                try {
                    d = unit.getConverterToAny(Units.DEGREE).convert(d);
                }
                catch (IncommensurableException incommensurableException2) {
                    incommensurableException = incommensurableException2;
                    break;
                }
            }
            return d;
        }
        throw new IllegalArgumentException(Errors.format((short)47, Classes.getLeafInterfaces(coordinateReferenceSystem.getClass(), CoordinateReferenceSystem.class)[0]), incommensurableException);
    }

    public double degrees() {
        return this.\u03b8;
    }

    public double radians() {
        return Math.toRadians(this.\u03b8);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.\u03b8);
        return (int)l ^ (int)(l >>> 32) ^ 0x52E269C0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            return Double.doubleToLongBits(this.\u03b8) == Double.doubleToLongBits(((Angle)object).\u03b8);
        }
        return false;
    }

    @Override
    public int compareTo(Angle angle) {
        return Double.compare(this.\u03b8, angle.\u03b8);
    }

    double maximum() {
        return 360.0;
    }

    char hemisphere(boolean bl) {
        return '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        double d = Math.abs(this.\u03b8);
        boolean bl2 = bl = d <= 2.7777777777777776E-7;
        if (bl || d > this.maximum()) {
            char c = this.hemisphere(MathFunctions.isNegative(this.\u03b8));
            if (c == '\u0000') {
                d = this.\u03b8;
            }
            char c2 = '\u00b0';
            if (bl) {
                c2 = '\u2033';
                d *= 3600.0;
            }
            stringBuffer.append(d).append(c2);
            if (c == '\u0000') return stringBuffer.toString();
            stringBuffer.append(c);
            return stringBuffer.toString();
        }
        Class<Angle> clazz = Angle.class;
        synchronized (Angle.class) {
            stringBuffer = Angle.getAngleFormat().format(this, stringBuffer, null);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return stringBuffer.toString();
        }
    }

    private static Format getAngleFormat() {
        assert (Thread.holdsLock(Angle.class));
        if (format == null) {
            format = new AngleFormat(Locale.ROOT);
        }
        return format;
    }

    @Override
    public void formatTo(Formatter formatter, int n, int n2, int n3) {
        String string;
        if (n3 == 0) {
            string = "";
        } else {
            char c;
            int n4 = n3;
            if (n4 > 0 && (c = this.hemisphere(MathFunctions.isNegative(this.\u03b8))) != '\u0000' && --n4 == 0) {
                string = Character.toString(c);
            } else {
                AngleFormat angleFormat = new AngleFormat(formatter.locale());
                if (n4 > 0) {
                    angleFormat.setMaximumWidth(n4);
                }
                string = angleFormat.format(this, new StringBuffer(), null).toString();
            }
        }
        Strings.formatTo(formatter, n, n2, n3, string);
    }
}

