/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.content;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.preflight.content.ContentStreamException;

public class StubOperator
extends OperatorProcessor {
    private final String name;
    private static final List<String> CHECK_NO_OPERANDS = Arrays.asList("S", "f", "F", "f*", "B", "B*", "b", "b*", "s", "EMC", "h", "W", "W*", "n");
    private static final List<String> CHECK_STRING_OPERANDS = Arrays.asList("BMC", "gs", "ri", "sh", "Tj", "'", "MP");
    private static final List<String> CHECK_TAG_AND_PROPERTY_OPERANDS = Arrays.asList("BDC", "DP");
    private static final List<String> CHECK_NUMBER_OPERANDS_6 = Arrays.asList("c", "d1");
    private static final List<String> CHECK_NUMBER_OPERANDS_4 = Arrays.asList("y", "v", "re");
    private static final List<String> CHECK_NUMBER_OPERANDS_2 = Arrays.asList("m", "l", "d0");
    private static final List<String> CHECK_NUMBER_OPERANDS = Arrays.asList("g", "G", "i", "M");
    private static final List<String> CHECK_ARRAY_OPERANDS = Arrays.asList("TJ");

    public StubOperator(String name) {
        this.name = name;
    }

    public void process(Operator operator, List<COSBase> arguments) throws IOException {
        String opName = operator.getName();
        if (CHECK_NO_OPERANDS.contains(opName)) {
            this.checkNoOperands(arguments);
        } else if (CHECK_STRING_OPERANDS.contains(opName)) {
            this.checkStringOperands(arguments, 1);
        } else if (CHECK_TAG_AND_PROPERTY_OPERANDS.contains(opName)) {
            this.checkTagAndPropertyOperands(arguments);
        } else if (CHECK_NUMBER_OPERANDS_6.contains(opName)) {
            this.checkNumberOperands(arguments, 6);
        } else if (CHECK_NUMBER_OPERANDS_4.contains(opName)) {
            this.checkNumberOperands(arguments, 4);
        } else if (CHECK_NUMBER_OPERANDS_2.contains(opName)) {
            this.checkNumberOperands(arguments, 2);
        } else if (CHECK_NUMBER_OPERANDS.contains(opName)) {
            this.checkNumberOperands(arguments, 1);
        } else if (CHECK_ARRAY_OPERANDS.contains(opName)) {
            this.checkArrayOperands(arguments, 1);
        } else if ("\"".equals(opName)) {
            this.checkNumberOperands(arguments.subList(0, 2), 2);
            this.checkStringOperands(arguments.subList(2, arguments.size()), 1);
        }
    }

    private void checkNoOperands(List<COSBase> arguments) throws ContentStreamException {
        if (arguments != null && !arguments.isEmpty()) {
            throw this.createInvalidArgumentsError();
        }
    }

    private void checkStringOperands(List<COSBase> arguments, int length) throws ContentStreamException {
        if (arguments == null || arguments.isEmpty() || arguments.size() != length) {
            throw this.createInvalidArgumentsError();
        }
        for (int i = 0; i < length; ++i) {
            COSBase arg = arguments.get(i);
            if (!(arg instanceof COSName) && !(arg instanceof COSString)) {
                throw this.createInvalidArgumentsError();
            }
            if (arg instanceof COSName && ((COSName)arg).getName().length() > 127) {
                throw this.createLimitError("1.0.3", "A Name operand is too long");
            }
            if (!(arg instanceof COSString) || ((COSString)arg).getString().getBytes().length <= 65535) continue;
            throw this.createLimitError("1.0.4", "A String operand is too long");
        }
    }

    private void checkArrayOperands(List<COSBase> arguments, int length) throws ContentStreamException {
        if (arguments == null || arguments.isEmpty() || arguments.size() != length) {
            throw this.createInvalidArgumentsError();
        }
        for (int i = 0; i < length; ++i) {
            COSBase arg = arguments.get(i);
            if (!(arg instanceof COSArray)) {
                throw this.createInvalidArgumentsError();
            }
            if (((COSArray)arg).size() <= 8191) continue;
            throw this.createLimitError("1.0.2", "Array has " + ((COSArray)arg).size() + " elements");
        }
    }

    private void checkNumberOperands(List<COSBase> arguments, int length) throws ContentStreamException {
        if (arguments == null || arguments.isEmpty() || arguments.size() != length) {
            throw this.createInvalidArgumentsError();
        }
        for (COSBase arg : arguments) {
            if (!(arg instanceof COSFloat) && !(arg instanceof COSInteger)) {
                throw this.createInvalidArgumentsError();
            }
            if (arg instanceof COSInteger && (((COSInteger)arg).longValue() > Integer.MAX_VALUE || ((COSInteger)arg).longValue() < Integer.MIN_VALUE)) {
                throw this.createLimitError("1.0.6", "Invalid integer range in a Number operand");
            }
            if (!(arg instanceof COSFloat) || !(((COSFloat)arg).floatValue() > 32767.0f) && !(((COSFloat)arg).floatValue() < -32767.0f)) continue;
            throw this.createLimitError("1.0.6", "Invalid float range in a Number operand");
        }
    }

    private void checkTagAndPropertyOperands(List<COSBase> arguments) throws ContentStreamException {
        if (arguments == null || arguments.isEmpty() || arguments.size() != 2) {
            throw this.createInvalidArgumentsError();
        }
        COSBase arg = arguments.get(0);
        if (!(arg instanceof COSName) && !(arg instanceof COSString)) {
            throw this.createInvalidArgumentsError();
        }
        if (arg instanceof COSName && ((COSName)arg).getName().length() > 127) {
            throw this.createLimitError("1.0.3", "A Name operand is too long");
        }
        if (arg instanceof COSString && ((COSString)arg).getString().getBytes().length > 65535) {
            throw this.createLimitError("1.0.4", "A String operand is too long");
        }
        COSBase arg2 = arguments.get(1);
        if (!(arg2 instanceof COSName || arg2 instanceof COSString || arg2 instanceof COSDictionary)) {
            throw this.createInvalidArgumentsError();
        }
        if (arg2 instanceof COSName && ((COSName)arg2).getName().length() > 127) {
            throw this.createLimitError("1.0.3", "A Name operand is too long");
        }
        if (arg2 instanceof COSString && ((COSString)arg2).getString().getBytes().length > 65535) {
            throw this.createLimitError("1.0.4", "A String operand is too long");
        }
        if (arg2 instanceof COSDictionary && ((COSDictionary)arg2).size() > 4095) {
            throw this.createLimitError("1.0.1", "Dictionary has " + ((COSDictionary)arg2).size() + " entries");
        }
    }

    private ContentStreamException createInvalidArgumentsError() {
        ContentStreamException ex = new ContentStreamException("Invalid arguments");
        ex.setErrorCode("1.2.11");
        return ex;
    }

    private ContentStreamException createLimitError(String errorCode, String details) {
        ContentStreamException ex = new ContentStreamException(details);
        ex.setErrorCode(errorCode);
        return ex;
    }

    public String getName() {
        return this.name;
    }
}

