/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.dynamic.FunctionWithJsqlParserException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.change.AbstractChange;
import liquibase.change.AddColumnConfig;
import liquibase.change.ColumnConfig;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.AlterSequenceChange;
import liquibase.change.core.CreateSequenceChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.DropSequenceChange;
import liquibase.change.core.DropTableChange;
import liquibase.change.core.MergeColumnChange;
import liquibase.change.core.RenameColumnChange;
import liquibase.change.core.RenameSequenceChange;
import liquibase.change.core.RenameTableChange;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.Alter;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterExpression;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterOperation;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.RenameTableStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.sequence.AlterSequence;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.sequence.CreateSequence;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.CreateTable;
import liquibase.repackaged.net.sf.jsqlparser.statement.drop.Drop;
import liquibase.util.StringUtil;

public enum ObjectTypesEnum {
    TABLE(statement -> {
        if (statement instanceof CreateTable) {
            return Collections.singletonList(((CreateTable)statement).getTable().getName());
        }
        if (statement instanceof Drop) {
            return Collections.singletonList(((Drop)statement).getName().getName());
        }
        if (statement instanceof Alter) {
            return ((Alter)statement).getAlterExpressions().stream().map(AlterExpression::getNewTableName).filter(StringUtil::isNotEmpty).collect(Collectors.toList());
        }
        if (statement instanceof RenameTableStatement) {
            return ((RenameTableStatement)statement).getTableNames().stream().filter(entry -> StringUtil.isNotEmpty(((Table)entry.getValue()).getName())).map(entry -> ((Table)entry.getValue()).getName()).collect(Collectors.toList());
        }
        return Collections.singletonList("");
    }, abstractChange -> {
        if (abstractChange instanceof RenameTableChange) {
            return Collections.singletonList(((RenameTableChange)abstractChange).getNewTableName());
        }
        if (abstractChange instanceof CreateTableChange) {
            return Collections.singletonList(((CreateTableChange)abstractChange).getTableName());
        }
        if (abstractChange instanceof DropTableChange) {
            return Collections.singletonList(((DropTableChange)abstractChange).getTableName());
        }
        return Collections.singletonList("");
    }),
    COLUMN(object -> {
        if (object instanceof Alter) {
            for (AlterExpression alterExpression : ((Alter)((Object)object)).getAlterExpressions()) {
                String string;
                if (alterExpression.getOperation() == AlterOperation.ADD) {
                    return alterExpression.getColDataTypeList().stream().map(ColumnDefinition::getColumnName).collect(Collectors.toList());
                }
                if (alterExpression.getOperation() != AlterOperation.RENAME || !StringUtil.isNotEmpty(string = alterExpression.getColumnName())) continue;
                return Collections.singletonList(string);
            }
        } else if (object instanceof CreateTable) {
            return ((CreateTable)((Object)object)).getColumnDefinitions().stream().map(ColumnDefinition::getColumnName).collect(Collectors.toList());
        }
        return Collections.singletonList("");
    }, abstractChange -> {
        List<Object> list = new ArrayList<String>();
        if (abstractChange instanceof CreateTableChange) {
            list = ((CreateTableChange)abstractChange).getColumns().stream().map(ColumnConfig::getName).collect(Collectors.toList());
        } else if (abstractChange instanceof RenameColumnChange) {
            list.add(((RenameColumnChange)abstractChange).getNewColumnName());
        } else if (abstractChange instanceof AddColumnChange) {
            list.addAll(((AddColumnChange)abstractChange).getColumns().stream().map(AddColumnConfig::getAfterColumn).collect(Collectors.toList()));
        } else if (abstractChange instanceof MergeColumnChange) {
            list.add(((MergeColumnChange)abstractChange).getFinalColumnName());
        }
        return list;
    }),
    SEQUENCE(statement -> {
        if (statement instanceof CreateSequence) {
            return Collections.singletonList(((CreateSequence)statement).getSequence().getName());
        }
        if (statement instanceof AlterSequence) {
            return Collections.singletonList(((AlterSequence)statement).getSequence().getName());
        }
        if (statement instanceof Drop && ((Drop)statement).getType().equalsIgnoreCase("sequence")) {
            return Collections.singletonList(((Drop)statement).getName().getName());
        }
        return Collections.singletonList("");
    }, abstractChange -> {
        if (abstractChange instanceof CreateSequenceChange) {
            return Collections.singletonList(((CreateSequenceChange)abstractChange).getSequenceName());
        }
        if (abstractChange instanceof AlterSequenceChange) {
            return Collections.singletonList(((AlterSequenceChange)abstractChange).getSequenceName());
        }
        if (abstractChange instanceof DropSequenceChange) {
            return Collections.singletonList(((DropSequenceChange)abstractChange).getSequenceName());
        }
        if (abstractChange instanceof RenameSequenceChange) {
            return Collections.singletonList(((RenameSequenceChange)abstractChange).getNewSequenceName());
        }
        return Collections.singletonList("");
    });

    public final FunctionWithJsqlParserException<Statement, List<String>> sqlCallback;
    public final Function<AbstractChange, List<String>> abstractChangeCallback;

    private ObjectTypesEnum(FunctionWithJsqlParserException<Statement, List<String>> functionWithJsqlParserException, Function<AbstractChange, List<String>> function) {
        this.sqlCallback = functionWithJsqlParserException;
        this.abstractChangeCallback = function;
    }
}

