/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.register;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.JspBasedWebHandler;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.login.UIParamsExtension;
import org.json.JSONObject;

public class RegisterHandler
extends JspBasedWebHandler {
    public static final String REGISTER_EXTENSION_NAME = "RegisterExtension";
    public static final String REGISTER_ENABLED = "registerEnabled";
    public static final String REGISTER_ERROR_PARAM = "errorCode";
    private static final Log LOG = ExoLogger.getLogger(RegisterHandler.class);
    private static final String REGISTER_JSP_PATH_PARAM = "register.jsp.path";
    private static final String REGISTER_EXTENSION_JS_MODULES = "RegisterExtension";
    private PortalContainer container;
    private ServletContext servletContext;
    private String registerJspPath;

    public RegisterHandler(PortalContainer container, LocaleConfigService localeConfigService, BrandingService brandingService, JavascriptConfigService javascriptConfigService, SkinService skinService, InitParams params) {
        super(localeConfigService, brandingService, javascriptConfigService, skinService);
        this.container = container;
        if (params != null && params.containsKey((Object)REGISTER_JSP_PATH_PARAM)) {
            this.registerJspPath = params.getValueParam(REGISTER_JSP_PATH_PARAM).getValue();
        }
    }

    public String getHandlerName() {
        return "register";
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    public void onInit(WebAppController controller, ServletConfig servletConfig) {
        this.servletContext = this.container.getPortalContext();
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        HttpServletRequest request = controllerContext.getRequest();
        HttpServletResponse response = controllerContext.getResponse();
        List<String> additionalJSModules = this.getExtendedJSModules(controllerContext, request);
        List<String> additionalCSSModules = Collections.singletonList("portal/login");
        super.prepareDispatch(controllerContext, "PORTLET/social-portlet/Register", additionalJSModules, additionalCSSModules, params -> this.extendUIParameters(controllerContext, (JSONObject)params));
        this.servletContext.getRequestDispatcher(this.registerJspPath).include((ServletRequest)request, (ServletResponse)response);
        return true;
    }

    private List<String> getExtendedJSModules(ControllerContext controllerContext, HttpServletRequest request) throws Exception {
        ArrayList<String> additionalJSModules = new ArrayList<String>();
        JSONObject jsConfig = this.javascriptConfigService.getJSConfig(controllerContext, request.getLocale());
        if (jsConfig.has("paths")) {
            JSONObject jsConfigPaths = jsConfig.getJSONObject("paths");
            Iterator keys = jsConfigPaths.keys();
            while (keys.hasNext()) {
                String module = (String)keys.next();
                if (!module.contains("RegisterExtension")) continue;
                additionalJSModules.add(module);
            }
        }
        return additionalJSModules;
    }

    private void extendUIParameters(ControllerContext controllerContext, JSONObject params) {
        try {
            List paramsExtensions;
            Object errorCode = controllerContext.getRequest().getAttribute(REGISTER_ERROR_PARAM);
            if (errorCode != null) {
                params.put(REGISTER_ERROR_PARAM, errorCode);
            }
            if (CollectionUtils.isNotEmpty((Collection)(paramsExtensions = this.container.getComponentInstancesOfType(UIParamsExtension.class)))) {
                paramsExtensions.stream().filter(extension -> extension.getExtensionNames().contains("RegisterExtension")).forEach(paramsExtension -> {
                    Map<String, Object> extendedParams = paramsExtension.extendParameters(controllerContext, "RegisterExtension");
                    if (MapUtils.isNotEmpty(extendedParams)) {
                        extendedParams.forEach((key, value) -> {
                            try {
                                params.put(key, value);
                            }
                            catch (Exception e) {
                                LOG.warn("Error while adding {}/{} in register params map", new Object[]{key, value, e});
                            }
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while computing Register UI parameters", (Throwable)e);
        }
    }
}

