/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;

public abstract class AbstractMetadataItemListener<S, D>
extends Listener<S, D> {
    private CachedActivityStorage cachedActivityStorage;
    private IndexingService indexingService;

    protected AbstractMetadataItemListener(ActivityStorage activityStorage, IndexingService indexingService) {
        this.indexingService = indexingService;
        if (activityStorage instanceof CachedActivityStorage) {
            this.cachedActivityStorage = (CachedActivityStorage)activityStorage;
        }
    }

    protected void handleMetadataModification(String objectType, String objectId) {
        if (this.isActivityEvent(objectType)) {
            this.clearCache(objectId);
            this.reindexActivity(objectId);
        }
    }

    private boolean isActivityEvent(String objectType) {
        return StringUtils.equals((CharSequence)objectType, (CharSequence)"activity");
    }

    private void reindexActivity(String activityId) {
        this.indexingService.reindex("activity", activityId);
    }

    private void clearCache(String activityId) {
        if (this.cachedActivityStorage != null) {
            this.cachedActivityStorage.clearActivityCached(activityId);
        }
    }
}

