/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.dom.address;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.DomainList;
import org.apache.james.mime4j.util.LangUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mailbox
extends Address {
    private static final long serialVersionUID = 1L;
    private static final DomainList EMPTY_ROUTE_LIST = new DomainList(Collections.<String>emptyList());
    private final String name;
    private final DomainList route;
    private final String localPart;
    private final String domain;

    public Mailbox(String name, DomainList route, String localPart, String domain) {
        if (localPart == null) {
            throw new IllegalArgumentException();
        }
        this.name = name == null || name.length() == 0 ? null : name;
        this.route = route == null ? EMPTY_ROUTE_LIST : route;
        this.localPart = localPart;
        this.domain = domain == null || domain.length() == 0 ? null : domain;
    }

    Mailbox(String name, Mailbox baseMailbox) {
        this(name, baseMailbox.getRoute(), baseMailbox.getLocalPart(), baseMailbox.getDomain());
    }

    public Mailbox(String localPart, String domain) {
        this(null, null, localPart, domain);
    }

    public Mailbox(DomainList route, String localPart, String domain) {
        this(null, route, localPart, domain);
    }

    public Mailbox(String name, String localPart, String domain) {
        this(name, null, localPart, domain);
    }

    public String getName() {
        return this.name;
    }

    public DomainList getRoute() {
        return this.route;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getAddress() {
        if (this.domain == null) {
            return this.localPart;
        }
        return this.localPart + '@' + this.domain;
    }

    @Override
    protected final void doAddMailboxesTo(List<Mailbox> results) {
        results.add(this);
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode((int)hash, (Object)this.localPart);
        hash = LangUtils.hashCode((int)hash, this.domain != null ? this.domain.toLowerCase(Locale.US) : null);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Mailbox)) {
            return false;
        }
        Mailbox that = (Mailbox)obj;
        return LangUtils.equals((Object)this.localPart, (Object)that.localPart) && LangUtils.equalsIgnoreCase((String)this.domain, (String)that.domain);
    }

    public String toString() {
        return this.getAddress();
    }
}

