/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.configuration;

import java.util.List;
import org.exoplatform.addons.gamification.service.AnnouncementService;
import org.exoplatform.addons.gamification.service.dto.configuration.Announcement;
import org.exoplatform.addons.gamification.service.dto.configuration.Challenge;
import org.exoplatform.addons.gamification.storage.AnnouncementStorage;
import org.exoplatform.addons.gamification.storage.RuleStorage;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;

public class AnnouncementServiceImpl
implements AnnouncementService {
    private static final Log LOG = ExoLogger.getLogger(AnnouncementServiceImpl.class);
    private AnnouncementStorage announcementStorage;
    private RuleStorage challengeStorage;
    private ListenerService listenerService;

    public AnnouncementServiceImpl(AnnouncementStorage announcementStorage, RuleStorage challengeStorage, ListenerService listenerService) {
        this.announcementStorage = announcementStorage;
        this.challengeStorage = challengeStorage;
        this.listenerService = listenerService;
    }

    @Override
    public Announcement createAnnouncement(Announcement announcement, String currentUser, boolean system) throws IllegalArgumentException, ObjectNotFoundException, IllegalAccessException {
        if (announcement == null) {
            throw new IllegalArgumentException("announcement is mandatory");
        }
        if (announcement.getId() != 0L) {
            throw new IllegalArgumentException("announcement id must be equal to 0");
        }
        Challenge challenge = this.challengeStorage.getChallengeById(announcement.getChallengeId());
        if (challenge == null) {
            throw new ObjectNotFoundException("challenge does not exist");
        }
        if (announcement.getAssignee() == null) {
            throw new IllegalArgumentException("announcement assignee must have at least one winner");
        }
        if (!Utils.canAnnounce(String.valueOf(challenge.getAudience()))) {
            throw new IllegalAccessException("user is not allowed to announce challenge");
        }
        Identity identity = Utils.getIdentityByTypeAndId("organization", currentUser);
        announcement.setCreator(Long.parseLong(identity.getId()));
        announcement = this.announcementStorage.saveAnnouncement(announcement);
        if (!system) {
            try {
                this.listenerService.broadcast("challenge.announcement.activity", (Object)this, (Object)announcement);
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
        return announcement;
    }

    @Override
    public List<Announcement> findAllAnnouncementByChallenge(long challengeId, int offset, int limit) throws ObjectNotFoundException {
        if (challengeId <= 0L) {
            throw new IllegalArgumentException("Challenge id has to be positive integer");
        }
        return this.announcementStorage.findAllAnnouncementByChallenge(challengeId, offset, limit);
    }

    @Override
    public Long countAllAnnouncementsByChallenge(long challengeId) throws ObjectNotFoundException {
        if (challengeId <= 0L) {
            throw new IllegalArgumentException("Challenge id has to be positive integer");
        }
        Challenge challenge = this.challengeStorage.getChallengeById(challengeId);
        if (challenge == null) {
            throw new ObjectNotFoundException("challenge does not exist");
        }
        return this.announcementStorage.countAnnouncementsByChallenge(challengeId);
    }

    @Override
    public Announcement updateAnnouncement(Announcement announcement) throws IllegalArgumentException, ObjectNotFoundException {
        if (announcement == null) {
            throw new IllegalArgumentException("announcement is mandatory");
        }
        if (announcement.getId() == 0L) {
            throw new IllegalArgumentException("announcement id must not be equal to 0");
        }
        Announcement oldAnnouncement = this.announcementStorage.getAnnouncementById(announcement.getId());
        if (oldAnnouncement == null) {
            throw new ObjectNotFoundException("Announcement does not exist");
        }
        return this.announcementStorage.saveAnnouncement(announcement);
    }

    @Override
    public Announcement getAnnouncementById(Long announcementId) throws IllegalArgumentException {
        if (announcementId == null || announcementId <= 0L) {
            throw new IllegalArgumentException("announcement id is mandatory");
        }
        return this.announcementStorage.getAnnouncementById(announcementId);
    }
}

