/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.auth;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.AccountTemporaryLockedException;
import org.exoplatform.services.organization.DisabledUserException;
import org.exoplatform.services.organization.ExtendedUserHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.auth.AuthenticatorPlugin;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.DigestPasswordEncrypter;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.security.MembershipHashSet;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.PasswordEncrypter;
import org.exoplatform.services.security.RolesExtractor;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;

public class OrganizationAuthenticatorImpl
implements Authenticator {
    private static final String STATUS_NOT_OK = "ko";
    private static final String STATUS_OK = "ok";
    private static final String ACCOUNT_LOCKED = "accountLocked";
    private static final String WRONG_CREDENTIALS = "wrongCredentials";
    private static final String SERVICE = "service";
    private static final String LOGIN = "login";
    private static final String OPERATION = "operation";
    private static final String STATUS = "status";
    private static final String AUTHENTICATION_ATTEMPTS = "authenticationAttempts";
    private static final String LATEST_AUTH_TIME = "latestAuthFailureTime";
    private static final String MAX_AUTHENTICATION_ATTEMPTS = "maxAuthenticationAttempts";
    private static final String BLOCKING_TIME = "blockingTime";
    private int maxAuthenticationAttempts = 5;
    private int blockingTime = 10;
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.api.OrganizationUserRegistry");
    private final ThreadLocal<Exception> lastExceptionOnValidateUser = new ThreadLocal();
    private final OrganizationService orgService;
    private final PasswordEncrypter encrypter;
    private final RolesExtractor rolesExtractor;
    private final ListenerService listenerService;
    private List<AuthenticatorPlugin> plugins = new ArrayList<AuthenticatorPlugin>();

    public OrganizationAuthenticatorImpl(OrganizationService orgService, RolesExtractor rolesExtractor, PasswordEncrypter encrypter, ListenerService listenerService, InitParams initParams) {
        this.orgService = orgService;
        this.encrypter = encrypter;
        this.rolesExtractor = rolesExtractor;
        this.listenerService = listenerService;
        if (initParams != null && initParams.getValueParam(MAX_AUTHENTICATION_ATTEMPTS) != null) {
            this.maxAuthenticationAttempts = Integer.parseInt(initParams.getValueParam(MAX_AUTHENTICATION_ATTEMPTS).getValue());
        }
        if (initParams != null && initParams.getValueParam(BLOCKING_TIME) != null) {
            this.blockingTime = Integer.parseInt(initParams.getValueParam(BLOCKING_TIME).getValue());
        }
    }

    public OrganizationAuthenticatorImpl(OrganizationService orgService, RolesExtractor rolesExtractor, ListenerService listenerService, InitParams initParams) {
        this(orgService, rolesExtractor, null, listenerService, initParams);
    }

    public OrganizationAuthenticatorImpl(OrganizationService orgService, ListenerService listenerService, InitParams initParams) {
        this(orgService, null, null, listenerService, initParams);
    }

    public OrganizationService getOrganizationService() {
        return this.orgService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity createIdentity(String userId) throws Exception {
        Collection memberships;
        MembershipHashSet entries = new MembershipHashSet();
        this.begin(this.orgService);
        try {
            memberships = this.orgService.getMembershipHandler().findMembershipsByUser(userId);
        }
        finally {
            this.end(this.orgService);
        }
        if (memberships != null) {
            for (Membership membership : memberships) {
                entries.add(new MembershipEntry(membership.getGroupId(), membership.getMembershipType()));
            }
        }
        Identity identity = null;
        identity = this.rolesExtractor == null ? new Identity(userId, (Collection)entries) : new Identity(userId, (Collection)entries, (Collection)this.rolesExtractor.extractRoles(userId, (Set)entries));
        return identity;
    }

    public String validateUser(Credential[] credentials) throws LoginException, Exception {
        String username = null;
        String password = null;
        Map passwordContext = null;
        for (Credential cred : credentials) {
            if (cred instanceof UsernameCredential) {
                username = ((UsernameCredential)cred).getUsername();
            }
            if (!(cred instanceof PasswordCredential)) continue;
            password = ((PasswordCredential)cred).getPassword();
            passwordContext = ((PasswordCredential)cred).getPasswordContext();
        }
        boolean success = false;
        if (username != null && password != null) {
            if (this.encrypter != null) {
                password = new String(this.encrypter.encrypt(password.getBytes()));
            }
            this.begin(this.orgService);
            try {
                UserHandler userHandler = this.orgService.getUserHandler();
                if (userHandler.findUserByName(username) != null) {
                    this.checkLockedAccount(userHandler.findUserByName(username));
                }
                if (passwordContext != null && userHandler instanceof ExtendedUserHandler) {
                    DigestPasswordEncrypter pe = new DigestPasswordEncrypter(username, passwordContext);
                    success = ((ExtendedUserHandler)userHandler).authenticate(username, password, (PasswordEncrypter)pe);
                } else {
                    success = userHandler.authenticate(username, password);
                }
                this.lastExceptionOnValidateUser.remove();
            }
            catch (DisabledUserException e) {
                this.lastExceptionOnValidateUser.set((Exception)((Object)e));
                throw new LoginException("The user account " + username.replace("\n", " ").replace("\r", " ") + " is disabled");
            }
            catch (AccountTemporaryLockedException e) {
                this.lastExceptionOnValidateUser.set((Exception)((Object)e));
                throw new LoginException("The user account " + username.replace("\n", " ").replace("\r", " ") + " is temporarily locked until " + e.getUnlockTime());
            }
            catch (Exception e) {
                this.lastExceptionOnValidateUser.set(e);
                throw e;
            }
            finally {
                this.end(this.orgService);
            }
        }
        if (!success) {
            for (AuthenticatorPlugin plugin : this.getPlugins()) {
                try {
                    String validatedUserName = plugin.validateUser(credentials);
                    if (!StringUtils.isNotBlank((String)validatedUserName)) continue;
                    success = true;
                    username = validatedUserName;
                    break;
                }
                catch (Exception e) {
                    LOG.debug("Error while authenticating user using plugin {}", new Object[]{plugin.getClass()});
                }
            }
        }
        if (!success) {
            if (username != null) {
                this.saveLastLoginFail(username);
                throw new LoginException("Login failed for " + username.replace("\n", " ").replace("\r", " "));
            }
            throw new LoginException("Login failed for " + username);
        }
        this.resetAuthenticationAttempts(username);
        this.listenerService.broadcast("exo.user.authenticated", (Object)this.orgService, (Object)username);
        return username;
    }

    public void addAuthenticatorPlugin(AuthenticatorPlugin plugin) {
        this.plugins.add(plugin);
    }

    public List<AuthenticatorPlugin> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<AuthenticatorPlugin> plugins) {
        this.plugins = plugins;
    }

    public void begin(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)orgService));
        }
    }

    public void end(OrganizationService orgService) throws Exception {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }

    public Exception getLastExceptionOnValidateUser() {
        Exception e = this.lastExceptionOnValidateUser.get();
        if (e != null) {
            this.lastExceptionOnValidateUser.remove();
        }
        return e;
    }

    private void checkLockedAccount(User user) throws AccountTemporaryLockedException {
        try {
            UserProfile profile = this.orgService.getUserProfileHandler().findUserProfileByName(user.getUserName());
            if (profile != null) {
                int currentNbFail = profile.getAttribute(AUTHENTICATION_ATTEMPTS) != null ? Integer.parseInt(profile.getAttribute(AUTHENTICATION_ATTEMPTS)) : 0;
                Instant latestAuthFailureTime = Instant.ofEpochMilli(profile.getAttribute(LATEST_AUTH_TIME) != null ? Long.parseLong(profile.getAttribute(LATEST_AUTH_TIME)) : Instant.EPOCH.toEpochMilli());
                if (currentNbFail >= this.maxAuthenticationAttempts && latestAuthFailureTime.plus((long)this.blockingTime, ChronoUnit.MINUTES).isAfter(Instant.now())) {
                    LOG.warn("service=login operation=login status=ko parameters=\"username:{}, authenticationAttempts:{}, maxAuthenticationAttempts:{}, latestAuthFailureTime={}, lockTimeInMinutes={}, unlockTime={}\" error_msg=\"Account is locked\"", new Object[]{user.getUserName(), currentNbFail, this.maxAuthenticationAttempts, latestAuthFailureTime, this.blockingTime, latestAuthFailureTime.plus((long)this.blockingTime, ChronoUnit.MINUTES)});
                    this.broacastFailedLoginEvent(user.getUserName(), STATUS_NOT_OK, ACCOUNT_LOCKED);
                    throw new AccountTemporaryLockedException(user.getUserName(), latestAuthFailureTime.plus((long)this.blockingTime, ChronoUnit.MINUTES));
                }
            }
        }
        catch (AccountTemporaryLockedException atle) {
            throw atle;
        }
        catch (Exception e) {
            LOG.error("Unable to get gatein user profile for user {}", new Object[]{user.getUserName(), e});
        }
    }

    private void broacastFailedLoginEvent(String userId, String status, String reason) {
        try {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("user_id", userId);
            info.put(STATUS, status);
            info.put("reason", reason);
            this.listenerService.broadcast("login.failed", null, info);
        }
        catch (Exception e) {
            LOG.error("Error while broadcasting event 'login.failed' for user '{}'", new Object[]{userId, e});
        }
    }

    private void saveLastLoginFail(String username) {
        try {
            User user = this.orgService.getUserHandler().findUserByName(username);
            if (user != null) {
                UserProfile profile = this.orgService.getUserProfileHandler().findUserProfileByName(username);
                if (profile == null) {
                    profile = this.orgService.getUserProfileHandler().createUserProfileInstance(username);
                }
                int currentNbFail = profile.getAttribute(AUTHENTICATION_ATTEMPTS) != null ? Integer.parseInt(profile.getAttribute(AUTHENTICATION_ATTEMPTS)) : 0;
                profile.setAttribute(AUTHENTICATION_ATTEMPTS, String.valueOf(++currentNbFail));
                Instant now = Instant.now();
                profile.setAttribute(LATEST_AUTH_TIME, String.valueOf(now.toEpochMilli()));
                this.orgService.getUserProfileHandler().saveUserProfile(profile, true);
                if (currentNbFail >= this.maxAuthenticationAttempts) {
                    LOG.warn("service=login operation=login status=ko parameters=\"username:{}, authenticationAttempts:{}, maxAuthenticationAttempts:{}, latestAuthFailureTime={}, lockTimeInMinutes={}, unlockTime={}\" error_msg=\"Account is locked\"", new Object[]{user.getUserName(), currentNbFail, this.maxAuthenticationAttempts, now, this.blockingTime, now.plus((long)this.blockingTime, ChronoUnit.MINUTES)});
                    this.broacastFailedLoginEvent(user.getUserName(), STATUS_NOT_OK, ACCOUNT_LOCKED);
                    ExoContainer container = ExoContainerContext.getCurrentContainer();
                    PasswordRecoveryService passwordRecoveryService = (PasswordRecoveryService)container.getComponentInstanceOfType(PasswordRecoveryService.class);
                    passwordRecoveryService.sendAccountLockedEmail(user, Locale.ENGLISH);
                } else {
                    LOG.warn("service=login operation=login status=ko parameters=\"username:{}, authenticationAttempts:{}, latestAuthFailureTime:{}, maxAuthenticationAttempts:{}\" error_msg=\"Login failed\"", new Object[]{username, currentNbFail, now, this.maxAuthenticationAttempts});
                    this.broacastFailedLoginEvent(user.getUserName(), STATUS_NOT_OK, WRONG_CREDENTIALS);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Unable to get gatein user profile for user {}", new Object[]{username, e});
        }
    }

    private void resetAuthenticationAttempts(String username) {
        try {
            User user = this.orgService.getUserHandler().findUserByName(username);
            if (user != null) {
                UserProfile profile = this.orgService.getUserProfileHandler().findUserProfileByName(username);
                if (profile == null) {
                    profile = this.orgService.getUserProfileHandler().createUserProfileInstance(username);
                }
                profile.setAttribute(AUTHENTICATION_ATTEMPTS, String.valueOf(0));
                this.orgService.getUserProfileHandler().saveUserProfile(profile, true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("service=login operation=login status=ok parameters=\"username:{}, authenticationAttempts:{}, maxAuthenticationAttempts:{}\"", new Object[]{username, 0, this.maxAuthenticationAttempts});
                }
            }
        }
        catch (Exception e) {
            LOG.error("Unable to get gatein user profile for user {}", new Object[]{username, e});
        }
    }
}

