/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.LockModeType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.EntityManagerHolder;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.activity.model.ActivityFile;
import org.exoplatform.social.core.activity.model.ActivityShareAction;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ActivityStreamImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure1;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure11;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure13;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure15;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure17;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure19;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure21;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure23;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure25;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure27;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure29;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure3;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure31;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure33;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure35;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure37;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure39;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure41;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure43;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure45;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure5;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure7;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure9;
import org.exoplatform.social.core.jpa.storage.dao.ActivityDAO;
import org.exoplatform.social.core.jpa.storage.dao.ActivityShareActionDAO;
import org.exoplatform.social.core.jpa.storage.dao.ConnectionDAO;
import org.exoplatform.social.core.jpa.storage.entity.ActivityEntity;
import org.exoplatform.social.core.jpa.storage.entity.ActivityShareActionEntity;
import org.exoplatform.social.core.jpa.storage.entity.StreamItemEntity;
import org.exoplatform.social.core.jpa.storage.entity.StreamType;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.ActivityFileStoragePlugin;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;

public class RDBMSActivityStorageImpl
implements ActivityStorage {
    private static final Log LOG;
    public static final Pattern MENTION_PATTERN;
    public static final String COMMENT_PREFIX = "comment";
    private final ActivityShareActionDAO activityShareActionDAO;
    private final ActivityDAO activityDAO;
    private final ConnectionDAO connectionDAO;
    private IdentityStorage identityStorage;
    private final SpaceStorage spaceStorage;
    private final SortedSet<ActivityProcessor> activityProcessors;
    private ActivityStorage activityStorage;
    private ActivityFileStoragePlugin activityFileStorage;
    private Map<String, ActivityFileStoragePlugin> activityFileStorageByDSName = new HashMap<String, ActivityFileStoragePlugin>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;

    public RDBMSActivityStorageImpl(IdentityStorage identityStorage, SpaceStorage spaceStorage, ActivityShareActionDAO activityShareActionDAO, ActivityDAO activityDAO, ConnectionDAO connectionDAO) {
        this.identityStorage = identityStorage;
        this.activityProcessors = new TreeSet<ActivityProcessor>(RDBMSActivityStorageImpl.processorComparator());
        this.activityDAO = activityDAO;
        this.activityShareActionDAO = activityShareActionDAO;
        this.connectionDAO = connectionDAO;
        this.spaceStorage = spaceStorage;
    }

    private static Comparator<ActivityProcessor> processorComparator() {
        return new Comparator<ActivityProcessor>(){

            @Override
            public int compare(ActivityProcessor p1, ActivityProcessor p2) {
                if (p1 == null || p2 == null) {
                    throw new IllegalArgumentException("Cannot compare null ActivityProcessor");
                }
                int diff = p1.getPriority() - p2.getPriority();
                return diff == 0 ? p1.getName().compareTo(p2.getName()) : diff;
            }
        };
    }

    private ExoSocialActivity fillActivityFromEntity(ActivityEntity activityEntity, ExoSocialActivity activity) {
        if (activity == null) {
            activity = new ExoSocialActivityImpl(activityEntity.getPosterId(), activityEntity.getType(), activityEntity.getTitle(), activityEntity.getBody(), false);
        } else {
            activity.setPosterId(activityEntity.getPosterId());
            activity.setType(activityEntity.getType());
            activity.setTitle(activity.getTitle());
            activity.setBody(activity.getBody());
            activity.isComment(false);
        }
        activity.setId(String.valueOf(activityEntity.getId()));
        activity.setLikeIdentityIds(activityEntity.getLikerIds().toArray(new String[0]));
        List<ActivityShareActionEntity> shareActions = this.activityShareActionDAO.getShareActionsByActivityId(activityEntity.getId());
        if (CollectionUtils.isNotEmpty(shareActions)) {
            activity.setShareActions(shareActions.stream().map(this::fromEntity).collect(Collectors.toSet()));
        }
        activity.setTemplateParams((Map)(activityEntity.getTemplateParams() != null ? new LinkedHashMap<String, String>(activityEntity.getTemplateParams()) : new HashMap()));
        String ownerIdentityId = activityEntity.getOwnerId();
        ActivityStreamImpl stream = new ActivityStreamImpl();
        Identity owner = this.identityStorage.findIdentityById(ownerIdentityId);
        if (owner != null) {
            stream.setType(owner.getProviderId());
            stream.setPrettyId(owner.getRemoteId());
            stream.setId(owner.getId());
            activity.setStreamOwner(owner.getRemoteId());
        } else {
            LOG.warn((Object)("Cannot find stream of activity " + activityEntity.getId() + " since identity " + ownerIdentityId + " does not exist"));
        }
        activity.setActivityStream((ActivityStream)stream);
        activity.setPosterId(activityEntity.getPosterId());
        activity.isLocked(activityEntity.getLocked().booleanValue());
        activity.isHidden(activityEntity.getHidden().booleanValue());
        activity.setTitleId(activityEntity.getTitleId());
        activity.setPostedTime(Long.valueOf(activityEntity.getPosted() != null ? activityEntity.getPosted().getTime() : 0L));
        activity.setUpdated(Long.valueOf(activityEntity.getUpdatedDate().getTime()));
        ArrayList<String> commentPosterIds = new ArrayList<String>();
        ArrayList<String> replyToIds = new ArrayList<String>();
        this.fillCommentsIdsAndPosters(activityEntity, commentPosterIds, replyToIds, false);
        activity.setCommentedIds(commentPosterIds.toArray(new String[commentPosterIds.size()]));
        activity.setReplyToId(replyToIds.toArray(new String[replyToIds.size()]));
        activity.setMentionedIds(activityEntity.getMentionerIds().toArray(new String[activityEntity.getMentionerIds().size()]));
        return activity;
    }

    private void fillCommentsIdsAndPosters(ActivityEntity activity, List<String> commentPosterIds, List<String> replyToIds, boolean isSubComment) {
        List<ActivityEntity> comments = this.activityDAO.findCommentsAndSubCommentsOfActivity(activity.getId());
        ArrayList<Long> commentIds = new ArrayList<Long>();
        for (ActivityEntity comment : comments) {
            if (!commentPosterIds.contains(comment.getPosterId())) {
                commentPosterIds.add(comment.getPosterId());
            }
            replyToIds.add(this.getExoCommentID(comment.getId()));
            commentIds.add(comment.getId());
        }
    }

    private ExoSocialActivity convertActivityEntityToActivity(ActivityEntity activityEntity) {
        if (activityEntity == null) {
            return null;
        }
        ExoSocialActivity activity = this.fillActivityFromEntity(activityEntity, null);
        this.processActivity(activity);
        return activity;
    }

    private ActivityEntity convertActivityToActivityEntity(ExoSocialActivity activity, String ownerId) {
        Map params;
        this.preSaveProcessActivity(activity);
        ActivityEntity activityEntity = new ActivityEntity();
        if (activity.getId() != null) {
            activityEntity = (ActivityEntity)this.activityDAO.find(Long.valueOf(activity.getId()));
        }
        activityEntity.setTitle(activity.getTitle());
        activityEntity.setTitleId(activity.getTitleId());
        activityEntity.setType(activity.getType());
        activityEntity.setBody(activity.getBody());
        if (ownerId != null) {
            activityEntity.setPosterId(activity.getUserId() != null ? activity.getUserId() : ownerId);
        }
        if (activity.getLikeIdentityIds() != null) {
            activityEntity.setLikerIds(new HashSet<String>(Arrays.asList(activity.getLikeIdentityIds())));
        }
        if ((params = activity.getTemplateParams()) != null) {
            activityEntity.setTemplateParams(params);
        }
        this.processDates(activityEntity);
        activityEntity.setLocked(activity.isLocked());
        activityEntity.setHidden(activity.isHidden());
        activityEntity.setMentionerIds(new HashSet<String>(Arrays.asList(this.processMentions(activity.getTitle(), activity.getTemplateParams()))));
        return activityEntity;
    }

    private ExoSocialActivity convertCommentEntityToComment(ActivityEntity comment) {
        Set<String> likers;
        ExoSocialActivityImpl exoComment = new ExoSocialActivityImpl(comment.getPosterId(), null, comment.getTitle(), comment.getBody(), false);
        exoComment.setId(this.getExoCommentID(comment.getId()));
        exoComment.setTitle(comment.getTitle());
        exoComment.setType(comment.getType());
        exoComment.setTitleId(comment.getTitleId());
        exoComment.setBody(comment.getBody());
        exoComment.setTemplateParams((Map)(comment.getTemplateParams() != null ? new LinkedHashMap<String, String>(comment.getTemplateParams()) : new HashMap()));
        exoComment.setPosterId(comment.getPosterId());
        exoComment.isComment(true);
        exoComment.isLocked(comment.getLocked() != null && comment.getLocked() != false);
        exoComment.isHidden(comment.getHidden() != null && comment.getHidden() != false);
        exoComment.setUpdated(comment.getUpdatedDate() != null ? Long.valueOf(comment.getUpdatedDate().getTime()) : null);
        ActivityEntity parentActivity = this.getTopParentActivity(comment);
        exoComment.setParentId(parentActivity == null ? null : String.valueOf(parentActivity.getId()));
        exoComment.setParentCommentId(this.isSubComment(comment) ? this.getExoCommentID(comment.getParent().getId()) : null);
        exoComment.setPostedTime(Long.valueOf(comment.getPosted() != null ? comment.getPosted().getTime() : 0L));
        exoComment.setUpdated(comment.getUpdatedDate() != null ? Long.valueOf(comment.getUpdatedDate().getTime()) : null);
        Set<String> mentioned = comment.getMentionerIds();
        if (mentioned != null && !mentioned.isEmpty()) {
            exoComment.setMentionedIds(comment.getMentionerIds().toArray(new String[mentioned.size()]));
        }
        if ((likers = comment.getLikerIds()) != null && !likers.isEmpty()) {
            exoComment.setLikeIdentityIds(comment.getLikerIds().toArray(new String[likers.size()]));
        }
        this.processActivity((ExoSocialActivity)exoComment);
        return exoComment;
    }

    private ActivityEntity getTopParentActivity(ActivityEntity activity) {
        ActivityEntity parent = activity.getParent();
        if (parent == null || parent.getId() == activity.getId()) {
            return activity;
        }
        return this.getTopParentActivity(parent);
    }

    private boolean isSubComment(ActivityEntity comment) {
        return comment.getParent() != null && comment.getParent().isComment();
    }

    private List<ExoSocialActivity> convertCommentEntitiesToComments(List<ActivityEntity> comments) {
        return this.convertCommentEntitiesToComments(comments, false, false);
    }

    private List<ExoSocialActivity> convertCommentEntitiesToComments(List<ActivityEntity> comments, boolean loadSubComments) {
        return this.convertCommentEntitiesToComments(comments, false, false);
    }

    private List<ExoSocialActivity> convertCommentEntitiesToComments(List<ActivityEntity> comments, boolean loadSubComments, boolean sortDescending) {
        if (comments == null || comments.isEmpty()) {
            return Collections.emptyList();
        }
        if (loadSubComments) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (ActivityEntity activityEntity : comments) {
                ids.add(activityEntity.getId());
            }
            List<ActivityEntity> subComments = this.activityDAO.findCommentsOfActivities(ids);
            if (subComments != null && !subComments.isEmpty()) {
                comments.addAll(subComments);
            }
            Collections.sort(comments, new CommentComparator(sortDescending));
        }
        return comments.stream().map(comment -> this.convertCommentEntityToComment((ActivityEntity)comment)).collect(Collectors.toList());
    }

    private ActivityEntity convertCommentToCommentEntity(ActivityEntity activityEntity, ExoSocialActivity comment) {
        if (comment.getTemplateParams() != null) {
            this.preSaveProcessActivity(comment);
        }
        ActivityEntity commentEntity = new ActivityEntity();
        if (comment.getId() != null) {
            commentEntity = (ActivityEntity)this.activityDAO.find(this.getCommentID(comment.getId()));
        }
        if (comment.getParentCommentId() != null) {
            ActivityEntity parentCommentEntity = (ActivityEntity)this.activityDAO.find(this.getCommentID(comment.getParentCommentId()));
            parentCommentEntity.addComment(commentEntity);
        } else {
            activityEntity.addComment(commentEntity);
        }
        commentEntity.setComment(true);
        commentEntity.setTitle(comment.getTitle());
        commentEntity.setTitleId(comment.getTitleId());
        commentEntity.setType(comment.getType());
        commentEntity.setBody(comment.getBody());
        commentEntity.setPosterId(comment.getPosterId() != null ? comment.getPosterId() : comment.getUserId());
        if (comment.getTemplateParams() != null) {
            commentEntity.setTemplateParams(comment.getTemplateParams());
        }
        commentEntity.setLocked(comment.isLocked());
        commentEntity.setHidden(comment.isHidden());
        this.processDates(commentEntity);
        commentEntity.setMentionerIds(new HashSet<String>(Arrays.asList(this.processMentions(comment.getTitle(), comment.getTemplateParams()))));
        return commentEntity;
    }

    private void updateActivityMentions(ActivityEntity activityEntity, ExoSocialActivity activity) {
        HashSet commentMentions = new HashSet();
        if (activityEntity.getComments() != null) {
            activityEntity.getComments().forEach(comment -> {
                String[] mentions = this.processMentions(comment.getTitle(), comment.getTemplateParams());
                commentMentions.addAll(Arrays.asList(mentions));
            });
        }
        HashSet<String> mentionsToRemove = new HashSet<String>(Arrays.asList(this.processMentions(activityEntity.getTitle(), activityEntity.getTemplateParams())));
        HashSet<String> mentionToAdd = new HashSet<String>(Arrays.asList(this.processMentions(activity.getTitle(), activity.getTemplateParams())));
        mentionsToRemove.forEach(mentionedId -> {
            if (!commentMentions.contains(mentionedId) && !mentionToAdd.contains(mentionedId)) {
                StreamItemEntity item = new StreamItemEntity(StreamType.MENTIONER);
                item.setOwnerId(Long.parseLong(mentionedId));
                activityEntity.removeStreamItem(item);
            }
        });
        mentionToAdd.forEach(mentionedId -> {
            if (!commentMentions.contains(mentionedId) && !mentionsToRemove.contains(mentionedId)) {
                this.mention(activityEntity, new String[]{mentionedId});
            }
        });
        mentionToAdd.addAll(commentMentions);
        activityEntity.setMentionerIds(mentionToAdd);
    }

    private List<ExoSocialActivity> convertActivityIdsToActivities(List<Long> activityIds) {
        if (activityIds == null) {
            return Collections.emptyList();
        }
        return activityIds.stream().map(activityId -> this.getActivityStorage().getActivity(String.valueOf(activityId))).collect(Collectors.toList());
    }

    private List<ExoSocialActivity> convertActivityEntitiesToActivities(List<ActivityEntity> activities) {
        if (activities == null) {
            return Collections.emptyList();
        }
        return activities.stream().map(activity -> this.convertActivityEntityToActivity((ActivityEntity)activity)).collect(Collectors.toList());
    }

    @ExoTransactional
    public ExoSocialActivity getActivity(String activityId) {
        String string = activityId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        RDBMSActivityStorageImpl$AjcClosure1 rDBMSActivityStorageImpl$AjcClosure1 = new RDBMSActivityStorageImpl$AjcClosure1(objectArray);
        return (ExoSocialActivity)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public boolean isActivityExists(String activityId) {
        if (activityId == null || activityId.isEmpty()) {
            return false;
        }
        Long id = null;
        id = activityId.startsWith(COMMENT_PREFIX) ? this.getCommentID(activityId) : Long.valueOf(activityId);
        return this.activityDAO.find(id) != null;
    }

    public ExoSocialActivity getComment(String commentId) {
        try {
            ActivityEntity entity = (ActivityEntity)this.activityDAO.find(this.getCommentID(commentId));
            if (entity != null && entity.isComment()) {
                return this.convertCommentEntityToComment(entity);
            }
            return null;
        }
        catch (Exception e) {
            if (PropertyManager.isDevelopping()) {
                throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_GET_ACTIVITY, e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public List<ExoSocialActivity> getUserActivities(Identity owner) {
        return this.getUserActivities(owner, 0L, -1L);
    }

    public List<ExoSocialActivity> getUserActivities(Identity owner, long offset, long limit) {
        return this.getUserActivitiesForUpgrade(owner, offset, limit);
    }

    public List<String> getUserSpacesActivityIds(Identity ownerIdentity, int offset, int limit) {
        return this.activityDAO.getUserSpacesActivityIds(ownerIdentity, offset, limit, this.memberOfSpaceIds(ownerIdentity));
    }

    public List<String> getUserIdsActivities(Identity owner, long offset, long limit) {
        return this.activityDAO.getUserIdsActivities(owner, offset, limit);
    }

    @ExoTransactional
    public List<ExoSocialActivity> getUserActivitiesForUpgrade(Identity owner, long offset, long limit) {
        Identity identity = owner;
        long l = offset;
        long l2 = limit;
        Object[] objectArray = new Object[]{identity, Conversions.longObject((long)l), Conversions.longObject((long)l2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, Conversions.longObject((long)l), Conversions.longObject((long)l2), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure3 rDBMSActivityStorageImpl$AjcClosure3 = new RDBMSActivityStorageImpl$AjcClosure3(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getActivities(Identity owner, Identity viewer, long offset, long limit) {
        Identity identity = owner;
        Identity identity2 = viewer;
        long l = offset;
        long l2 = limit;
        Object[] objectArray = new Object[]{identity, identity2, Conversions.longObject((long)l), Conversions.longObject((long)l2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, identity2, Conversions.longObject((long)l), Conversions.longObject((long)l2), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure5 rDBMSActivityStorageImpl$AjcClosure5 = new RDBMSActivityStorageImpl$AjcClosure5(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public List<ExoSocialActivity> getAllActivities(int index, int limit) {
        return this.convertActivityEntitiesToActivities(this.activityDAO.getAllActivities());
    }

    @ExoTransactional
    public void saveComment(ExoSocialActivity activity, ExoSocialActivity eXoComment) {
        ExoSocialActivity exoSocialActivity = activity;
        ExoSocialActivity exoSocialActivity2 = eXoComment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)exoSocialActivity, (Object)exoSocialActivity2);
        Object[] objectArray = new Object[]{this, exoSocialActivity, exoSocialActivity2, joinPoint};
        RDBMSActivityStorageImpl$AjcClosure7 rDBMSActivityStorageImpl$AjcClosure7 = new RDBMSActivityStorageImpl$AjcClosure7(objectArray);
        ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    private void saveStreamItemForCommenter(Identity commenter, ActivityEntity activityEntity) {
        Identity ownerActivity = this.identityStorage.findIdentityById(activityEntity.getOwnerId());
        if (!"space".equals(ownerActivity.getProviderId())) {
            this.createStreamItem(StreamType.COMMENTER, activityEntity, Long.parseLong(commenter.getId()));
        }
    }

    private Set<String> processMentionOfComment(ActivityEntity activityEntity, ActivityEntity commentEntity, String[] activityMentioners, String[] commentMentioners, boolean isAdded) {
        HashSet<String> mentioners = new HashSet<String>(Arrays.asList(activityMentioners));
        if (commentMentioners.length == 0) {
            return mentioners;
        }
        for (String mentioner : commentMentioners) {
            if (!mentioners.contains(mentioner) && isAdded) {
                mentioners.add(mentioner);
            }
            if (!mentioners.contains(mentioner) || isAdded || !this.isAllowedToRemove(activityEntity, commentEntity, mentioner)) continue;
            mentioners.remove(mentioner);
            StreamItemEntity item = new StreamItemEntity(StreamType.MENTIONER);
            item.setOwnerId(Long.parseLong(mentioner));
            activityEntity.removeStreamItem(item);
        }
        return mentioners;
    }

    private boolean isAllowedToRemove(ActivityEntity activity, ActivityEntity comment, String mentioner) {
        if (ArrayUtils.contains((Object[])this.processMentions(activity.getTitle(), activity.getTemplateParams()), (Object)mentioner)) {
            return false;
        }
        List<ActivityEntity> comments = activity.getComments();
        comments.remove(comment);
        for (ActivityEntity cmt : comments) {
            if (!ArrayUtils.contains((Object[])this.processMentions(cmt.getTitle(), cmt.getTemplateParams()), (Object)mentioner)) continue;
            return false;
        }
        return true;
    }

    public ExoSocialActivity saveActivity(Identity owner, ExoSocialActivity activity) {
        boolean isNew;
        boolean bl = isNew = activity.getId() == null;
        if (CollectionUtils.isNotEmpty((Collection)activity.getFiles())) {
            try {
                this.storeFile(owner, activity);
            }
            catch (Exception e) {
                throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_ATTACH_FILES_TO_ACTIVITY, "Failed to attach files into activity " + activity.getId(), (Throwable)e);
            }
        }
        ActivityEntity entity = this.convertActivityToActivityEntity(activity, owner.getId());
        entity.setOwnerId(owner.getId());
        entity.setProviderId(owner.getProviderId());
        this.saveStreamItem(owner, entity);
        entity = (ActivityEntity)this.activityDAO.create(entity);
        activity.setId(Long.toString(entity.getId()));
        if (isNew) {
            this.fillActivityFromEntity(entity, activity);
        }
        return activity;
    }

    public void addFileStoragePlugin(ActivityFileStoragePlugin fileStoragePlugin) {
        if (this.activityFileStorage == null || this.activityFileStorage.getPriority() < fileStoragePlugin.getPriority()) {
            this.activityFileStorage = fileStoragePlugin;
        }
        this.activityFileStorageByDSName.put(fileStoragePlugin.getDatasourceName(), fileStoragePlugin);
    }

    private void storeFile(Identity streamOwner, ExoSocialActivity activity) throws Exception {
        if (this.activityFileStorage == null) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_ATTACH_FILES_TO_ACTIVITY, "No configured file storage plugin");
        }
        List files = activity.getFiles();
        if (CollectionUtils.isNotEmpty((Collection)files)) {
            for (ActivityFile activityFile : files) {
                ActivityFileStoragePlugin activityFileStoragePlugin = this.activityFileStorage;
                if (StringUtils.isNotBlank((CharSequence)activityFile.getStorage())) {
                    if (this.activityFileStorageByDSName.containsKey(activityFile.getStorage())) {
                        activityFileStoragePlugin = this.activityFileStorageByDSName.get(activityFile.getStorage());
                    } else {
                        LOG.warn("No file storage plugin for datasource with name '{}'", new Object[]{activityFile.getStorage()});
                    }
                }
                if (StringUtils.isEmpty((CharSequence)activityFile.getId()) && StringUtils.isNotEmpty((CharSequence)activityFile.getUploadId())) {
                    try {
                        activityFileStoragePlugin.storeAttachments(activity, streamOwner, activityFile);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error while adding attachment to activity " + activityFile.getName()), (Throwable)e);
                    }
                    continue;
                }
                try {
                    activityFileStoragePlugin.attachExistingFile(activity, streamOwner, activityFile);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error while adding attachment to activity " + activityFile.getId()), (Throwable)e);
                }
            }
            activity.getTemplateParams().put("MESSAGE", activity.getTitle());
        }
    }

    private void spaceMembers(Identity spaceOwner, ActivityEntity activity) {
        this.createStreamItem(StreamType.SPACE, activity, Long.parseLong(spaceOwner.getId()));
        this.createStreamItem(StreamType.SPACE, activity, Long.parseLong(activity.getPosterId()));
    }

    private void saveStreamItem(Identity owner, ActivityEntity activity) {
        if ("organization".equals(owner.getProviderId())) {
            this.poster(owner, activity);
        } else {
            this.spaceMembers(owner, activity);
        }
        this.mention(activity, this.processMentions(activity.getTitle(), activity.getTemplateParams()));
    }

    private void poster(Identity owner, ActivityEntity activity) {
        this.createStreamItem(StreamType.POSTER, activity, Long.parseLong(activity.getPosterId()));
        if (!owner.getId().equals(activity.getPosterId())) {
            this.createStreamItem(StreamType.POSTER, activity, Long.parseLong(owner.getId()));
        }
    }

    private void mention(ActivityEntity activity, String[] mentions) {
        for (String mentioner : mentions) {
            Identity identity = this.identityStorage.findIdentityById(mentioner);
            if (identity == null) continue;
            this.createStreamItem(StreamType.MENTIONER, activity, Long.parseLong(identity.getId()));
        }
    }

    private void createStreamItem(StreamType streamType, ActivityEntity activity, Long ownerId) {
        boolean isExist;
        StreamItemEntity streamItem = new StreamItemEntity(streamType);
        streamItem.setOwnerId(ownerId);
        if (streamType == StreamType.POSTER || streamType == StreamType.SPACE || streamType == StreamType.MENTIONER || streamType == StreamType.COMMENTER) {
            streamItem.setUpdatedDate(activity.getUpdatedDate());
        } else {
            streamItem.setUpdatedDate(null);
        }
        boolean bl = isExist = activity.getId() != null && activity.getStreamItems().stream().anyMatch(item -> item.getOwnerId().equals(ownerId) && streamType.equals((Object)item.getStreamType()));
        if (!isExist) {
            activity.addStreamItem(streamItem);
        }
    }

    private String[] processMentions(String title, Map<String, String> templateParams) {
        HashSet<String> mentions = new HashSet<String>();
        mentions.addAll(this.parseMention(title));
        this.getTemplateParamToProcess(templateParams).forEach(param -> mentions.addAll(this.parseMention((String)param)));
        return mentions.toArray(new String[mentions.size()]);
    }

    private Set<String> parseMention(String str) {
        if (str == null || str.length() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> mentions = new HashSet<String>();
        Matcher matcher = MENTION_PATTERN.matcher(str);
        while (matcher.find()) {
            String remoteId = matcher.group().substring(1);
            Identity identity = this.identityStorage.findIdentity("organization", remoteId);
            if (identity == null || mentions.contains(identity.getId())) continue;
            mentions.add(identity.getId());
        }
        return mentions;
    }

    private List<String> getTemplateParamToProcess(Map<String, String> templateParams) {
        ArrayList<String> params = new ArrayList<String>();
        if (templateParams != null && templateParams.containsKey("registeredKeysForProcessor")) {
            String[] templateParamKeys;
            for (String key : templateParamKeys = templateParams.get("registeredKeysForProcessor").split("\\|")) {
                if (!templateParams.containsKey(key)) continue;
                params.add(templateParams.get(key));
            }
        }
        return params;
    }

    @ExoTransactional
    public ExoSocialActivity getParentActivity(ExoSocialActivity comment) {
        ExoSocialActivity exoSocialActivity = comment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)exoSocialActivity);
        Object[] objectArray = new Object[]{this, exoSocialActivity, joinPoint};
        RDBMSActivityStorageImpl$AjcClosure9 rDBMSActivityStorageImpl$AjcClosure9 = new RDBMSActivityStorageImpl$AjcClosure9(objectArray);
        return (ExoSocialActivity)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    public void deleteActivity(String activityId) {
        ActivityEntity a = (ActivityEntity)this.activityDAO.find(Long.valueOf(activityId));
        if (a != null) {
            this.activityDAO.delete(a);
        } else {
            LOG.warn((Object)("The activity's " + activityId + " is not found!"));
        }
    }

    public ExoSocialActivity hideActivity(String activityId) {
        ActivityEntity activityEntity = (ActivityEntity)this.activityDAO.find(Long.valueOf(activityId));
        activityEntity.setHidden(true);
        activityEntity = (ActivityEntity)this.activityDAO.update(activityEntity);
        return this.convertActivityEntityToActivity(activityEntity);
    }

    @ExoTransactional
    public void deleteComment(String activityId, String commentId) {
        String string = activityId;
        String string2 = commentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        RDBMSActivityStorageImpl$AjcClosure11 rDBMSActivityStorageImpl$AjcClosure11 = new RDBMSActivityStorageImpl$AjcClosure11(objectArray);
        ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    private boolean hasOtherComment(ActivityEntity activity, String poster) {
        for (ActivityEntity comment : activity.getComments()) {
            if (!poster.equals(comment.getPosterId())) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfUserActivities(Identity owner) {
        return this.getNumberOfUserActivitiesForUpgrade(owner);
    }

    public int getNumberOfUserActivitiesForUpgrade(Identity owner) {
        return this.activityDAO.getNumberOfUserActivities(owner);
    }

    public int getNumberOfNewerOnUserActivities(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfNewerOnUserActivities(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getNewerOnUserActivities(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getNewerUserActivities(ownerIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public int getNumberOfOlderOnUserActivities(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfOlderOnUserActivities(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getOlderOnUserActivities(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getOlderUserActivities(ownerIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public List<ExoSocialActivity> getActivityFeed(Identity ownerIdentity, int offset, int limit) {
        return this.getActivityFeedForUpgrade(ownerIdentity, offset, limit);
    }

    public List<String> getActivityIdsFeed(Identity ownerIdentity, int offset, int limit) {
        return this.activityDAO.getActivityIdsFeed(ownerIdentity, offset, limit, this.memberOfSpaceIds(ownerIdentity));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getActivityFeedForUpgrade(Identity ownerIdentity, int offset, int limit) {
        Identity identity = ownerIdentity;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{identity, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure13 rDBMSActivityStorageImpl$AjcClosure13 = new RDBMSActivityStorageImpl$AjcClosure13(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    public int getNumberOfActivitesOnActivityFeed(Identity ownerIdentity) {
        return this.getNumberOfActivitesOnActivityFeedForUpgrade(ownerIdentity);
    }

    public int getNumberOfActivitesOnActivityFeedForUpgrade(Identity ownerIdentity) {
        return this.activityDAO.getNumberOfActivitesOnActivityFeed(ownerIdentity, this.memberOfSpaceIds(ownerIdentity));
    }

    public int getNumberOfNewerOnActivityFeed(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfNewerOnActivityFeed(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getNewerOnActivityFeed(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getNewerFeedActivities(ownerIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public int getNumberOfOlderOnActivityFeed(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfOlderOnActivityFeed(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getOlderOnActivityFeed(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getOlderFeedActivities(ownerIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public List<ExoSocialActivity> getActivitiesOfConnections(Identity ownerIdentity, int offset, int limit) {
        return this.getActivitiesOfConnectionsForUpgrade(ownerIdentity, offset, limit);
    }

    public List<String> getActivityIdsOfConnections(Identity ownerIdentity, int offset, int limit) {
        return this.activityDAO.getActivityIdsOfConnections(ownerIdentity, offset, limit);
    }

    @ExoTransactional
    public List<ExoSocialActivity> getActivitiesOfConnectionsForUpgrade(Identity ownerIdentity, int offset, int limit) {
        Identity identity = ownerIdentity;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{identity, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure15 rDBMSActivityStorageImpl$AjcClosure15 = new RDBMSActivityStorageImpl$AjcClosure15(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    public int getNumberOfActivitiesOfConnections(Identity ownerIdentity) {
        return this.getNumberOfActivitiesOfConnectionsForUpgrade(ownerIdentity);
    }

    public int getNumberOfActivitiesOfConnectionsForUpgrade(Identity ownerIdentity) {
        return this.activityDAO.getNumberOfActivitiesOfConnections(ownerIdentity);
    }

    public List<ExoSocialActivity> getActivitiesOfIdentity(Identity ownerIdentity, long offset, long limit) {
        return this.getUserActivities(ownerIdentity, offset, limit);
    }

    public int getNumberOfNewerOnActivitiesOfConnections(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfNewerOnActivitiesOfConnections(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getNewerOnActivitiesOfConnections(Identity ownerIdentity, ExoSocialActivity baseActivity, long limit) {
        return this.getNewerActivitiesOfConnections(ownerIdentity, baseActivity.getUpdated().getTime(), (int)limit);
    }

    public int getNumberOfOlderOnActivitiesOfConnections(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfOlderOnActivitiesOfConnections(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getOlderOnActivitiesOfConnections(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getOlderActivitiesOfConnections(ownerIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public List<ExoSocialActivity> getUserSpacesActivities(Identity ownerIdentity, int offset, int limit) {
        return this.getUserSpacesActivitiesForUpgrade(ownerIdentity, offset, limit);
    }

    public List<String> getSpaceActivityIds(Identity spaceIdentity, int offset, int limit) {
        return this.activityDAO.getSpaceActivityIds(spaceIdentity, offset, limit);
    }

    @ExoTransactional
    public List<ExoSocialActivity> getUserSpacesActivitiesForUpgrade(Identity ownerIdentity, int offset, int limit) {
        Identity identity = ownerIdentity;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{identity, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure17 rDBMSActivityStorageImpl$AjcClosure17 = new RDBMSActivityStorageImpl$AjcClosure17(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure17.linkClosureAndJoinPoint(69648));
    }

    public int getNumberOfUserSpacesActivities(Identity ownerIdentity) {
        return this.getNumberOfUserSpacesActivitiesForUpgrade(ownerIdentity);
    }

    public int getNumberOfUserSpacesActivitiesForUpgrade(Identity ownerIdentity) {
        return this.activityDAO.getNumberOfUserSpacesActivities(ownerIdentity, this.memberOfSpaceIds(ownerIdentity));
    }

    public int getNumberOfNewerOnUserSpacesActivities(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfNewerOnUserSpacesActivities(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getNewerOnUserSpacesActivities(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getNewerUserSpacesActivities(ownerIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public int getNumberOfOlderOnUserSpacesActivities(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfOlderOnUserSpacesActivities(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getOlderOnUserSpacesActivities(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getOlderUserSpacesActivities(ownerIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public List<ExoSocialActivity> getComments(ExoSocialActivity existingActivity, boolean loadSubComments, int offset, int limit) {
        return this.getComments(existingActivity, loadSubComments, offset, limit, false);
    }

    public List<ExoSocialActivity> getComments(ExoSocialActivity existingActivity, boolean loadSubComments, int offset, int limit, boolean sortDescending) {
        long activityId = 0L;
        try {
            activityId = Long.parseLong(existingActivity.getId());
        }
        catch (NumberFormatException ex) {
            activityId = 0L;
        }
        List<ActivityEntity> comments = activityId > 0L ? this.activityDAO.getComments(activityId, offset, limit, sortDescending) : null;
        return this.convertCommentEntitiesToComments(comments, loadSubComments, sortDescending);
    }

    public int getNumberOfComments(ExoSocialActivity existingActivity) {
        return (int)this.activityDAO.getNumberOfComments(Long.valueOf(existingActivity.getId()));
    }

    public int getNumberOfNewerComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment) {
        return this.getNewerComments(existingActivity, baseComment, 0).size();
    }

    public List<ExoSocialActivity> getNewerComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment, int limit) {
        return this.getNewerComments(existingActivity, baseComment.getPostedTime(), limit);
    }

    public int getNumberOfOlderComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment) {
        return this.getOlderComments(existingActivity, baseComment, 0).size();
    }

    public List<ExoSocialActivity> getOlderComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment, int limit) {
        return this.getOlderComments(existingActivity, baseComment.getPostedTime(), limit);
    }

    @ExoTransactional
    public List<ExoSocialActivity> getNewerComments(ExoSocialActivity existingActivity, Long sinceTime, int limit) {
        ExoSocialActivity exoSocialActivity = existingActivity;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{exoSocialActivity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, exoSocialActivity, l, Conversions.intObject((int)n), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure19 rDBMSActivityStorageImpl$AjcClosure19 = new RDBMSActivityStorageImpl$AjcClosure19(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure19.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getOlderComments(ExoSocialActivity existingActivity, Long sinceTime, int limit) {
        ExoSocialActivity exoSocialActivity = existingActivity;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{exoSocialActivity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, exoSocialActivity, l, Conversions.intObject((int)n), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure21 rDBMSActivityStorageImpl$AjcClosure21 = new RDBMSActivityStorageImpl$AjcClosure21(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure21.linkClosureAndJoinPoint(69648));
    }

    public int getNumberOfNewerComments(ExoSocialActivity existingActivity, Long sinceTime) {
        return this.getNewerComments(existingActivity, sinceTime, 0).size();
    }

    public int getNumberOfOlderComments(ExoSocialActivity existingActivity, Long sinceTime) {
        return this.getOlderComments(existingActivity, sinceTime, 0).size();
    }

    public SortedSet<ActivityProcessor> getActivityProcessors() {
        return this.activityProcessors;
    }

    public void updateActivity(ExoSocialActivity existingActivity) {
        if (existingActivity == null) {
            throw new IllegalArgumentException("Activity to update cannot be null");
        }
        if (existingActivity.getTemplateParams() != null) {
            existingActivity.getTemplateParams().put("id", "");
            existingActivity.getTemplateParams().put("DOCPATH", "");
            existingActivity.getTemplateParams().put("docTitle", "");
            existingActivity.getTemplateParams().put("mimeType", "");
        }
        if (CollectionUtils.isNotEmpty((Collection)existingActivity.getFiles())) {
            try {
                ConversationState conversationstate = ConversationState.getCurrent();
                String currentUsername = conversationstate.getIdentity().getUserId();
                IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
                Identity identity = identityManager.getOrCreateIdentity("organization", currentUsername);
                this.storeFile(identity, existingActivity);
            }
            catch (Exception e) {
                throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_ATTACH_FILES_TO_ACTIVITY, "Failed to attach files into activity " + existingActivity.getId(), (Throwable)e);
            }
        }
        ActivityEntity parentActivity = null;
        ActivityEntity updatedActivity = null;
        boolean isComment = existingActivity.getId().startsWith(COMMENT_PREFIX);
        if (isComment) {
            long id = this.getCommentID(existingActivity.getId());
            updatedActivity = (ActivityEntity)this.activityDAO.find(Long.valueOf(id));
            parentActivity = this.getTopParentActivity(updatedActivity);
        } else {
            parentActivity = updatedActivity = (ActivityEntity)this.activityDAO.find(Long.valueOf(existingActivity.getId()));
        }
        if (updatedActivity != null) {
            if (existingActivity.getTemplateParams() != null) {
                this.preSaveProcessActivity(existingActivity);
            }
            if (existingActivity.getUpdated() != null && updatedActivity.getUpdatedDate() != null && existingActivity.getUpdated().getTime() != updatedActivity.getUpdatedDate().getTime()) {
                this.processActivityStreamUpdatedTime(updatedActivity);
            }
            this.processLikerActivityInStreams(new HashSet<String>(Arrays.asList(existingActivity.getLikeIdentityIds())), new HashSet<String>(updatedActivity.getLikerIds()), parentActivity, isComment);
            this.updateActivityMentions(updatedActivity, existingActivity);
            if (existingActivity.getTitleId() != null) {
                updatedActivity.setTitleId(existingActivity.getTitleId());
            }
            if (existingActivity.getType() != null) {
                updatedActivity.setType(existingActivity.getType());
            }
            if (existingActivity.getTitle() != null) {
                updatedActivity.setTitle(existingActivity.getTitle());
            }
            if (existingActivity.getBody() != null) {
                updatedActivity.setBody(existingActivity.getBody());
            }
            if (existingActivity.getLikeIdentityIds() != null) {
                updatedActivity.setLikerIds(new HashSet<String>(Arrays.asList(existingActivity.getLikeIdentityIds())));
            }
            if (existingActivity.getPermaLink() != null) {
                updatedActivity.setPermaLink(existingActivity.getPermaLink());
            }
            if (existingActivity.getTemplateParams() != null) {
                Map<String, String> updatedActivityTemplateParams = updatedActivity.getTemplateParams();
                updatedActivityTemplateParams.putAll(existingActivity.getTemplateParams());
                updatedActivity.setTemplateParams(updatedActivityTemplateParams);
            }
            if (existingActivity.getUpdated() != null) {
                updatedActivity.setUpdatedDate(existingActivity.getUpdated());
            }
        } else {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_UPDATE_ACTIVITY, "Cannot find activity with id=" + existingActivity.getId());
        }
        updatedActivity.setHidden(existingActivity.isHidden());
        updatedActivity.setComment(existingActivity.isComment());
        updatedActivity.setLocked(existingActivity.isLocked());
        this.activityDAO.update(updatedActivity);
    }

    private void processLikerActivityInStreams(Set<String> newLikerList, Set<String> oldLikerList, ActivityEntity activity, boolean commentLike) {
        for (String id : newLikerList) {
            if (!oldLikerList.contains(id)) {
                this.createStreamItem(commentLike ? StreamType.COMMENT_LIKER : StreamType.LIKER, activity, Long.parseLong(id));
                continue;
            }
            oldLikerList.remove(id);
        }
        if (!oldLikerList.isEmpty()) {
            for (String id : oldLikerList) {
                StreamItemEntity item = new StreamItemEntity(StreamType.LIKER);
                item.setOwnerId(Long.parseLong(id));
                activity.removeStreamItem(item);
                item.setStreamType(StreamType.COMMENT_LIKER);
                activity.removeStreamItem(item);
            }
        }
    }

    public int getNumberOfNewerOnActivityFeed(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfNewerOnActivityFeed(ownerIdentity, sinceTime, this.memberOfSpaceIds(ownerIdentity));
    }

    public int getNumberOfNewerOnUserActivities(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfNewerOnUserActivities(ownerIdentity, sinceTime);
    }

    public int getNumberOfNewerOnActivitiesOfConnections(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfNewerOnActivitiesOfConnections(ownerIdentity, sinceTime);
    }

    public int getNumberOfNewerOnUserSpacesActivities(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfNewerOnUserSpacesActivities(ownerIdentity, sinceTime, this.memberOfSpaceIds(ownerIdentity));
    }

    public int getNumberOfSpaceActivities(Identity spaceIdentity) {
        return this.getNumberOfSpaceActivitiesForUpgrade(spaceIdentity);
    }

    public int getNumberOfSpaceActivitiesForUpgrade(Identity spaceIdentity) {
        return this.activityDAO.getNumberOfSpaceActivities(spaceIdentity);
    }

    @ExoTransactional
    public List<ExoSocialActivity> getSpaceActivities(Identity spaceIdentity, int offset, int limit) {
        Identity identity = spaceIdentity;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{identity, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure23 rDBMSActivityStorageImpl$AjcClosure23 = new RDBMSActivityStorageImpl$AjcClosure23(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure23.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getSpaceActivitiesForUpgrade(Identity spaceIdentity, int offset, int limit) {
        Identity identity = spaceIdentity;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{identity, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure25 rDBMSActivityStorageImpl$AjcClosure25 = new RDBMSActivityStorageImpl$AjcClosure25(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure25.linkClosureAndJoinPoint(69648));
    }

    public List<ExoSocialActivity> getActivitiesByPoster(Identity posterIdentity, int offset, int limit) {
        return this.getActivitiesByPoster(posterIdentity, offset, limit, new String[0]);
    }

    public List<ExoSocialActivity> getActivitiesByPoster(Identity posterIdentity, int offset, int limit, String ... activityTypes) {
        return this.convertActivityIdsToActivities(this.activityDAO.getActivitiesByPoster(posterIdentity, offset, limit, activityTypes));
    }

    public int getNumberOfActivitiesByPoster(Identity posterIdentity) {
        return this.activityDAO.getNumberOfActivitiesByPoster(posterIdentity, new String[0]);
    }

    public int getNumberOfActivitiesByPoster(Identity ownerIdentity, Identity viewerIdentity) {
        return 0;
    }

    public List<ExoSocialActivity> getNewerOnSpaceActivities(Identity spaceIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getNewerSpaceActivities(spaceIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public int getNumberOfNewerOnSpaceActivities(Identity spaceIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfNewerOnSpaceActivities(spaceIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getOlderOnSpaceActivities(Identity spaceIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getOlderSpaceActivities(spaceIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public int getNumberOfOlderOnSpaceActivities(Identity spaceIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfOlderOnSpaceActivities(spaceIdentity, baseActivity.getUpdated().getTime());
    }

    public int getNumberOfNewerOnSpaceActivities(Identity spaceIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfNewerOnSpaceActivities(spaceIdentity, sinceTime);
    }

    @ExoTransactional
    public List<ExoSocialActivity> getNewerFeedActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure27 rDBMSActivityStorageImpl$AjcClosure27 = new RDBMSActivityStorageImpl$AjcClosure27(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure27.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getNewerUserActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure29 rDBMSActivityStorageImpl$AjcClosure29 = new RDBMSActivityStorageImpl$AjcClosure29(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure29.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getNewerUserSpacesActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure31 rDBMSActivityStorageImpl$AjcClosure31 = new RDBMSActivityStorageImpl$AjcClosure31(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure31.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getNewerActivitiesOfConnections(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure33 rDBMSActivityStorageImpl$AjcClosure33 = new RDBMSActivityStorageImpl$AjcClosure33(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure33.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getNewerSpaceActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure35 rDBMSActivityStorageImpl$AjcClosure35 = new RDBMSActivityStorageImpl$AjcClosure35(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure35.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getOlderFeedActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure37 rDBMSActivityStorageImpl$AjcClosure37 = new RDBMSActivityStorageImpl$AjcClosure37(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure37.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getOlderUserActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure39 rDBMSActivityStorageImpl$AjcClosure39 = new RDBMSActivityStorageImpl$AjcClosure39(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure39.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getOlderUserSpacesActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure41 rDBMSActivityStorageImpl$AjcClosure41 = new RDBMSActivityStorageImpl$AjcClosure41(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure41.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getOlderActivitiesOfConnections(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure43 rDBMSActivityStorageImpl$AjcClosure43 = new RDBMSActivityStorageImpl$AjcClosure43(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure43.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getOlderSpaceActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        RDBMSActivityStorageImpl$AjcClosure45 rDBMSActivityStorageImpl$AjcClosure45 = new RDBMSActivityStorageImpl$AjcClosure45(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(rDBMSActivityStorageImpl$AjcClosure45.linkClosureAndJoinPoint(69648));
    }

    public int getNumberOfOlderOnActivityFeed(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfOlderOnActivityFeed(ownerIdentity, sinceTime, this.memberOfSpaceIds(ownerIdentity));
    }

    public int getNumberOfOlderOnUserActivities(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfOlderOnUserActivities(ownerIdentity, sinceTime);
    }

    public int getNumberOfOlderOnActivitiesOfConnections(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfOlderOnActivitiesOfConnections(ownerIdentity, sinceTime);
    }

    public int getNumberOfOlderOnUserSpacesActivities(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfOlderOnUserSpacesActivities(ownerIdentity, sinceTime, this.memberOfSpaceIds(ownerIdentity));
    }

    public int getNumberOfOlderOnSpaceActivities(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfOlderOnSpaceActivities(ownerIdentity, sinceTime);
    }

    public List<ExoSocialActivity> getSubComments(ExoSocialActivity comment) {
        long commentId = this.getCommentID(comment.getId());
        List<ActivityEntity> subComments = this.activityDAO.getComments(commentId, 0, -1, false);
        return this.convertCommentEntitiesToComments(subComments, false);
    }

    public Set<Long> getStreamFeedOwnerIds(Identity identity) {
        Set<Long> connectionIds;
        HashSet<Long> owners = new HashSet<Long>();
        long identityId = Long.parseLong(identity.getId());
        owners.add(identityId);
        List<String> spaceIds = this.memberOfSpaceIds(identity);
        if (spaceIds != null) {
            owners.addAll(spaceIds.stream().map(spaceId -> Long.parseLong(spaceId)).collect(Collectors.toList()));
        }
        if ((connectionIds = this.connectionDAO.getConnectionIds(identityId, Relationship.Type.CONFIRMED)) != null) {
            owners.addAll(connectionIds);
        }
        return owners;
    }

    public ActivityShareAction createShareActivityAction(ActivityShareAction activityShareAction) {
        ActivityShareActionEntity actionEntity = this.toEntity(activityShareAction);
        actionEntity.setId(null);
        actionEntity.setShareDate(new Date());
        actionEntity = (ActivityShareActionEntity)this.activityShareActionDAO.create(actionEntity);
        return this.fromEntity(actionEntity);
    }

    private Long getCommentID(String commentId) {
        return commentId == null || commentId.trim().isEmpty() ? null : Long.valueOf(commentId.replace(COMMENT_PREFIX, ""));
    }

    private String getExoCommentID(Long commentId) {
        return String.valueOf(COMMENT_PREFIX + commentId);
    }

    private void preSaveProcessActivity(ExoSocialActivity existingActivity) {
        this.processActivity(existingActivity, true);
    }

    private void processActivity(ExoSocialActivity existingActivity) {
        this.processActivity(existingActivity, false);
    }

    private void processActivity(ExoSocialActivity existingActivity, boolean preSave) {
        HashMap templateParams = existingActivity.getTemplateParams();
        if (templateParams == null) {
            templateParams = new HashMap();
            existingActivity.setTemplateParams(templateParams);
        }
        for (ActivityProcessor processor : this.activityProcessors) {
            if (preSave && !processor.isPreActivityProcessor() || !preSave && !processor.isReadActivityProcessor()) continue;
            try {
                processor.processActivity(existingActivity);
            }
            catch (Exception e) {
                LOG.warn((Object)"Activity processing failed", (Throwable)e);
            }
        }
    }

    private ActivityEntity processActivityStreamUpdatedTime(ActivityEntity activityEntity) {
        List items;
        if (activityEntity.getStreamItems() != null && !(items = activityEntity.getStreamItems().stream().filter(item -> item.getStreamType() == StreamType.POSTER || item.getStreamType() == StreamType.SPACE).collect(Collectors.toList())).isEmpty()) {
            Date now = new Date();
            items.stream().forEach(item -> item.setUpdatedDate(now));
        }
        return activityEntity;
    }

    private List<String> memberOfSpaceIds(Identity ownerIdentity) {
        return this.spaceStorage.getMemberSpaceIds(ownerIdentity.getId(), 0, -1);
    }

    public void setIdentityStorage(IdentityStorage identityStorage) {
        this.identityStorage = identityStorage;
    }

    public ActivityStorage getActivityStorage() {
        if (this.activityStorage == null) {
            this.activityStorage = (ActivityStorage)CommonsUtils.getService(ActivityStorage.class);
            if (this.activityStorage == null) {
                this.activityStorage = this;
            }
        }
        return this.activityStorage;
    }

    public List<ExoSocialActivity> getActivities(List<String> activityIdList) {
        if (activityIdList == null || activityIdList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> activityIds = new ArrayList<Long>();
        for (String activityId : activityIdList) {
            if (activityId == null || activityId.isEmpty()) continue;
            if (activityId.startsWith(COMMENT_PREFIX)) {
                activityIds.add(this.getCommentID(activityId));
                continue;
            }
            activityIds.add(Long.valueOf(activityId));
        }
        List<ActivityEntity> activityEntities = this.activityDAO.findActivities(activityIds);
        if (activityEntities == null || activityEntities.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ExoSocialActivity> activityDTOs = new ArrayList<ExoSocialActivity>();
        for (ActivityEntity activityEntity : activityEntities) {
            activityDTOs.add(this.convertActivityEntityToActivity(activityEntity));
        }
        return activityDTOs;
    }

    private void processDates(ActivityEntity activityEntity) {
        Date newPosted = new Date();
        if (activityEntity.getPosted() == null) {
            activityEntity.setPosted(newPosted);
        }
        activityEntity.setUpdatedDate(newPosted);
    }

    private ActivityShareActionEntity toEntity(ActivityShareAction activityShareAction) {
        ActivityShareActionEntity actionEntity = new ActivityShareActionEntity();
        actionEntity.setActivityId(activityShareAction.getActivityId());
        actionEntity.setUserId(activityShareAction.getUserIdentityId());
        actionEntity.setShareDate(new Date(activityShareAction.getShareDate()));
        actionEntity.setSharedActivityIds(activityShareAction.getSharedActivityIds());
        actionEntity.setSharedSpaceIds(activityShareAction.getSpaceIds());
        actionEntity.setTitle(activityShareAction.getMessage());
        actionEntity.setId(activityShareAction.getId());
        return actionEntity;
    }

    private ActivityShareAction fromEntity(ActivityShareActionEntity actionEntity) {
        ActivityShareAction activityShareAction = new ActivityShareAction();
        activityShareAction.setActivityId(actionEntity.getActivityId().longValue());
        activityShareAction.setUserIdentityId(actionEntity.getUserId().longValue());
        activityShareAction.setShareDate(actionEntity.getShareDate().getTime());
        activityShareAction.setSharedActivityIds(actionEntity.getSharedActivityIds());
        activityShareAction.setSpaceIds(actionEntity.getSharedSpaceIds());
        activityShareAction.setMessage(actionEntity.getTitle());
        activityShareAction.setId(actionEntity.getId());
        return activityShareAction;
    }

    static {
        RDBMSActivityStorageImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(RDBMSActivityStorageImpl.class);
        MENTION_PATTERN = Pattern.compile("@([^\\s<]+)|@([^\\s<]+)$");
    }

    static /* synthetic */ ExoSocialActivity getActivity_aroundBody0(RDBMSActivityStorageImpl ajc$this, String activityId, JoinPoint joinPoint) {
        if (activityId == null || activityId.isEmpty()) {
            return null;
        }
        if (activityId.startsWith(COMMENT_PREFIX)) {
            return ajc$this.getComment(activityId);
        }
        try {
            ActivityEntity entity = (ActivityEntity)ajc$this.activityDAO.find(Long.valueOf(activityId));
            if (entity != null && entity.isComment()) {
                return ajc$this.convertCommentEntityToComment(entity);
            }
            return ajc$this.convertActivityEntityToActivity(entity);
        }
        catch (Exception e) {
            if (PropertyManager.isDevelopping()) {
                throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_GET_ACTIVITY, e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    static /* synthetic */ List getUserActivitiesForUpgrade_aroundBody2(RDBMSActivityStorageImpl ajc$this, Identity owner, long offset, long limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getUserActivities(owner, offset, limit));
    }

    static /* synthetic */ List getActivities_aroundBody4(RDBMSActivityStorageImpl ajc$this, Identity owner, Identity viewer, long offset, long limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getActivities(owner, viewer, offset, limit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void saveComment_aroundBody6(RDBMSActivityStorageImpl ajc$this, ExoSocialActivity activity, ExoSocialActivity eXoComment, JoinPoint joinPoint) {
        ActivityEntity activityEntity = (ActivityEntity)ajc$this.activityDAO.find(Long.valueOf(activity.getId()));
        EntityManagerHolder.get().lock((Object)activityEntity, LockModeType.PESSIMISTIC_WRITE);
        try {
            if (CollectionUtils.isNotEmpty((Collection)eXoComment.getFiles())) {
                String ownerIdentityId = activityEntity.getOwnerId();
                try {
                    Identity owner = ajc$this.identityStorage.findIdentityById(ownerIdentityId);
                    ajc$this.storeFile(owner, eXoComment);
                }
                catch (Exception e) {
                    throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_ATTACH_FILES_TO_ACTIVITY, "Failed to attach files into activity " + eXoComment.getId(), (Throwable)e);
                }
            }
            ActivityEntity commentEntity = ajc$this.convertCommentToCommentEntity(activityEntity, eXoComment);
            commentEntity = (ActivityEntity)ajc$this.activityDAO.create(commentEntity);
            eXoComment.setId(ajc$this.getExoCommentID(commentEntity.getId()));
            eXoComment.setPosterId(commentEntity.getPosterId());
            eXoComment.setParentId(String.valueOf(activity.getId()));
            eXoComment.isComment(true);
            Set<String> mentioned = commentEntity.getMentionerIds();
            if (mentioned != null && !mentioned.isEmpty()) {
                eXoComment.setMentionedIds(mentioned.toArray(new String[mentioned.size()]));
            }
            Identity commenter = ajc$this.identityStorage.findIdentityById(commentEntity.getPosterId());
            ajc$this.saveStreamItemForCommenter(commenter, activityEntity);
            String[] mentioners = ajc$this.processMentions(eXoComment.getTitle(), eXoComment.getTemplateParams());
            if (mentioners != null && mentioners.length > 0) {
                ajc$this.mention(activityEntity, mentioners);
                activityEntity.setMentionerIds(ajc$this.processMentionOfComment(activityEntity, commentEntity, activityEntity.getMentionerIds().toArray(new String[activityEntity.getMentionerIds().size()]), mentioners, true));
            }
            ajc$this.processActivityStreamUpdatedTime(activityEntity);
            ajc$this.activityDAO.update(activityEntity);
        }
        finally {
            if (EntityManagerHolder.get().isOpen() && EntityManagerHolder.get().getLockMode((Object)activityEntity) != null && EntityManagerHolder.get().getLockMode((Object)activityEntity) != LockModeType.NONE) {
                EntityManagerHolder.get().lock((Object)activityEntity, LockModeType.NONE);
            }
        }
    }

    static /* synthetic */ ExoSocialActivity getParentActivity_aroundBody8(RDBMSActivityStorageImpl ajc$this, ExoSocialActivity comment, JoinPoint joinPoint) {
        try {
            Long commentId = ajc$this.getCommentID(comment.getId());
            return ajc$this.convertActivityEntityToActivity(ajc$this.activityDAO.getParentActivity(commentId));
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)"The input ExoSocialActivity is not comment, it is Activity");
            return null;
        }
    }

    static /* synthetic */ void deleteComment_aroundBody10(RDBMSActivityStorageImpl ajc$this, String activityId, String commentId, JoinPoint joinPoint) {
        ActivityEntity comment = (ActivityEntity)ajc$this.activityDAO.find(ajc$this.getCommentID(commentId));
        ajc$this.activityDAO.delete(comment);
        ActivityEntity activity = (ActivityEntity)ajc$this.activityDAO.find(Long.valueOf(activityId));
        activity.getComments().remove(comment);
        activity.setMentionerIds(ajc$this.processMentionOfComment(activity, comment, activity.getMentionerIds().toArray(new String[activity.getMentionerIds().size()]), ajc$this.processMentions(comment.getTitle(), comment.getTemplateParams()), false));
        if (!ajc$this.hasOtherComment(activity, comment.getPosterId())) {
            StreamItemEntity item = new StreamItemEntity(StreamType.COMMENTER);
            item.setOwnerId(Long.parseLong(comment.getPosterId()));
            activity.removeStreamItem(item);
        }
        ajc$this.activityDAO.update(activity);
    }

    static /* synthetic */ List getActivityFeedForUpgrade_aroundBody12(RDBMSActivityStorageImpl ajc$this, Identity ownerIdentity, int offset, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getActivityFeed(ownerIdentity, offset, limit, ajc$this.memberOfSpaceIds(ownerIdentity)));
    }

    static /* synthetic */ List getActivitiesOfConnectionsForUpgrade_aroundBody14(RDBMSActivityStorageImpl ajc$this, Identity ownerIdentity, int offset, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getActivitiesOfConnections(ownerIdentity, offset, limit));
    }

    static /* synthetic */ List getUserSpacesActivitiesForUpgrade_aroundBody16(RDBMSActivityStorageImpl ajc$this, Identity ownerIdentity, int offset, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getUserSpacesActivities(ownerIdentity, offset, limit, ajc$this.memberOfSpaceIds(ownerIdentity)));
    }

    static /* synthetic */ List getNewerComments_aroundBody18(RDBMSActivityStorageImpl ajc$this, ExoSocialActivity existingActivity, Long sinceTime, int limit, JoinPoint joinPoint) {
        List<ActivityEntity> comments = ajc$this.activityDAO.getNewerComments(Long.valueOf(existingActivity.getId()), sinceTime > 0L ? new Date(sinceTime) : null, 0, limit);
        return ajc$this.convertCommentEntitiesToComments(comments);
    }

    static /* synthetic */ List getOlderComments_aroundBody20(RDBMSActivityStorageImpl ajc$this, ExoSocialActivity existingActivity, Long sinceTime, int limit, JoinPoint joinPoint) {
        List<ActivityEntity> comments = ajc$this.activityDAO.getOlderComments(Long.valueOf(existingActivity.getId()), sinceTime > 0L ? new Date(sinceTime) : null, 0, limit);
        return ajc$this.convertCommentEntitiesToComments(comments);
    }

    static /* synthetic */ List getSpaceActivities_aroundBody22(RDBMSActivityStorageImpl ajc$this, Identity spaceIdentity, int offset, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getSpaceActivities(spaceIdentity, offset, limit));
    }

    static /* synthetic */ List getSpaceActivitiesForUpgrade_aroundBody24(RDBMSActivityStorageImpl ajc$this, Identity spaceIdentity, int offset, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getSpaceActivities(spaceIdentity, offset, limit));
    }

    static /* synthetic */ List getNewerFeedActivities_aroundBody26(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getNewerOnActivityFeed(owner, sinceTime, limit, ajc$this.memberOfSpaceIds(owner)));
    }

    static /* synthetic */ List getNewerUserActivities_aroundBody28(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getNewerOnUserActivities(owner, sinceTime, limit));
    }

    static /* synthetic */ List getNewerUserSpacesActivities_aroundBody30(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getNewerOnUserSpacesActivities(owner, sinceTime, limit, ajc$this.memberOfSpaceIds(owner)));
    }

    static /* synthetic */ List getNewerActivitiesOfConnections_aroundBody32(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getNewerOnActivitiesOfConnections(owner, sinceTime, limit));
    }

    static /* synthetic */ List getNewerSpaceActivities_aroundBody34(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getNewerOnSpaceActivities(owner, sinceTime, limit));
    }

    static /* synthetic */ List getOlderFeedActivities_aroundBody36(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getOlderOnActivityFeed(owner, sinceTime, limit, ajc$this.memberOfSpaceIds(owner)));
    }

    static /* synthetic */ List getOlderUserActivities_aroundBody38(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getOlderOnUserActivities(owner, sinceTime, limit));
    }

    static /* synthetic */ List getOlderUserSpacesActivities_aroundBody40(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getOlderOnUserSpacesActivities(owner, sinceTime, limit, ajc$this.memberOfSpaceIds(owner)));
    }

    static /* synthetic */ List getOlderActivitiesOfConnections_aroundBody42(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getOlderOnActivitiesOfConnections(owner, sinceTime, limit));
    }

    static /* synthetic */ List getOlderSpaceActivities_aroundBody44(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityIdsToActivities(ajc$this.activityDAO.getOlderOnSpaceActivities(owner, sinceTime, limit));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RDBMSActivityStorageImpl.java", RDBMSActivityStorageImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getActivity", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "java.lang.String", "activityId", "", "org.exoplatform.social.core.activity.model.ExoSocialActivity"), 405);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserActivitiesForUpgrade", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:long:long", "owner:offset:limit", "", "java.util.List"), 481);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOlderComments", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.activity.model.ExoSocialActivity:java.lang.Long:int", "existingActivity:sinceTime:limit", "", "java.util.List"), 1116);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSpaceActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:int:int", "spaceIdentity:offset:limit", "", "java.util.List"), 1276);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSpaceActivitiesForUpgrade", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:int:int", "spaceIdentity:offset:limit", "", "java.util.List"), 1282);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNewerFeedActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1333);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNewerUserActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1339);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNewerUserSpacesActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1345);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNewerActivitiesOfConnections", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1354);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNewerSpaceActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1360);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOlderFeedActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1366);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOlderUserActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1372);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:org.exoplatform.social.core.identity.model.Identity:long:long", "owner:viewer:offset:limit", "", "java.util.List"), 490);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOlderUserSpacesActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1378);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOlderActivitiesOfConnections", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1387);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOlderSpaceActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1393);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveComment", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.activity.model.ExoSocialActivity:org.exoplatform.social.core.activity.model.ExoSocialActivity", "activity:eXoComment", "", "void"), 501);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getParentActivity", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.activity.model.ExoSocialActivity", COMMENT_PREFIX, "", "org.exoplatform.social.core.activity.model.ExoSocialActivity"), 806);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteComment", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "java.lang.String:java.lang.String", "activityId:commentId", "", "void"), 835);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getActivityFeedForUpgrade", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:int:int", "ownerIdentity:offset:limit", "", "java.util.List"), 909);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getActivitiesOfConnectionsForUpgrade", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:int:int", "ownerIdentity:offset:limit", "", "java.util.List"), 958);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserSpacesActivitiesForUpgrade", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:int:int", "ownerIdentity:offset:limit", "", "java.util.List"), 1013);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNewerComments", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.activity.model.ExoSocialActivity:java.lang.Long:int", "existingActivity:sinceTime:limit", "", "java.util.List"), 1105);
    }

    public static final class CommentComparator
    implements Comparator<ActivityEntity> {
        private final boolean sortDescending;

        public CommentComparator(boolean sortDescending) {
            this.sortDescending = sortDescending;
        }

        @Override
        public int compare(ActivityEntity o1, ActivityEntity o2) {
            boolean isParentActivity2;
            ActivityEntity parent1 = o1.getParent();
            ActivityEntity parent2 = o2.getParent();
            boolean isParentActivity1 = parent1 == null || !parent1.isComment();
            boolean bl = isParentActivity2 = parent2 == null || !parent2.isComment();
            if (isParentActivity1 && isParentActivity2) {
                return this.sortDescending ? o2.getPosted().compareTo(o1.getPosted()) : o1.getPosted().compareTo(o2.getPosted());
            }
            if (isParentActivity1) {
                return this.compare(o1, parent2);
            }
            if (isParentActivity2) {
                return this.compare(parent1, o2);
            }
            if (parent1.getId() == parent2.getId()) {
                return o1.getPosted().compareTo(o2.getPosted());
            }
            return this.compare(parent1, parent2);
        }
    }
}

