/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login.onboarding;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import javax.portlet.PortletException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.captcha.Captcha;
import nl.captcha.servlet.CaptchaServletUtil;
import nl.captcha.text.producer.DefaultTextProducer;
import nl.captcha.text.producer.TextProducer;
import nl.captcha.text.renderer.DefaultWordRenderer;
import nl.captcha.text.renderer.WordRenderer;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.login.recovery.PasswordRecoveryServiceImpl;
import org.exoplatform.web.security.security.RemindPasswordTokenService;
import org.gatein.wci.security.Credentials;

public class OnboardingHandler
extends WebRequestHandler {
    private static final QualifiedName SERVER_CAPTCHA = QualifiedName.create((String)"gtn", (String)"serveCaptcha");
    protected static Log log = ExoLogger.getLogger(OnboardingHandler.class);
    public static final String NAME = "on-boarding";
    public static final QualifiedName TOKEN = QualifiedName.create((String)"gtn", (String)"token");
    public static final QualifiedName LANG = QualifiedName.create((String)"gtn", (String)"lang");
    public static final QualifiedName INIT_URL = QualifiedName.create((String)"gtn", (String)"initURL");
    public static final String REQ_PARAM_ACTION = "action";
    private static final ThreadLocal<Locale> currentLocale = new ThreadLocal();
    protected int _width = 200;
    protected int _height = 50;

    public String getHandlerName() {
        return NAME;
    }

    public boolean execute(ControllerContext context) throws Exception {
        HttpServletRequest req = context.getRequest();
        HttpServletResponse res = context.getResponse();
        PortalContainer container = PortalContainer.getCurrentInstance((ServletContext)req.getServletContext());
        ServletContext servletContext = container.getPortalContext();
        Pattern customPasswordPattern = Pattern.compile(PropertyManager.getProperty((String)"gatein.validators.passwordpolicy.regexp"));
        int customPasswordMaxlength = Integer.parseInt(PropertyManager.getProperty((String)"gatein.validators.passwordpolicy.length.max"));
        int customPasswordMinlength = Integer.parseInt(PropertyManager.getProperty((String)"gatein.validators.passwordpolicy.length.min"));
        Locale requestLocale = null;
        String lang = context.getParameter(LANG);
        Locale locale = lang != null && lang.length() > 0 ? (requestLocale = I18N.parseTagIdentifier((String)lang)) : this.calculateLocale(context);
        currentLocale.set(locale);
        req.setAttribute("request_locale", (Object)locale);
        PasswordRecoveryServiceImpl service = this.getService(PasswordRecoveryServiceImpl.class);
        OrganizationService organizationService = this.getService(OrganizationService.class);
        ResourceBundleService bundleService = this.getService(ResourceBundleService.class);
        ResourceBundle bundle = bundleService.getResourceBundle(bundleService.getSharedResourceBundleNames(), locale);
        RemindPasswordTokenService remindPasswordTokenService = this.getService(RemindPasswordTokenService.class);
        String token = context.getParameter(TOKEN);
        String serveCaptcha = context.getParameter(SERVER_CAPTCHA);
        String requestAction = req.getParameter(REQ_PARAM_ACTION);
        if ("true".equals(serveCaptcha)) {
            return this.serveCaptchaImage(req, res);
        }
        if (token != null && !token.isEmpty()) {
            String tokenId = context.getParameter(TOKEN);
            Credentials credentials = service.verifyToken(tokenId, "onboard");
            if (credentials == null) {
                return this.dispatch("/WEB-INF/jsp/onboarding/token_expired.jsp", servletContext, req, res);
            }
            String username = credentials.getUsername();
            if ("resetPassword".equalsIgnoreCase(requestAction)) {
                String message;
                String reqUser = req.getParameter("username");
                String password = req.getParameter("password");
                String confirmPass = req.getParameter("password2");
                String captcha = req.getParameter("captcha");
                ArrayList<String> errors = new ArrayList<String>();
                String success = "";
                if (captcha == null || !this.isValid(req.getSession(), captcha)) {
                    message = bundle.getString("gatein.forgotPassword.captchaError");
                    errors.add(message);
                }
                if (reqUser == null || !reqUser.equals(username)) {
                    message = bundle.getString("gatein.forgotPassword.usernameChanged");
                    message = message.replace("{0}", username);
                    errors.add(message);
                } else {
                    if (password == null || !customPasswordPattern.matcher(password).matches() || customPasswordMaxlength < password.length() || customPasswordMinlength > password.length()) {
                        String passwordpolicyProperty = PropertyManager.getProperty((String)"gatein.validators.passwordpolicy.format.message");
                        errors.add(passwordpolicyProperty != null ? passwordpolicyProperty : bundle.getString("onboarding.login.passwordCondition"));
                    }
                    if (!password.equals(confirmPass)) {
                        errors.add(bundle.getString("gatein.forgotPassword.confirmPasswordNotMatch"));
                    }
                }
                req.getSession().removeAttribute(NAME);
                if (errors.isEmpty()) {
                    if (service.changePass(tokenId, "onboard", username, password)) {
                        success = bundle.getString("gatein.forgotPassword.resetPasswordSuccess");
                        password = "";
                        confirmPass = "";
                        String currentPortalContainerName = PortalContainer.getCurrentPortalContainerName();
                        res.sendRedirect("/" + currentPortalContainerName + "/login?email=" + organizationService.getUserHandler().findUserByName(username).getEmail());
                    } else {
                        errors.add(bundle.getString("gatein.forgotPassword.resetPasswordFailure"));
                    }
                }
                req.setAttribute("password", (Object)password);
                req.setAttribute("password2", (Object)confirmPass);
                req.setAttribute("errors", errors);
                req.setAttribute("success", (Object)success);
            }
            req.setAttribute("tokenId", (Object)tokenId);
            req.setAttribute("username", (Object)this.escapeXssCharacters(username));
            String random = "&v=" + Calendar.getInstance().getTimeInMillis();
            return this.dispatch("/WEB-INF/jsp/onboarding/reset_password.jsp", servletContext, req, res);
        }
        return false;
    }

    private boolean isValid(HttpSession session, String captchaValue) {
        Captcha captcha = (Captcha)session.getAttribute(NAME);
        return captcha != null && captcha.isCorrect(captchaValue);
    }

    protected boolean dispatch(String path, ServletContext context, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        RequestDispatcher dispatcher = context.getRequestDispatcher(path);
        if (dispatcher != null) {
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
            return true;
        }
        return false;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    private <T> T getService(Class<T> clazz) {
        return (T)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(clazz);
    }

    public static Locale getCurrentLocale() {
        return currentLocale.get();
    }

    private Locale calculateLocale(ControllerContext context) {
        Locale locale;
        LocalePolicy localePolicy = this.getService(LocalePolicy.class);
        HttpServletRequest request = (HttpServletRequest)HttpServletRequest.class.cast(context.getRequest());
        LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((HttpServletRequest)request);
        Set supportedLocales = LocaleContextInfoUtils.getSupportedLocales();
        boolean supported = supportedLocales.contains(locale = localePolicy.determineLocale(localeCtx));
        if (!supported && !"".equals(locale.getCountry())) {
            locale = new Locale(locale.getLanguage());
            supported = supportedLocales.contains(locale);
        }
        if (!supported) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Unsupported locale returned by LocalePolicy: " + localePolicy + ". Falling back to 'en'."));
            }
            locale = Locale.ENGLISH;
        }
        return locale;
    }

    public String escapeXssCharacters(String message) {
        message = message == null ? null : message.replace("&", "&amp").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;").replace("/", "&#x2F;");
        return message;
    }

    public boolean serveCaptchaImage(HttpServletRequest req, HttpServletResponse resp) throws PortletException, IOException {
        Captcha captcha;
        HttpSession session = req.getSession();
        if (session.getAttribute(NAME) == null) {
            List<Font> textFonts = Arrays.asList(new Font("Arial", 1, 40), new Font("Courier", 1, 40));
            captcha = new Captcha.Builder(this._width, this._height).addText((TextProducer)new DefaultTextProducer(5), (WordRenderer)new DefaultWordRenderer(Color.WHITE, textFonts)).gimp().addNoise().addBackground().build();
            session.setAttribute(NAME, (Object)captcha);
            OnboardingHandler.writeImage(resp, captcha.getImage());
        }
        captcha = (Captcha)session.getAttribute(NAME);
        OnboardingHandler.writeImage(resp, captcha.getImage());
        return true;
    }

    public static void writeImage(HttpServletResponse response, BufferedImage bi) {
        response.setHeader("Cache-Control", "private,no-cache,no-store");
        response.setContentType("image/png");
        try {
            CaptchaServletUtil.writeImage((OutputStream)response.getOutputStream(), (BufferedImage)bi);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

