/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request;

import juzu.Scope;
import juzu.impl.bridge.spi.ScopedContext;
import juzu.impl.common.Tools;
import juzu.impl.request.Request;
import juzu.request.Phase;

public class ContextLifeCycle {
    private Request request;

    public ContextLifeCycle(Request request) {
        this.request = request;
    }

    public void resume() {
        ContextLifeCycle lifeCycle = Request.current.get();
        if (lifeCycle != null) {
            throw new IllegalStateException("A context is already active for this thread");
        }
        Request.current.set(this);
    }

    Request getRequest() {
        return this.request;
    }

    void endContextual() {
        this.request.contextLifeCycles.remove(this);
        this.request.getScopeController().end();
        if (this.request.contextLifeCycles.isEmpty()) {
            ScopedContext requestScope;
            ScopedContext flashScope;
            if (this.request.controllerLifeCycle != null) {
                this.request.controllerLifeCycle.close();
            }
            if (this.request.getPhase() == Phase.VIEW && (flashScope = this.request.bridge.getScopedContext(Scope.FLASH, false)) != null) {
                Tools.safeClose(flashScope);
            }
            if ((requestScope = this.request.bridge.getScopedContext(Scope.REQUEST, false)) != null) {
                Tools.safeClose(requestScope);
            }
        }
    }
}

