/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.common.ListAccessValidator;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.api.RelationshipStorage;

public class ConnectionListAccess
implements ListAccess<Identity> {
    private RelationshipStorage relationshipStorage;
    Identity identity;
    Type type;

    public ConnectionListAccess(RelationshipStorage relationshipStorage, Identity identity) {
        this.relationshipStorage = relationshipStorage;
        this.identity = identity;
    }

    public ConnectionListAccess(RelationshipStorage relationshipStorage, Identity identity, Type type) {
        this(relationshipStorage, identity);
        this.type = type;
    }

    public Identity[] load(int offset, int limit) throws Exception, IllegalArgumentException {
        ListAccessValidator.validateIndex((int)offset, (int)limit, (int)this.getSize());
        List identities = null;
        switch (this.type) {
            case ALL: {
                identities = this.relationshipStorage.getRelationships(this.identity, (long)offset, (long)limit);
                break;
            }
            case CONNECTION: {
                identities = this.relationshipStorage.getConnections(this.identity, (long)offset, (long)limit);
                break;
            }
            case INCOMING: {
                identities = this.relationshipStorage.getIncomingRelationships(this.identity, (long)offset, (long)limit);
                break;
            }
            case OUTGOING: {
                identities = this.relationshipStorage.getOutgoingRelationships(this.identity, (long)offset, (long)limit);
            }
        }
        return identities.toArray(new Identity[identities.size()]);
    }

    public int getSize() throws Exception {
        switch (this.type) {
            case ALL: {
                return this.relationshipStorage.getRelationshipsCount(this.identity);
            }
            case CONNECTION: {
                return this.relationshipStorage.getConnectionsCount(this.identity);
            }
            case INCOMING: {
                return this.relationshipStorage.getIncomingRelationshipsCount(this.identity);
            }
            case OUTGOING: {
                return this.relationshipStorage.getOutgoingRelationshipsCount(this.identity);
            }
        }
        return 0;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        ALL,
        CONNECTION,
        INCOMING,
        OUTGOING,
        PROFILE_FILTER_INCOMMING,
        PROFILE_FILTER_OUTGOING,
        PROFILE_FILTER_CONNECTION;

    }
}

