/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.stat;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.exoplatform.commons.api.notification.stat.QueryStatistics;

public class ThreadLocalQueryStatisticsImpl
implements QueryStatistics {
    private final AtomicLong executionCount = new AtomicLong();
    private final AtomicLong executionRowCount = new AtomicLong();
    private final AtomicLong executionMaxTime = new AtomicLong();
    private final AtomicLong executionMinTime = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong totalExecutionTime = new AtomicLong();
    private final Lock readLock;
    private final Lock writeLock;

    public ThreadLocalQueryStatisticsImpl() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public long getExecutionCount() {
        return this.executionCount.get();
    }

    public long getExecutionRowCount() {
        return this.executionRowCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExecutionAvgTime() {
        this.writeLock.lock();
        try {
            long avgExecutionTime = 0L;
            if (this.executionCount.get() > 0L) {
                avgExecutionTime = this.totalExecutionTime.get() / this.executionCount.get();
            }
            long l = avgExecutionTime;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long getExecutionMaxTime() {
        return this.executionMaxTime.get();
    }

    public long getExecutionMinTime() {
        return this.executionMinTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executed(long rows, long time) {
        this.readLock.lock();
        try {
            long old = this.executionMinTime.get();
            while (time < old && !this.executionMinTime.compareAndSet(old, time)) {
                old = this.executionMinTime.get();
            }
            old = this.executionMaxTime.get();
            while (time > old && !this.executionMaxTime.compareAndSet(old, time)) {
                old = this.executionMaxTime.get();
            }
            this.executionCount.getAndIncrement();
            this.executionRowCount.addAndGet(rows);
            this.totalExecutionTime.addAndGet(time);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        return "QueryStatistics[" + "executionCount=" + this.executionCount + ",executionRowCount=" + this.executionRowCount + ",executionAvgTime=" + this.getExecutionAvgTime() + ",executionMaxTime=" + this.executionMaxTime + ",executionMinTime=" + this.executionMinTime + ']';
    }
}

