/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.organization.ExtendedCloneable;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.cache.MembershipCacheKey;
import org.exoplatform.services.organization.cache.OrganizationCacheHandler;
import org.exoplatform.services.organization.idm.GroupDAOImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;

public class CacheableGroupHandlerImpl
extends GroupDAOImpl {
    private final ExoCache<Serializable, Object> groupCache;
    private final FutureExoCache<Serializable, Object, Object> futureGroupCache;
    private final ExoCache<MembershipCacheKey, Object> membershipCache;
    protected final ThreadLocal<Boolean> disableCacheInThread = new ThreadLocal();
    private boolean useCacheList;

    public CacheableGroupHandlerImpl(OrganizationCacheHandler organizationCacheHandler, PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService service, boolean useCacheList) {
        super(orgService, service);
        this.groupCache = organizationCacheHandler.getGroupCache();
        this.futureGroupCache = new FutureExoCache((Loader)new Loader<Serializable, Object, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object retrieve(Object context, Serializable key) throws Exception {
                CacheableGroupHandlerImpl.this.disableCacheInThread.set(true);
                try {
                    if (context instanceof Group || context == null) {
                        Collection<Group> collection = CacheableGroupHandlerImpl.this.findGroups((Group)context);
                        return collection;
                    }
                    if (context instanceof String) {
                        Group group = CacheableGroupHandlerImpl.this.findGroupById(key.toString());
                        return group;
                    }
                    if (context instanceof org.picketlink.idm.api.Group) {
                        String string = CacheableGroupHandlerImpl.this.getGroupId((org.picketlink.idm.api.Group)context, null);
                        return string;
                    }
                    Object var3_6 = null;
                    return var3_6;
                }
                finally {
                    CacheableGroupHandlerImpl.this.disableCacheInThread.set(false);
                }
            }
        }, this.groupCache);
        this.membershipCache = organizationCacheHandler.getMembershipCache();
        this.useCacheList = useCacheList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        this.disableCacheInThread.set(true);
        try {
            if (this.useCacheList) {
                if (parent == null) {
                    this.groupCache.remove((Serializable)((Object)CacheableGroupHandlerImpl.computeChildrenKey((String)null)));
                } else {
                    this.groupCache.remove((Serializable)((Object)CacheableGroupHandlerImpl.computeChildrenKey(parent)));
                }
            }
            super.addChild(parent, child, broadcast);
        }
        finally {
            this.disableCacheInThread.set(false);
        }
    }

    @Override
    public Group findGroupById(String groupId) throws Exception {
        if (this.disableCacheInThread.get() == null || !this.disableCacheInThread.get().booleanValue()) {
            Group group = (Group)this.futureGroupCache.get((Object)groupId, (Object)groupId);
            group = group == null ? null : (Group)((ExtendedCloneable)group).clone();
            return group;
        }
        return super.findGroupById(groupId);
    }

    @Override
    public Collection<Group> findGroupByMembership(String userName, String membershipType) throws Exception {
        return super.findGroupByMembership(userName, membershipType);
    }

    @Override
    public Collection<Group> resolveGroupByMembership(String userName, String membershipType) throws Exception {
        return super.resolveGroupByMembership(userName, membershipType);
    }

    @Override
    public Collection<Group> findGroups(Group parent) throws Exception {
        if (this.useCacheList && (this.disableCacheInThread.get() == null || !this.disableCacheInThread.get().booleanValue())) {
            String childrenCacheKey = CacheableGroupHandlerImpl.computeChildrenKey(parent);
            return (Collection)this.futureGroupCache.get((Object)parent, (Object)childrenCacheKey);
        }
        return super.findGroups(parent);
    }

    @Override
    public Collection<Group> findGroupsOfUser(String user) throws Exception {
        return super.findGroupsOfUser(user);
    }

    @Override
    public Collection<Group> getAllGroups() throws Exception {
        return super.getAllGroups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        Group gr = null;
        this.disableCacheInThread.set(true);
        try {
            String groupId = CacheableGroupHandlerImpl.getGroupId(group);
            this.groupCache.select((CachedObjectSelector)new ClearGroupCacheByGroupIdSelector(groupId, group.getParentId(), this.useCacheList));
            this.membershipCache.select((CachedObjectSelector)new ClearMembershipCacheByGroupIdSelector(groupId));
            gr = super.removeGroup(group, broadcast);
        }
        finally {
            this.disableCacheInThread.set(false);
        }
        return gr;
    }

    @Override
    public String getGroupId(org.picketlink.idm.api.Group jbidGroup, List<org.picketlink.idm.api.Group> processed) throws Exception {
        if (this.disableCacheInThread.get() == null || !this.disableCacheInThread.get().booleanValue()) {
            Integer cacheKey = jbidGroup.hashCode();
            return (String)this.futureGroupCache.get((Object)jbidGroup, (Object)cacheKey);
        }
        return super.getGroupId(jbidGroup, processed);
    }

    @Override
    public void saveGroup(Group group, boolean broadcast) throws Exception {
        this.disableCacheInThread.set(true);
        try {
            this.groupCache.remove((Serializable)((Object)CacheableGroupHandlerImpl.getGroupId(group)));
            if (group.getParentId() == null) {
                this.groupCache.remove((Serializable)((Object)CacheableGroupHandlerImpl.computeChildrenKey((String)null)));
            } else {
                this.groupCache.remove((Serializable)((Object)CacheableGroupHandlerImpl.computeChildrenKey(group.getParentId())));
            }
            super.saveGroup(group, broadcast);
        }
        finally {
            this.disableCacheInThread.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveGroup(Group parentOriginGroup, Group parentTargetGroup, Group groupToMove) throws Exception {
        this.disableCacheInThread.set(true);
        try {
            this.clearCache();
            super.moveGroup(parentOriginGroup, parentTargetGroup, groupToMove);
        }
        finally {
            this.disableCacheInThread.set(false);
        }
    }

    public void clearCache() {
        this.groupCache.clearCache();
    }

    public void disableCache() {
        this.disableCacheInThread.set(true);
    }

    public void enableCache() {
        this.disableCacheInThread.set(null);
    }

    private static final String computeChildrenKey(Group parent) {
        return CacheableGroupHandlerImpl.computeChildrenKey(CacheableGroupHandlerImpl.getGroupId(parent));
    }

    private static final String computeChildrenKey(String parentId) {
        return "children_" + parentId;
    }

    private static final String getGroupId(Group group) {
        if (group == null) {
            return null;
        }
        if (StringUtils.isNotBlank((String)group.getId())) {
            return group.getId();
        }
        return (StringUtils.isBlank((String)group.getParentId()) ? "" : group.getParentId()) + "/" + group.getGroupName();
    }

    public static final class ClearMembershipCacheByGroupIdSelector
    implements CachedObjectSelector<MembershipCacheKey, Object> {
        private String groupId;

        public ClearMembershipCacheByGroupIdSelector(String groupId) {
            this.groupId = groupId;
        }

        public void onSelect(ExoCache<? extends MembershipCacheKey, ? extends Object> cache, MembershipCacheKey key, ObjectCacheInfo<? extends Object> ocinfo) throws Exception {
            cache.remove((Serializable)key);
        }

        public boolean select(MembershipCacheKey key, ObjectCacheInfo<? extends Object> ocinfo) {
            Membership cachedMembership;
            Object obj = ocinfo.get();
            return obj instanceof Membership ? (cachedMembership = (Membership)ocinfo.get()).getGroupId().equals(this.groupId) : obj instanceof Collection;
        }
    }

    public static final class ClearGroupCacheByGroupIdSelector
    implements CachedObjectSelector<Serializable, Object> {
        private String groupId;
        private String childrenKey;
        private String parentCachedChildrenKey;

        public ClearGroupCacheByGroupIdSelector(String groupId, String parentId, boolean clearCachedChildrenList) {
            this.groupId = groupId;
            if (clearCachedChildrenList) {
                this.childrenKey = CacheableGroupHandlerImpl.computeChildrenKey(groupId);
                this.parentCachedChildrenKey = CacheableGroupHandlerImpl.computeChildrenKey(parentId);
            }
        }

        public void onSelect(ExoCache<? extends Serializable, ? extends Object> cache, Serializable key, ObjectCacheInfo<? extends Object> ocinfo) throws Exception {
            cache.remove(key);
        }

        public boolean select(Serializable key, ObjectCacheInfo<? extends Object> ocinfo) {
            String keyString = key.toString();
            return key.equals(this.groupId) || keyString.startsWith(this.groupId + "/") || StringUtils.isNotBlank((String)this.childrenKey) && (keyString.equals(this.childrenKey) || keyString.startsWith(this.childrenKey + "/")) || StringUtils.isNotBlank((String)this.parentCachedChildrenKey) && keyString.equals(this.parentCachedChildrenKey);
        }
    }
}

