/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.noaa;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.noaa.StructureDataRegexp;
import ucar.nc2.ncml.NcmlConstructor;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class IgraPor
extends AbstractIOServiceProvider {
    private static final String dataPatternRegexp = "(\\d{2})([ \\-\\d]{6})(.)([ \\-\\d]{5})(.)([ \\-\\d]{5})(.)([ \\-\\d]{5})([ \\-\\d]{5})([ \\-\\d]{5})$";
    private static final String dataHeaderPatternRegexp = "#(\\d{5})(\\d{4})(\\d{2})(\\d{2})(\\d{2})(\\d{4})([ \\d]{4})$";
    private static final String stnPatternRegexp = "([A-Z]{2})  (\\d{5})  (.{35}) ([ \\.\\-\\d]{6}) ([ \\.\\-\\d]{7}) ([ \\-\\d]{4}) (.)(.)(.)  ([ \\d]{4}) ([ \\d]{4})$";
    private static final Pattern dataPattern = Pattern.compile("(\\d{2})([ \\-\\d]{6})(.)([ \\-\\d]{5})(.)([ \\-\\d]{5})(.)([ \\-\\d]{5})([ \\-\\d]{5})([ \\-\\d]{5})$");
    private static final Pattern dataHeaderPattern = Pattern.compile("#(\\d{5})(\\d{4})(\\d{2})(\\d{2})(\\d{2})(\\d{4})([ \\d]{4})$");
    private static final Pattern stnPattern = Pattern.compile("([A-Z]{2})  (\\d{5})  (.{35}) ([ \\.\\-\\d]{6}) ([ \\.\\-\\d]{7}) ([ \\-\\d]{4}) (.)(.)(.)  ([ \\d]{4}) ([ \\d]{4})$");
    private static final String STNID = "stnid";
    private static final String STN_FILE = "igra-stations.txt";
    private static final String DAT_EXT = ".dat";
    private static final String DAT_DIR = "igra-por";
    private static final String IDX_EXT = ".ncx";
    private static final String MAGIC_START_IDX = "IgraPorIndex";
    private static final int version = 1;
    private RandomAccessFile stnRaf;
    private RandomAccessFile dataRaf;
    private File dataDir;
    private int stn_fldno;
    private StructureDataRegexp.Vinfo stnVinfo;
    private StructureDataRegexp.Vinfo seriesVinfo;
    private StructureDataRegexp.Vinfo profileVinfo;
    private String stationId;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        String location = raf.getLocation();
        File file = new File(location);
        int pos = location.lastIndexOf(".");
        if (pos <= 0) {
            return false;
        }
        String base = location.substring(0, pos);
        String ext = location.substring(pos);
        if (!(ext.equals(DAT_EXT) || ext.equals(IDX_EXT) || file.getName().equals(STN_FILE))) {
            return false;
        }
        if (ext.equals(IDX_EXT)) {
            File datFile = new File(base + DAT_EXT);
            if (!datFile.exists()) {
                return false;
            }
            File stnFile = this.getStnFile(location);
            if (stnFile == null || !stnFile.exists()) {
                return false;
            }
            raf.seek(0L);
            String test = raf.readString(MAGIC_START_IDX.length());
            return test.equals(MAGIC_START_IDX);
        }
        if (ext.equals(DAT_EXT)) {
            File stnFile = this.getStnFile(location);
            return stnFile != null && this.isValidFile(raf, dataHeaderPattern);
        }
        File dataDir = new File(file.getParentFile(), DAT_DIR);
        return dataDir.exists() && dataDir.isDirectory() && this.isValidFile(raf, stnPattern);
    }

    private File getStnFile(String location) {
        File file = new File(location);
        File stnFile = new File(file.getParentFile(), STN_FILE);
        if (!stnFile.exists()) {
            if (file.getParentFile() == null) {
                return null;
            }
            stnFile = new File(file.getParentFile().getParentFile(), STN_FILE);
            if (!stnFile.exists()) {
                return null;
            }
        }
        return stnFile;
    }

    private boolean isValidFile(RandomAccessFile raf, Pattern p) throws IOException {
        String line;
        raf.seek(0L);
        while ((line = raf.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            Matcher matcher = p.matcher(line);
            return matcher.matches();
        }
        return false;
    }

    @Override
    public String getFileTypeId() {
        return "IGRA-POR";
    }

    @Override
    public String getFileTypeDescription() {
        return "Integrated Global Radiosonde Archive";
    }

    @Override
    public String getFileTypeVersion() {
        return Integer.toString(1);
    }

    @Override
    public void open(RandomAccessFile raff, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        String location = raff.getLocation();
        int pos = location.lastIndexOf(".");
        String ext = location.substring(pos);
        File file = new File(location);
        File stnFile = this.getStnFile(location);
        if (stnFile == null) {
            throw new FileNotFoundException("Station File does not exist=" + location);
        }
        if (ext.equals(IDX_EXT)) {
            this.stnRaf = new RandomAccessFile(stnFile.getPath(), "r");
        } else if (ext.equals(DAT_EXT)) {
            this.stnRaf = new RandomAccessFile(stnFile.getPath(), "r");
            this.dataRaf = raff;
            String name = file.getName();
            this.stationId = name.substring(0, name.length() - DAT_EXT.length());
        } else {
            this.stnRaf = raff;
            this.dataDir = new File(file.getParentFile(), DAT_DIR);
        }
        NcmlConstructor ncmlc = new NcmlConstructor();
        if (!ncmlc.populateFromResource("resources/nj22/iosp/igra-por.ncml", ncfile)) {
            throw new IllegalStateException(ncmlc.getErrlog().toString());
        }
        ncfile.finish();
        this.stnVinfo = this.setVinfo(this.stnRaf, ncfile, stnPattern, "station");
        this.seriesVinfo = this.setVinfo(this.stnRaf, ncfile, dataHeaderPattern, "station.time_series");
        this.profileVinfo = this.setVinfo(this.stnRaf, ncfile, dataPattern, "station.time_series.levels");
        StructureMembers.Member m = this.stnVinfo.sm.findMember(STNID);
        StructureDataRegexp.VinfoField f = (StructureDataRegexp.VinfoField)m.getDataObject();
        this.stn_fldno = f.fldno;
    }

    private StructureDataRegexp.Vinfo setVinfo(RandomAccessFile raff, NetcdfFile ncfile, Pattern p, String seqName) {
        Sequence seq = (Sequence)ncfile.findVariable(seqName);
        StructureMembers sm = seq.makeStructureMembers();
        StructureDataRegexp.Vinfo result = new StructureDataRegexp.Vinfo(raff, sm, p);
        seq.setSPobject(result);
        int fldno = 1;
        for (StructureMembers.Member m : sm.getMembers()) {
            StructureDataRegexp.VinfoField vf = new StructureDataRegexp.VinfoField(fldno++);
            Variable v = seq.findVariable(m.getName());
            Attribute att = v.findAttribute("iosp_scale");
            if (att != null) {
                vf.hasScale = true;
                vf.scale = att.getNumericValue().floatValue();
            }
            m.setDataObject(vf);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.stnRaf != null) {
            this.stnRaf.close();
        }
        if (this.dataRaf != null) {
            this.dataRaf.close();
        }
        this.stnRaf = null;
        this.dataRaf = null;
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        StructureDataRegexp.Vinfo vinfo = (StructureDataRegexp.Vinfo)v2.getSPobject();
        if (this.stationId != null) {
            return new ArraySequence(vinfo.sm, new SingleStationSeqIter(vinfo), vinfo.nelems);
        }
        return new ArraySequence(vinfo.sm, new StationSeqIter(vinfo), vinfo.nelems);
    }

    @Override
    public StructureDataIterator getStructureIterator(Structure s, int bufferSize) throws IOException {
        StructureDataRegexp.Vinfo vinfo = (StructureDataRegexp.Vinfo)s.getSPobject();
        if (this.stationId != null) {
            return new SingleStationSeqIter(vinfo);
        }
        return new StationSeqIter(vinfo);
    }

    private class TimeSeriesIter
    implements StructureDataIterator {
        private int countRead = 0;
        private long totalBytes;
        private File file;
        private RandomAccessFile timeSeriesRaf = null;
        private boolean exists;

        TimeSeriesIter(String stnid) {
            if (IgraPor.this.dataRaf != null) {
                this.exists = true;
            } else {
                this.file = new File(IgraPor.this.dataDir, stnid + IgraPor.DAT_EXT);
                this.exists = this.file.exists();
            }
        }

        private void init() {
            if (!this.exists) {
                return;
            }
            try {
                this.timeSeriesRaf = IgraPor.this.dataRaf != null ? IgraPor.this.dataRaf : new RandomAccessFile(this.file.getPath(), "r");
                this.totalBytes = this.timeSeriesRaf.length();
                this.timeSeriesRaf.seek(0L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public StructureDataIterator reset() {
            if (!this.exists) {
                return this;
            }
            if (this.timeSeriesRaf == null) {
                this.init();
            }
            this.countRead = 0;
            try {
                this.timeSeriesRaf.seek(0L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public boolean hasNext() throws IOException {
            if (!this.exists) {
                return false;
            }
            if (this.timeSeriesRaf == null) {
                this.init();
            }
            return this.timeSeriesRaf.getFilePointer() < this.totalBytes;
        }

        @Override
        public StructureData next() throws IOException {
            Matcher matcher;
            while (true) {
                String line;
                if ((line = this.timeSeriesRaf.readLine()) == null) {
                    return null;
                }
                if (line.trim().length() == 0) continue;
                matcher = ((IgraPor)IgraPor.this).seriesVinfo.p.matcher(line);
                if (matcher.matches()) break;
                System.out.printf("FAIL TimeSeriesIter <%s>%n", line);
            }
            ++this.countRead;
            return new TimeSeriesData(matcher);
        }

        @Override
        public void setBufferSize(int bytes) {
        }

        @Override
        public int getCurrentRecno() {
            return this.countRead - 1;
        }

        @Override
        public void finish() {
            try {
                if (this.timeSeriesRaf != null && this.timeSeriesRaf != IgraPor.this.dataRaf) {
                    this.timeSeriesRaf.close();
                    this.timeSeriesRaf = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private class TimeSeriesData
        extends StructureDataRegexp {
            List<String> lines;

            TimeSeriesData(Matcher matcher) throws IOException {
                block1: {
                    long pos;
                    super(((IgraPor)IgraPor.this).seriesVinfo.sm, matcher);
                    this.lines = new ArrayList<String>(30);
                    while (true) {
                        pos = TimeSeriesIter.this.timeSeriesRaf.getFilePointer();
                        String line = TimeSeriesIter.this.timeSeriesRaf.readLine();
                        if (line == null) break block1;
                        if (line.trim().length() == 0) continue;
                        matcher = ((IgraPor)IgraPor.this).profileVinfo.p.matcher(line);
                        if (!matcher.matches()) break;
                        this.lines.add(line);
                    }
                    TimeSeriesIter.this.timeSeriesRaf.seek(pos);
                }
            }

            @Override
            public ArraySequence getArraySequence(StructureMembers.Member m) {
                return new ArraySequence(((IgraPor)IgraPor.this).profileVinfo.sm, new ProfileIter(), -1);
            }

            private class ProfileIter
            implements StructureDataIterator {
                private int countRead = 0;

                ProfileIter() {
                }

                @Override
                public StructureDataIterator reset() {
                    this.countRead = 0;
                    return this;
                }

                @Override
                public boolean hasNext() throws IOException {
                    return this.countRead < TimeSeriesData.this.lines.size();
                }

                @Override
                public StructureData next() throws IOException {
                    if (!this.hasNext()) {
                        return null;
                    }
                    Matcher matcher = ((IgraPor)IgraPor.this).profileVinfo.p.matcher(TimeSeriesData.this.lines.get(this.countRead));
                    if (!matcher.matches()) {
                        throw new IllegalStateException("line = " + TimeSeriesData.this.lines.get(this.countRead) + "pattern = " + ((IgraPor)IgraPor.this).profileVinfo.p);
                    }
                    StructureDataRegexp sd = new StructureDataRegexp(((IgraPor)IgraPor.this).profileVinfo.sm, matcher);
                    ++this.countRead;
                    return sd;
                }

                @Override
                public void setBufferSize(int bytes) {
                }

                @Override
                public int getCurrentRecno() {
                    return this.countRead - 1;
                }

                @Override
                public void finish() {
                }
            }
        }
    }

    private class StationData
    extends StructureDataRegexp {
        StationData(StructureMembers members, Matcher matcher) {
            super(members, matcher);
        }

        @Override
        public ArraySequence getArraySequence(StructureMembers.Member m) {
            String stnid = this.matcher.group(IgraPor.this.stn_fldno).trim();
            return new ArraySequence(((IgraPor)IgraPor.this).seriesVinfo.sm, new TimeSeriesIter(stnid), -1);
        }
    }

    private class StationSeqIter
    implements StructureDataIterator {
        private StructureDataRegexp.Vinfo vinfo;
        private long totalBytes;
        private int recno;
        private StructureData curr;

        StationSeqIter(StructureDataRegexp.Vinfo vinfo) throws IOException {
            this.vinfo = vinfo;
            this.totalBytes = (int)vinfo.rafile.length();
            vinfo.rafile.seek(0L);
        }

        @Override
        public StructureDataIterator reset() {
            this.recno = 0;
            try {
                this.vinfo.rafile.seek(0L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public boolean hasNext() throws IOException {
            boolean more;
            boolean bl = more = this.vinfo.rafile.getFilePointer() < this.totalBytes;
            if (!more) {
                this.vinfo.nelems = this.recno;
                return false;
            }
            this.curr = this.reallyNext();
            boolean bl2 = more = this.curr != null;
            if (!more) {
                this.vinfo.nelems = this.recno;
                return false;
            }
            return more;
        }

        @Override
        public StructureData next() throws IOException {
            return this.curr;
        }

        private StructureData reallyNext() throws IOException {
            Matcher matcher;
            while (true) {
                String line;
                if ((line = this.vinfo.rafile.readLine()) == null) {
                    return null;
                }
                if (line.startsWith("#") || line.trim().length() == 0) continue;
                matcher = this.vinfo.p.matcher(line);
                if (matcher.matches()) break;
                System.out.printf("FAIL %s%n", line);
            }
            ++this.recno;
            return new StationData(this.vinfo.sm, matcher);
        }

        @Override
        public void setBufferSize(int bytes) {
        }

        @Override
        public int getCurrentRecno() {
            return this.recno - 1;
        }

        @Override
        public void finish() {
        }
    }

    private class SingleStationSeqIter
    implements StructureDataIterator {
        private StructureDataRegexp.Vinfo vinfo;
        private int recno = 0;

        SingleStationSeqIter(StructureDataRegexp.Vinfo vinfo) throws IOException {
            this.vinfo = vinfo;
            vinfo.rafile.seek(0L);
        }

        @Override
        public StructureDataIterator reset() {
            this.recno = 0;
            return this;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.recno == 0;
        }

        @Override
        public StructureData next() throws IOException {
            String stnid;
            Matcher matcher;
            String line;
            do {
                if ((line = this.vinfo.rafile.readLine()) != null) continue;
                return null;
            } while (line.startsWith("#") || line.trim().length() == 0 || !(matcher = this.vinfo.p.matcher(line)).matches() || !(stnid = matcher.group(IgraPor.this.stn_fldno).trim()).equals(IgraPor.this.stationId));
            ++this.recno;
            return new StationData(this.vinfo.sm, matcher);
        }

        @Override
        public void setBufferSize(int bytes) {
        }

        @Override
        public int getCurrentRecno() {
            return this.recno - 1;
        }

        @Override
        public void finish() {
        }
    }
}

