/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.nio.Buffer;
import java.util.Arrays;
import java.util.Optional;
import org.apache.sis.image.DefaultIterator;
import org.apache.sis.image.LinearIterator;
import org.apache.sis.image.SequenceType;
import org.apache.sis.image.TransferType;
import org.apache.sis.image.WritablePixelIterator;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public abstract class PixelIterator {
    final RenderedImage image;
    Raster currentRaster;
    final int numBands;
    final int lowerX;
    final int lowerY;
    final int upperX;
    final int upperY;
    final int tileWidth;
    final int tileHeight;
    final int tileGridXOffset;
    final int tileGridYOffset;
    final int tileLowerX;
    final int tileLowerY;
    final int tileUpperX;
    final int tileUpperY;
    final int windowWidth;
    final int windowHeight;

    PixelIterator(Raster raster, Rectangle rectangle, Dimension dimension) {
        this.image = null;
        this.currentRaster = raster;
        this.numBands = raster.getNumBands();
        this.tileWidth = raster.getWidth();
        this.tileHeight = raster.getHeight();
        this.tileGridXOffset = raster.getMinX();
        this.tileGridYOffset = raster.getMinY();
        this.tileLowerX = 0;
        this.tileLowerY = 0;
        this.tileUpperX = 1;
        this.tileUpperY = 1;
        Rectangle rectangle2 = PixelIterator.intersection(this.tileGridXOffset, this.tileGridYOffset, this.tileWidth, this.tileHeight, rectangle, dimension);
        this.lowerX = rectangle2.x;
        this.lowerY = rectangle2.y;
        this.upperX = Math.addExact(this.lowerX, rectangle2.width);
        this.upperY = Math.addExact(this.lowerY, rectangle2.height);
        this.windowWidth = dimension != null ? dimension.width : 0;
        this.windowHeight = dimension != null ? dimension.height : 0;
    }

    PixelIterator(RenderedImage renderedImage, Rectangle rectangle, Dimension dimension) {
        this.image = renderedImage;
        this.numBands = renderedImage.getSampleModel().getNumBands();
        this.tileWidth = renderedImage.getTileWidth();
        this.tileHeight = renderedImage.getTileHeight();
        this.tileGridXOffset = renderedImage.getTileGridXOffset();
        this.tileGridYOffset = renderedImage.getTileGridYOffset();
        Rectangle rectangle2 = PixelIterator.intersection(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), rectangle, dimension);
        this.lowerX = rectangle2.x;
        this.lowerY = rectangle2.y;
        this.upperX = Math.addExact(this.lowerX, rectangle2.width);
        this.upperY = Math.addExact(this.lowerY, rectangle2.height);
        this.tileLowerX = Math.floorDiv(Math.subtractExact(this.lowerX, this.tileGridXOffset), this.tileWidth);
        this.tileLowerY = Math.floorDiv(Math.subtractExact(this.lowerY, this.tileGridYOffset), this.tileHeight);
        this.tileUpperX = Numerics.ceilDiv((int)Math.subtractExact(this.upperX, this.tileGridXOffset), (int)this.tileWidth);
        this.tileUpperY = Numerics.ceilDiv((int)Math.subtractExact(this.upperY, this.tileGridYOffset), (int)this.tileHeight);
        this.windowWidth = dimension != null ? dimension.width : 0;
        this.windowHeight = dimension != null ? dimension.height : 0;
    }

    private static Rectangle intersection(int n, int n2, int n3, int n4, Rectangle rectangle, Dimension dimension) {
        if (dimension != null) {
            ArgumentChecks.ensureBetween((String)"window.width", (int)1, (int)n3, (int)dimension.width);
            ArgumentChecks.ensureBetween((String)"window.height", (int)1, (int)n4, (int)dimension.height);
            n3 -= dimension.width - 1;
            n4 -= dimension.height - 1;
        }
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        if (rectangle != null) {
            rectangle2 = rectangle2.intersection(rectangle);
            if (rectangle2.width < 0) {
                rectangle2.width = 0;
            }
            if (rectangle2.height < 0) {
                rectangle2.height = 0;
            }
        }
        return rectangle2;
    }

    public static PixelIterator create(RenderedImage renderedImage) {
        return new Builder().create(renderedImage);
    }

    public boolean isWritable() {
        return false;
    }

    public TransferType<?> getTransferType() {
        return TransferType.valueOf(this.image != null ? this.image.getSampleModel().getTransferType() : this.currentRaster.getTransferType());
    }

    public NumberRange<?>[] getSampleRanges() {
        NumberRange numberRange;
        SampleModel sampleModel = this.currentRaster != null ? this.currentRaster.getSampleModel() : this.image.getSampleModel();
        Object[] objectArray = new NumberRange[sampleModel.getNumBands()];
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            int n = ((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride();
            numberRange = NumberRange.create((int)0, (boolean)true, (int)((1 << n) - 1), (boolean)true);
        } else {
            if (sampleModel instanceof SinglePixelPackedSampleModel) {
                int[] nArray = ((SinglePixelPackedSampleModel)sampleModel).getBitMasks();
                for (int i = 0; i < nArray.length; ++i) {
                    int n = Integer.bitCount(nArray[i]);
                    objectArray[i] = NumberRange.create((int)0, (boolean)true, (int)((1 << n) - 1), (boolean)true);
                }
                return objectArray;
            }
            int n = sampleModel.getDataType();
            switch (n) {
                case 0: {
                    numberRange = NumberRange.create((short)0, (boolean)true, (short)255, (boolean)true);
                    break;
                }
                case 1: {
                    numberRange = NumberRange.create((int)0, (boolean)true, (int)65535, (boolean)true);
                    break;
                }
                case 2: {
                    numberRange = NumberRange.create((short)Short.MIN_VALUE, (boolean)true, (short)Short.MAX_VALUE, (boolean)true);
                    break;
                }
                case 3: {
                    numberRange = NumberRange.create((int)Integer.MIN_VALUE, (boolean)true, (int)Integer.MAX_VALUE, (boolean)true);
                    break;
                }
                case 4: {
                    numberRange = NumberRange.create((float)Float.NEGATIVE_INFINITY, (boolean)false, (float)Float.POSITIVE_INFINITY, (boolean)false);
                    break;
                }
                case 5: {
                    numberRange = NumberRange.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)false);
                    break;
                }
                default: {
                    throw new IllegalStateException(Errors.format((short)149, (Object)n));
                }
            }
        }
        Arrays.fill(objectArray, numberRange);
        return objectArray;
    }

    abstract Optional<SequenceType> getIterationOrder();

    public int getNumBands() {
        return this.numBands;
    }

    public Rectangle getDomain() {
        return new Rectangle(this.lowerX, this.lowerY, this.upperX - this.lowerX, this.upperY - this.lowerY);
    }

    public abstract Point getPosition();

    public abstract void moveTo(int var1, int var2);

    public abstract boolean next();

    public abstract int getSample(int var1);

    public abstract float getSampleFloat(int var1);

    public abstract double getSampleDouble(int var1);

    public abstract int[] getPixel(int[] var1);

    public abstract float[] getPixel(float[] var1);

    public abstract double[] getPixel(double[] var1);

    public abstract <T extends Buffer> Window<T> createWindow(TransferType<T> var1);

    public abstract void rewind();

    public static abstract class Window<T extends Buffer> {
        public final T values;

        Window(T t) {
            this.values = t;
        }

        public abstract void update();
    }

    public static class Builder {
        private Rectangle subArea;
        private Dimension window;
        private SequenceType order;

        public Builder setRegionOfInterest(Rectangle rectangle) {
            this.subArea = rectangle;
            return this;
        }

        public Builder setWindowSize(Dimension dimension) {
            this.window = dimension;
            return this;
        }

        final Builder setIteratorOrder(SequenceType sequenceType) {
            if (sequenceType != null && !sequenceType.equals((Object)SequenceType.LINEAR)) {
                throw new IllegalArgumentException(Errors.format((short)163, (Object)((Object)sequenceType)));
            }
            this.order = sequenceType;
            return this;
        }

        public PixelIterator create(Raster raster) {
            ArgumentChecks.ensureNonNull((String)"data", (Object)raster);
            if (this.order == SequenceType.LINEAR) {
                return new LinearIterator(raster, null, this.subArea, this.window);
            }
            if (this.order != null) {
                throw new IllegalStateException(Errors.format((short)163, (Object)((Object)this.order)));
            }
            return new DefaultIterator(raster, null, this.subArea, this.window);
        }

        public PixelIterator create(RenderedImage renderedImage) {
            ArgumentChecks.ensureNonNull((String)"data", (Object)renderedImage);
            if (this.order == SequenceType.LINEAR) {
                return new LinearIterator(renderedImage, null, this.subArea, this.window);
            }
            if (this.order != null) {
                throw new IllegalStateException(Errors.format((short)163, (Object)((Object)this.order)));
            }
            return new DefaultIterator(renderedImage, null, this.subArea, this.window);
        }

        public WritablePixelIterator createWritable(WritableRaster writableRaster) {
            ArgumentChecks.ensureNonNull((String)"data", (Object)writableRaster);
            return this.createWritable(writableRaster, writableRaster);
        }

        public WritablePixelIterator createWritable(WritableRenderedImage writableRenderedImage) {
            ArgumentChecks.ensureNonNull((String)"data", (Object)writableRenderedImage);
            return this.createWritable(writableRenderedImage, writableRenderedImage);
        }

        public WritablePixelIterator createWritable(Raster raster, WritableRaster writableRaster) {
            ArgumentChecks.ensureNonNull((String)"input", (Object)raster);
            ArgumentChecks.ensureNonNull((String)"output", (Object)writableRaster);
            if (this.order == SequenceType.LINEAR) {
                return new LinearIterator(raster, writableRaster, this.subArea, this.window);
            }
            if (this.order != null) {
                throw new IllegalStateException(Errors.format((short)163, (Object)((Object)this.order)));
            }
            return new DefaultIterator(raster, writableRaster, this.subArea, this.window);
        }

        public WritablePixelIterator createWritable(RenderedImage renderedImage, WritableRenderedImage writableRenderedImage) {
            ArgumentChecks.ensureNonNull((String)"input", (Object)renderedImage);
            ArgumentChecks.ensureNonNull((String)"output", (Object)writableRenderedImage);
            if (this.order == SequenceType.LINEAR) {
                return new LinearIterator(renderedImage, writableRenderedImage, this.subArea, this.window);
            }
            if (this.order != null) {
                throw new IllegalStateException(Errors.format((short)163, (Object)((Object)this.order)));
            }
            return new DefaultIterator(renderedImage, writableRenderedImage, this.subArea, this.window);
        }
    }
}

