/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.core.metadata.MetadataServiceImpl$AjcClosure1;
import org.exoplatform.social.core.metadata.storage.MetadataStorage;
import org.exoplatform.social.metadata.MetadataInitPlugin;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.MetadataTypePlugin;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.picocontainer.Startable;

public class MetadataServiceImpl
implements MetadataService,
Startable {
    private static final Log LOG;
    private MetadataStorage metadataStorage;
    private ListenerService listenerService;
    private Map<String, MetadataTypePlugin> metadataTypePlugins = new HashMap<String, MetadataTypePlugin>();
    private List<MetadataInitPlugin> metadataPlugins = new ArrayList<MetadataInitPlugin>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public MetadataServiceImpl(MetadataStorage metadataStorage, ListenerService listenerService) {
        this.metadataStorage = metadataStorage;
        this.listenerService = listenerService;
    }

    public Metadata createMetadata(Metadata metadata, long userIdentityId) {
        if (metadata == null) {
            throw new IllegalArgumentException("Metadata is mandatory");
        }
        if (metadata.getType() == null) {
            throw new IllegalArgumentException("Metadata Type is mandatory");
        }
        String metadataTypeName = metadata.getType().getName();
        MetadataType type = this.getMetadataTypeByName(metadataTypeName);
        if (type == null) {
            throw new IllegalArgumentException("Metadata Type " + metadataTypeName + " is not registered as a plugin");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("userIdentityId is mandatory");
        }
        metadata.setType(metadata.getType());
        metadata.setCreatorId(userIdentityId);
        metadata.setProperties(metadata.getProperties());
        metadata = this.metadataStorage.createMetadata(metadata);
        try {
            this.listenerService.broadcast("social.metadata.created", (Object)userIdentityId, (Object)metadata);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while broadcasting event for metadata creation", (Throwable)e);
        }
        return metadata;
    }

    public Metadata updateMetadata(Metadata metadata, long userIdentityId) {
        if (metadata == null) {
            throw new IllegalArgumentException("Metadata is mandatory");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("userIdentityId is mandatory");
        }
        metadata = this.metadataStorage.updateMetadata(metadata);
        try {
            this.listenerService.broadcast("social.metadata.updated", (Object)userIdentityId, (Object)metadata);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while broadcasting event for metadata update", (Throwable)e);
        }
        return metadata;
    }

    public Metadata deleteMetadataById(long metadataId) {
        if (metadataId <= 0L) {
            throw new IllegalArgumentException("Metadata Technical Identifier is mandatory");
        }
        return this.metadataStorage.deleteMetadataById(metadataId);
    }

    public int deleteMetadataBySpaceId(long spaceId) {
        if (spaceId <= 0L) {
            throw new IllegalArgumentException("Space Technical Identifier is mandatory");
        }
        return this.metadataStorage.deleteMetadataItemsBySpaceId(spaceId);
    }

    public int deleteMetadataBySpaceIdAndAudienceId(long spaceId, long audienceId) {
        if (spaceId <= 0L) {
            throw new IllegalArgumentException("Space Technical Identifier is mandatory");
        }
        if (audienceId <= 0L) {
            throw new IllegalArgumentException("Audience Identity Technical Identifier is mandatory");
        }
        return this.metadataStorage.deleteMetadataItemsBySpaceIdAndAudienceId(spaceId, audienceId);
    }

    public Metadata getMetadataByKey(MetadataKey metadataKey) {
        if (metadataKey == null) {
            throw new IllegalArgumentException("Metadata Key is mandatory");
        }
        if (StringUtils.isBlank((String)metadataKey.getType())) {
            throw new IllegalArgumentException("Metadata Type is mandatory");
        }
        if (StringUtils.isBlank((String)metadataKey.getName())) {
            throw new IllegalArgumentException("Metadata Name is mandatory");
        }
        return this.metadataStorage.getMetadataByKey(metadataKey);
    }

    public MetadataItem createMetadataItem(MetadataObject metadataObject, MetadataKey metadataKey, long userIdentityId) throws ObjectAlreadyExistsException {
        return this.createMetadataItem(metadataObject, metadataKey, null, userIdentityId);
    }

    public MetadataItem createMetadataItem(MetadataObject metadataObject, MetadataKey metadataKey, Map<String, String> properties, long userIdentityId) throws ObjectAlreadyExistsException {
        List<MetadataItem> storedMetadataItems;
        if (metadataObject == null) {
            throw new IllegalArgumentException("Metadata Item Object is mandatory");
        }
        if (metadataKey == null) {
            throw new IllegalArgumentException("Metadata Key is mandatory");
        }
        if (StringUtils.isBlank((String)metadataObject.getType())) {
            throw new IllegalArgumentException("Metadata Item Object Type is mandatory");
        }
        if (StringUtils.isBlank((String)metadataObject.getId())) {
            throw new IllegalArgumentException("Metadata Item Object Id is mandatory");
        }
        String metadataTypeName = metadataKey.getType();
        if (StringUtils.isBlank((String)metadataTypeName)) {
            throw new IllegalArgumentException("Metadata Type is mandatory");
        }
        if (StringUtils.isBlank((String)metadataKey.getName())) {
            throw new IllegalArgumentException("Metadata Name is mandatory");
        }
        MetadataType metadataType = this.getMetadataTypeByName(metadataTypeName);
        if (metadataType == null) {
            throw new IllegalArgumentException("Metadata Type " + metadataTypeName + " is not registered as a plugin");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("userIdentityId is mandatory");
        }
        Metadata metadata = this.getMetadataByKey(metadataKey);
        if (metadata == null) {
            metadata = new Metadata();
            metadata.setName(metadataKey.getName());
            metadata.setType(metadataType);
            metadata.setAudienceId(metadataKey.getAudienceId());
            metadata = this.createMetadata(metadata, userIdentityId);
        }
        MetadataItem metadataItem = new MetadataItem(0L, metadata, metadataObject, userIdentityId, System.currentTimeMillis(), properties);
        if (!this.isAllowMultipleItemsPerObject(metadataTypeName) && !(storedMetadataItems = this.metadataStorage.getMetadataItemsByMetadataAndObject(metadata.getId(), metadataItem.getObject())).isEmpty()) {
            throw new ObjectAlreadyExistsException((Object)storedMetadataItems.get(0));
        }
        metadataItem = this.metadataStorage.createMetadataItem(metadataItem);
        try {
            this.listenerService.broadcast("social.metadataItem.created", (Object)userIdentityId, (Object)metadataItem);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while broadcasting event for metadata item creation", (Throwable)e);
        }
        return metadataItem;
    }

    public MetadataItem deleteMetadataItem(long itemId, boolean broadcast) throws ObjectNotFoundException {
        if (itemId <= 0L) {
            throw new IllegalArgumentException("Metadata Item Technical Identifier is mandatory");
        }
        MetadataItem metadataItem = this.metadataStorage.getMetadataItemById(itemId);
        if (metadataItem == null) {
            throw new ObjectNotFoundException("Metadata Item with identifier " + itemId + " wasn't found");
        }
        metadataItem = this.metadataStorage.deleteMetadataItemById(itemId);
        if (broadcast) {
            try {
                this.listenerService.broadcast("social.metadataItem.deleted", (Object)0L, (Object)metadataItem);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while broadcasting event for metadata item deleted", (Throwable)e);
            }
        }
        return metadataItem;
    }

    public MetadataItem deleteMetadataItem(long itemId, long userIdentityId) throws ObjectNotFoundException {
        if (itemId <= 0L) {
            throw new IllegalArgumentException("Metadata Item Technical Identifier is mandatory");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("userIdentityId is mandatory");
        }
        MetadataItem metadataItem = this.metadataStorage.getMetadataItemById(itemId);
        if (metadataItem == null) {
            throw new ObjectNotFoundException("Metadata Item with identifier " + itemId + " wasn't found");
        }
        metadataItem = this.metadataStorage.deleteMetadataItemById(itemId);
        try {
            this.listenerService.broadcast("social.metadataItem.deleted", (Object)userIdentityId, (Object)metadataItem);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while broadcasting event for metadata item deleted", (Throwable)e);
        }
        return metadataItem;
    }

    public void deleteMetadataItemsByObject(MetadataObject object) {
        this.metadataStorage.deleteMetadataItemsByObject(object);
    }

    public void deleteMetadataItemsByMetadataTypeAndObject(String metadataType, MetadataObject object) {
        this.metadataStorage.deleteMetadataItemsByMetadataTypeAndObject(metadataType, object);
    }

    public void deleteMetadataItemsByParentObject(MetadataObject object) {
        this.metadataStorage.deleteMetadataItemsByParentObject(object);
    }

    public List<MetadataItem> shareMetadataItemsByObject(MetadataObject sourceObject, String targetObjectId, long audienceId, long creatorId) {
        ArrayList<MetadataItem> sharedMetadataItems = new ArrayList<MetadataItem>();
        List<MetadataItem> metadataItems = this.getMetadataItemsByObject(sourceObject);
        for (MetadataItem metadataItem : metadataItems) {
            MetadataItem sharedMetadataItem = this.shareMetadataItem(metadataItem.getObject(), metadataItem.getMetadata().key(), targetObjectId, audienceId, creatorId);
            if (sharedMetadataItem == null) continue;
            sharedMetadataItems.add(sharedMetadataItem);
        }
        try {
            this.listenerService.broadcast("social.metadataItem.shared", (Object)sourceObject, (Object)targetObjectId);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while broadcasting event for metadata item shared", (Throwable)e);
        }
        return sharedMetadataItems;
    }

    public List<MetadataItem> getMetadataItemsByObject(MetadataObject object) {
        return this.metadataStorage.getMetadataItemsByObject(object);
    }

    public List<MetadataItem> getMetadataItemsByMetadataTypeAndObject(String metadataType, MetadataObject object) {
        return this.metadataStorage.getMetadataItemsByMetadataTypeAndObject(metadataType, object);
    }

    public List<MetadataItem> getMetadataItemsByMetadataNameAndTypeAndObject(String metadataName, String metadataTypeName, String objectType, long offset, long limit) {
        return this.metadataStorage.getMetadataItemsByMetadataNameAndTypeAndObject(metadataName, metadataTypeName, objectType, offset, limit);
    }

    public List<MetadataItem> getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty(String metadataName, String metadataTypeName, String objectType, String propertyKey, String propertyValue, long offset, long limit) {
        return this.metadataStorage.getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty(metadataName, metadataTypeName, objectType, propertyKey, propertyValue, offset, limit);
    }

    public List<MetadataItem> getMetadataItemsByMetadataTypeAndCreator(String metadataTypeName, long creatorId, long offset, long limit) {
        MetadataType metadataType = this.getMetadataTypeByName(metadataTypeName);
        if (metadataType == null) {
            throw new IllegalArgumentException("Metadata Type " + metadataType + " is not registered as a plugin");
        }
        if (creatorId <= 0L) {
            throw new IllegalArgumentException("creatorId is mandatory.");
        }
        return this.metadataStorage.getMetadataItemsByMetaDataTypeAndCreator(metadataType.getId(), creatorId, offset, limit);
    }

    public int countMetadataItemsByMetadataTypeAndCreator(String metadataTypeName, long creatorId) {
        MetadataType metadataType = this.getMetadataTypeByName(metadataTypeName);
        if (metadataType == null) {
            throw new IllegalArgumentException("Metadata Type " + metadataType + " is not registered as a plugin");
        }
        if (creatorId <= 0L) {
            throw new IllegalArgumentException("creatorId is mandatory.");
        }
        return this.metadataStorage.countMetadataItemsByMetadataTypeAndCreator(metadataType.getId(), creatorId);
    }

    public Set<String> getMetadataNamesByObject(MetadataObject object) {
        return this.metadataStorage.getMetadataNamesByObject(object);
    }

    public List<String> findMetadataNamesByCreator(String term, String metadataTypeName, long creatorId, long limit) {
        MetadataType metadataType = this.getMetadataTypeByName(metadataTypeName);
        if (metadataType == null) {
            throw new IllegalArgumentException("Metadata Type " + metadataTypeName + " is not registered as a plugin");
        }
        if (StringUtils.isBlank((String)term)) {
            return this.metadataStorage.getMetadataNamesByCreator(metadataType.getId(), creatorId, limit);
        }
        return this.metadataStorage.findMetadataNameByCreatorAndQuery(term, metadataType.getId(), creatorId, limit);
    }

    public List<String> findMetadataNamesByUserAndQuery(String term, String metadataTypeName, Set<Long> audienceIds, long creatorId, long limit) {
        MetadataType metadataType = this.getMetadataTypeByName(metadataTypeName);
        if (metadataType == null) {
            throw new IllegalArgumentException("Metadata Type " + metadataTypeName + " is not registered as a plugin");
        }
        if (StringUtils.isBlank((String)term)) {
            return this.metadataStorage.getMetadataNamesByUser(metadataType.getId(), creatorId, audienceIds, limit);
        }
        return this.metadataStorage.findMetadataNamesByUserAndQuery(term, metadataType.getId(), creatorId, audienceIds, limit);
    }

    public List<String> findMetadataNamesByAudiences(String term, String metadataTypeName, Set<Long> audienceIds, long limit) {
        MetadataType metadataType = this.getMetadataTypeByName(metadataTypeName);
        if (metadataType == null) {
            throw new IllegalArgumentException("Metadata Type " + metadataTypeName + " is not registered as a plugin");
        }
        if (StringUtils.isBlank((String)term)) {
            return this.metadataStorage.getMetadataNamesByAudiences(metadataType.getId(), audienceIds, limit);
        }
        return this.metadataStorage.findMetadataNameByAudiencesAndQuery(term, metadataType.getId(), audienceIds, limit);
    }

    public List<MetadataItem> getMetadataItemsByMetadataAndObject(MetadataKey metadataKey, MetadataObject object) {
        Metadata metadata = this.getMetadataByKey(metadataKey);
        if (metadata == null) {
            return Collections.emptyList();
        }
        return this.metadataStorage.getMetadataItemsByMetadataAndObject(metadata.getId(), object);
    }

    public List<String> getMetadataObjectIds(String metadataType, String metadataName, String objectType, long offset, long limit) {
        return this.metadataStorage.getMetadataObjectIds(metadataType, metadataName, objectType, offset, limit);
    }

    public void addMetadataTypePlugin(MetadataTypePlugin metadataTypePlugin) {
        if (this.metadataTypePlugins.values().stream().anyMatch(registeredPlugin -> {
            boolean sameIdWithdifferentName = !StringUtils.equals((String)registeredPlugin.getName(), (String)metadataTypePlugin.getName()) && registeredPlugin.getId() == metadataTypePlugin.getId();
            boolean sameNameWithDifferentId = StringUtils.equals((String)registeredPlugin.getName(), (String)metadataTypePlugin.getName()) && registeredPlugin.getId() != metadataTypePlugin.getId();
            return sameIdWithdifferentName || sameNameWithDifferentId;
        })) {
            throw new UnsupportedOperationException("Overriding existing Metadata Type with different ID or Name is not allowed. Please verify the unicity of Metadata Type id and name.");
        }
        this.metadataStorage.addMetadataType(metadataTypePlugin.getMetadataType());
        this.metadataTypePlugins.put(metadataTypePlugin.getName(), metadataTypePlugin);
    }

    public MetadataTypePlugin getMetadataTypePluginByName(String name) {
        return this.metadataTypePlugins.get(name);
    }

    public MetadataType getMetadataTypeByName(String name) {
        MetadataTypePlugin plugin = this.getMetadataTypePluginByName(name);
        return plugin == null ? null : plugin.getMetadataType();
    }

    public List<MetadataType> getMetadataTypes() {
        return this.metadataStorage.getMetadataTypes();
    }

    public void addMetadataPlugin(MetadataInitPlugin metadataInitPlugin) {
        this.metadataPlugins.add(metadataInitPlugin);
    }

    public List<Metadata> getMetadatas(String metadataTypeName, long limit) {
        return this.metadataStorage.getMetadatas(metadataTypeName, limit);
    }

    public List<Metadata> getMetadatasByProperty(String propertyKey, String propertyValue, long limit) {
        return this.metadataStorage.getMetadatasByProperty(propertyKey, propertyValue, limit);
    }

    @ExoTransactional
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        MetadataServiceImpl$AjcClosure1 metadataServiceImpl$AjcClosure1 = new MetadataServiceImpl$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(metadataServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void stop() {
    }

    private MetadataItem shareMetadataItem(MetadataObject metadataObject, MetadataKey metadataKey, String targetObjectId, long audienceId, long creatorId) {
        if (this.isShareable(metadataKey.getType())) {
            MetadataObject metadataObjectToShare = metadataObject.clone();
            metadataObjectToShare.setId(targetObjectId);
            MetadataKey metadataKeyToShare = metadataKey.clone();
            metadataKeyToShare.setAudienceId(audienceId);
            try {
                return this.createMetadataItem(metadataObjectToShare, metadataKeyToShare, creatorId);
            }
            catch (ObjectAlreadyExistsException e) {
                LOG.warn("The metadata object {} is already associated to Metadata with unique key {}. This doesn't affect the expected result, so continue processing.", new Object[]{metadataObjectToShare, metadataKeyToShare, e});
            }
        }
        return null;
    }

    private boolean isShareable(String metadataTypeName) {
        MetadataTypePlugin metadataTypePlugin = this.getMetadataTypePluginByName(metadataTypeName);
        return metadataTypePlugin != null && metadataTypePlugin.isShareable();
    }

    private boolean isAllowMultipleItemsPerObject(String metadataType) {
        MetadataTypePlugin plugin = this.getMetadataTypePluginByName(metadataType);
        return plugin.isAllowMultipleItemsPerObject();
    }

    static {
        MetadataServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(MetadataServiceImpl.class);
    }

    static /* synthetic */ void start_aroundBody0(MetadataServiceImpl ajc$this, JoinPoint joinPoint) {
        ajc$this.metadataPlugins.forEach(plugin -> {
            Metadata metadata = plugin.getMetadata();
            try {
                MetadataKey metadataKey = new MetadataKey(metadata.getTypeName(), metadata.getName(), metadata.getAudienceId());
                Metadata storedMetadata = this.metadataStorage.getMetadataByKey(metadataKey);
                if (storedMetadata == null) {
                    metadata.setId(0L);
                    metadata.setCreatorId(0L);
                    this.metadataStorage.createMetadata(metadata);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Can't process initialization of metadata : " + metadata), (Throwable)e);
            }
        });
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MetadataServiceImpl.java", MetadataServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.exoplatform.social.core.metadata.MetadataServiceImpl", "", "", "", "void"), 487);
    }
}

