/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.opensso;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.sso.agent.GenericAgent;
import org.gatein.sso.agent.opensso.CDMessageContext;
import org.gatein.sso.agent.opensso.CDMessageParser;
import org.gatein.sso.agent.opensso.OpenSSOAgent;

public class OpenSSOAgentImpl
extends GenericAgent
implements OpenSSOAgent {
    public static final String IN_RESPONSE_TO_ATTR = "OpenSSOAgent.InResponseTo";
    private static final String WINDOWS_SEPARATOR = "\r\n";
    private static final String UNIX_SEPARATOR = "\n";
    private static final String MAC_SEPARATOR = "\r";
    private static final String[] LINE_SEPARATORS = new String[]{"\r\n", "\n", "\r"};
    private static Log log = ExoLogger.getLogger(OpenSSOAgentImpl.class);
    private String cookieName;
    private String serverUrl;
    private final String lineSeparator;
    private CDMessageParser cdcMessageParser = new CDMessageParser();

    public OpenSSOAgentImpl(InitParams params) {
        if (params == null) {
            this.lineSeparator = null;
            return;
        }
        ValueParam lineSeparatorParam = params.getValueParam("lineSeparator");
        this.lineSeparator = lineSeparatorParam != null ? lineSeparatorParam.getValue() : null;
        log.debug((Object)("Agent configured with line separator: " + this.lineSeparator));
    }

    @Override
    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Override
    public void validateTicket(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        if (this.tryMessageFromCDC(httpRequest, httpResponse)) {
            return;
        }
        String token = null;
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(this.cookieName)) continue;
            token = cookie.getValue();
            break;
        }
        if (token == null) {
            this.throwIllegalStateException("No SSO Tokens Found");
        }
        if (token != null) {
            String subject;
            boolean isValid = this.isTokenValid(token);
            if (!isValid) {
                this.throwIllegalStateException("OpenSSO Token is not valid!!");
            }
            if ((subject = this.getSubject(token)) != null) {
                this.saveSSOCredentials(subject, httpRequest);
            }
        }
    }

    protected boolean tryMessageFromCDC(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        String encodedCDCMessage = httpRequest.getParameter("LARES");
        if (encodedCDCMessage == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Message from CDC not found in this HttpServletRequest");
            }
            return false;
        }
        CDMessageContext messageContext = this.cdcMessageParser.parseMessage(encodedCDCMessage);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Successfully parsed messageContext " + messageContext));
        }
        this.validateCDMessageContext(httpRequest, messageContext);
        String ssoToken = messageContext.getSsoToken();
        Cookie cookie = new Cookie(this.cookieName, "\"" + ssoToken + "\"");
        cookie.setPath(httpRequest.getContextPath());
        httpResponse.addCookie(cookie);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cookie " + this.cookieName + " with value " + ssoToken + " added to HttpResponse"));
        }
        String urlToRedirect = httpResponse.encodeRedirectURL(httpRequest.getRequestURI());
        httpResponse.sendRedirect(urlToRedirect);
        return true;
    }

    protected void validateCDMessageContext(HttpServletRequest httpRequest, CDMessageContext context) {
        if (!context.getSuccess().booleanValue()) {
            this.throwIllegalStateException("CDMessageContext contains success=false. Check SAML message from CDCServlet");
        }
        Integer inResponseToFromCDC = context.getInResponseTo();
        Integer inResponseToFromSession = (Integer)httpRequest.getSession().getAttribute(IN_RESPONSE_TO_ATTR);
        if (inResponseToFromSession == null || inResponseToFromCDC == null || !inResponseToFromCDC.equals(inResponseToFromSession)) {
            this.throwIllegalStateException("inResponseTo from CDC message is " + inResponseToFromCDC + ", inResponseTo from Http session is " + inResponseToFromSession + ". Both should have same value");
        }
        if (context.getSsoToken() == null) {
            this.throwIllegalStateException("No token found in CDMessageContext. Check SAML message from CDCServlet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTokenValid(String token) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            String url = this.serverUrl + "/identity/isTokenValid";
            HttpPost post = new HttpPost(url);
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(2);
            nameValuePairs.add(new BasicNameValuePair("tokenid", token));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)post);
            int status = httpResponse.getStatusLine().getStatusCode();
            HttpEntity entity = httpResponse.getEntity();
            String response = entity == null ? null : EntityUtils.toString((HttpEntity)entity);
            log.debug((Object)("Status of token validation: " + status));
            log.debug((Object)("Response from token validation: " + response));
            if (response.contains(Boolean.TRUE.toString())) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSubject(String token) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            String uid = null;
            String url = this.serverUrl + "/identity/attributes";
            HttpPost post = new HttpPost(url);
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(2);
            nameValuePairs.add(new BasicNameValuePair("subjectid", token));
            nameValuePairs.add(new BasicNameValuePair("attributes_names", "uid"));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)post);
            int status = httpResponse.getStatusLine().getStatusCode();
            HttpEntity entity = httpResponse.getEntity();
            String response = entity == null ? null : EntityUtils.toString((HttpEntity)entity);
            log.debug((Object)("Status of get subject: " + status));
            log.debug((Object)response);
            if (response != null) {
                Properties properties = this.loadAttributes(response);
                uid = properties.getProperty("uid");
            }
            String string = uid;
            return string;
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadAttributes(String response) throws Exception {
        try (InputStream is = null;){
            Properties properties = new Properties();
            String[] tokens = response.split(this.getLineSeparator(response));
            String name = null;
            for (String token : tokens) {
                if (token.startsWith("userdetails.attribute.name")) {
                    name = token.substring(token.indexOf("=") + 1);
                    continue;
                }
                if (!token.startsWith("userdetails.attribute.value")) continue;
                String value = token.substring(token.indexOf("=") + 1);
                if (name != null) {
                    properties.setProperty(name, value);
                }
                name = null;
            }
            Properties properties2 = properties;
            return properties2;
        }
    }

    private String getLineSeparator(String response) {
        if (this.lineSeparator != null) {
            return this.lineSeparator;
        }
        for (String current : LINE_SEPARATORS) {
            if (!response.contains(current)) continue;
            return current;
        }
        throw new IllegalArgumentException("Can't obtain line separator from response string: " + response);
    }

    private void throwIllegalStateException(String message) {
        log.warn((Object)message);
        IllegalStateException ise = new IllegalStateException(message);
        throw ise;
    }
}

