/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.model.reward;

import java.io.Serializable;
import java.time.LocalDateTime;
import org.exoplatform.wallet.model.reward.RewardPeriodType;
import org.exoplatform.wallet.model.reward.RewardSettings;
import org.exoplatform.wallet.utils.RewardUtils;

public class RewardPeriod
implements Serializable {
    private static final long serialVersionUID = -4860665131754056537L;
    private RewardPeriodType rewardPeriodType;
    private long startDateInSeconds;
    private long endDateInSeconds;

    public RewardPeriod(RewardPeriodType rewardPeriodType) {
        this.rewardPeriodType = rewardPeriodType;
    }

    public static RewardPeriod getCurrentPeriod(RewardSettings rewardSettings) {
        return RewardPeriod.getPeriodOfTime(rewardSettings, LocalDateTime.now());
    }

    public static RewardPeriod getPeriodOfTime(RewardSettings rewardSettings, LocalDateTime localDateTime) {
        RewardPeriodType rewardPeriodType = null;
        rewardPeriodType = rewardSettings == null || rewardSettings.getPeriodType() == null ? RewardPeriodType.DEFAULT : rewardSettings.getPeriodType();
        return rewardPeriodType.getPeriodOfTime(localDateTime);
    }

    public String getStartDateFormatted(String lang) {
        return RewardUtils.formatTime(this.startDateInSeconds, lang);
    }

    public String getEndDateFormatted(String lang) {
        return RewardUtils.formatTime(this.endDateInSeconds, lang);
    }

    public RewardPeriodType getRewardPeriodType() {
        return this.rewardPeriodType;
    }

    public long getStartDateInSeconds() {
        return this.startDateInSeconds;
    }

    public long getEndDateInSeconds() {
        return this.endDateInSeconds;
    }

    public void setRewardPeriodType(RewardPeriodType rewardPeriodType) {
        this.rewardPeriodType = rewardPeriodType;
    }

    public void setStartDateInSeconds(long startDateInSeconds) {
        this.startDateInSeconds = startDateInSeconds;
    }

    public void setEndDateInSeconds(long endDateInSeconds) {
        this.endDateInSeconds = endDateInSeconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RewardPeriod)) {
            return false;
        }
        RewardPeriod other = (RewardPeriod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RewardPeriodType this$rewardPeriodType = this.getRewardPeriodType();
        RewardPeriodType other$rewardPeriodType = other.getRewardPeriodType();
        if (this$rewardPeriodType == null ? other$rewardPeriodType != null : !((Object)((Object)this$rewardPeriodType)).equals((Object)other$rewardPeriodType)) {
            return false;
        }
        if (this.getStartDateInSeconds() != other.getStartDateInSeconds()) {
            return false;
        }
        return this.getEndDateInSeconds() == other.getEndDateInSeconds();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RewardPeriod;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RewardPeriodType $rewardPeriodType = this.getRewardPeriodType();
        result = result * 59 + ($rewardPeriodType == null ? 43 : ((Object)((Object)$rewardPeriodType)).hashCode());
        long $startDateInSeconds = this.getStartDateInSeconds();
        result = result * 59 + (int)($startDateInSeconds >>> 32 ^ $startDateInSeconds);
        long $endDateInSeconds = this.getEndDateInSeconds();
        result = result * 59 + (int)($endDateInSeconds >>> 32 ^ $endDateInSeconds);
        return result;
    }

    public String toString() {
        return "RewardPeriod(rewardPeriodType=" + this.getRewardPeriodType() + ", startDateInSeconds=" + this.getStartDateInSeconds() + ", endDateInSeconds=" + this.getEndDateInSeconds() + ")";
    }

    public RewardPeriod() {
    }
}

