/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.url;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.StringUtils;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestHandler;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.URIWriter;
import org.exoplatform.web.security.csrf.CSRFTokenUtil;
import org.exoplatform.web.url.PortalURL;
import org.exoplatform.web.url.URLContext;
import org.gatein.common.io.UndeclaredIOException;

public class PortalURLContext
implements URLContext {
    private static final char REPLACEMENT_CHAR = '\ufffd';
    private static volatile String globalSite;
    private static volatile String defaultSite;
    private final ControllerContext controllerContext;
    private final SiteKey siteKey;
    private URIWriter writer;
    private StringBuilder buffer;

    public PortalURLContext(ControllerContext controllerContext, SiteKey siteKey) {
        if (controllerContext == null) {
            throw new NullPointerException("No null controller context");
        }
        this.controllerContext = controllerContext;
        this.siteKey = siteKey;
        this.writer = null;
        this.buffer = null;
    }

    public <R, U extends PortalURL<R, U>> String render(U url) {
        try {
            return this._render(url);
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    private <R, U extends PortalURL<R, U>> String _render(U url) throws IOException {
        boolean ajax;
        if (url.getResource() == null) {
            throw new IllegalStateException("No resource set on portal URL");
        }
        if (this.writer == null) {
            this.buffer = new StringBuilder();
            this.writer = new URIWriter((Appendable)this.buffer);
        } else {
            this.buffer.setLength(0);
            this.writer.reset((Appendable)this.buffer);
        }
        HttpServletRequest req = this.controllerContext.getRequest();
        if (url.getSchemeUse()) {
            this.buffer.append(req.getScheme());
            this.buffer.append("://");
        }
        if (url.getAuthorityUse()) {
            this.buffer.append(req.getServerName());
            int port = req.getServerPort();
            if (port != 80) {
                this.buffer.append(':').append(port);
            }
        }
        this.writer.setMimeType(url.getMimeType());
        String confirm = url.getConfirm();
        boolean hasConfirm = confirm != null && confirm.length() > 0;
        boolean bl = ajax = url.getAjax() != null && url.getAjax() != false;
        if (ajax) {
            this.writer.append("javascript:");
            if (hasConfirm) {
                this.writer.append("if(confirm('");
                this.writer.append(confirm.replaceAll("'", "\\\\'"));
                this.writer.append("'))");
            }
            this.writer.append("ajaxGet('");
        } else if (hasConfirm) {
            this.writer.append("javascript:");
            this.writer.append("if(confirm('");
            this.writer.append(confirm.replaceAll("'", "\\\\'"));
            this.writer.append("'))");
            this.writer.append("window.location='");
        }
        HashMap<QualifiedName, String> parameters = new HashMap<QualifiedName, String>();
        parameters.put(WebAppController.HANDLER_PARAM, "portal");
        parameters.put(PortalRequestHandler.REQUEST_SITE_TYPE, this.siteKey.getTypeName());
        parameters.put(PortalRequestHandler.REQUEST_SITE_NAME, PortalURLContext.getSiteName(this.siteKey.getName()));
        String lang = "";
        Locale locale = url.getLocale();
        if (locale != null && locale.getLanguage().length() > 0) {
            lang = I18N.toTagIdentifier((Locale)locale);
        }
        parameters.put(PortalRequestHandler.LANG, lang);
        for (QualifiedName parameterName : url.getParameterNames()) {
            Object parameterValue = url.getParameterValue(parameterName);
            if (parameterValue == null) continue;
            parameterValue = PortalRequestHandler.REQUEST_SITE_NAME.equals((Object)parameterName) ? PortalURLContext.getSiteName((String)parameterValue) : ((String)parameterValue).replaceAll("&", "&amp;");
            parameters.put(parameterName, (String)parameterValue);
        }
        int untrustedStart = this.buffer.length();
        this.controllerContext.renderURL(parameters, this.writer);
        this.checkUntrustedData(untrustedStart);
        Map queryParameters = url.getQueryParameters();
        if (queryParameters != null) {
            for (Map.Entry entry : queryParameters.entrySet()) {
                for (String value : (String[])entry.getValue()) {
                    this.writer.appendQueryParameter((String)entry.getKey(), value);
                }
            }
        }
        if (url.isCSRFCheck()) {
            try {
                String token = CSRFTokenUtil.getToken((HttpServletRequest)req);
                if (token != null) {
                    this.writer.appendQueryParameter("portal:csrf", token);
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException("Can't add csrf token to url", exception);
            }
        }
        if (ajax) {
            this.writer.appendQueryParameter("ajaxRequest", "true");
            this.writer.append("')");
        } else if (hasConfirm) {
            this.writer.append("'");
        }
        return this.buffer.toString();
    }

    private void checkUntrustedData(int start) {
        int len = this.buffer.length();
        for (int i = start; i < len; ++i) {
            if (this.buffer.charAt(i) != '\'') continue;
            this.buffer.setCharAt(i, '\ufffd');
        }
    }

    public static String getSiteName(String siteName) {
        if (StringUtils.equals((CharSequence)siteName, (CharSequence)PortalURLContext.getGlobalSite())) {
            return PortalURLContext.getDefaultSite();
        }
        return siteName;
    }

    public static String getGlobalSite() {
        UserPortalConfigService portalConfigService;
        if (globalSite == null && (portalConfigService = (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class)) != null) {
            globalSite = portalConfigService.getGlobalPortal();
        }
        return globalSite;
    }

    public static String getDefaultSite() {
        UserPortalConfigService portalConfigService;
        if (defaultSite == null && (portalConfigService = (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class)) != null) {
            defaultSite = portalConfigService.getDefaultPortal();
        }
        return defaultSite;
    }
}

