/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityExistsException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/gamification/rules")
@Api(value="/gamification/rules", description="Manages rules")
@Produces(value={"application/json"})
public class ManageRulesEndpoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ManageRulesEndpoint.class);
    private final CacheControl cacheControl = new CacheControl();
    protected RuleService ruleService;
    protected IdentityManager identityManager;

    public ManageRulesEndpoint(RuleService ruleService, IdentityManager identityManager) {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.ruleService = ruleService;
        this.identityManager = identityManager;
    }

    @GET
    @Path(value="/all")
    @RolesAllowed(value={"users"})
    public Response getAllRules() {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            try {
                List<RuleDTO> allRules = this.ruleService.findAllRules();
                return Response.ok().cacheControl(this.cacheControl).entity(allRules).build();
            }
            catch (Exception e) {
                LOG.error((Object)"Error listing all rules ", (Throwable)e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error listing all rules").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @GET
    @Path(value="/active")
    @RolesAllowed(value={"users"})
    public Response getActiveRules() {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            try {
                List<RuleDTO> activesRules = this.ruleService.getActiveRules();
                return Response.ok().cacheControl(this.cacheControl).entity(activesRules).build();
            }
            catch (Exception e) {
                LOG.error((Object)"Error listing active rules ", (Throwable)e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error listing active rules").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="/add")
    public Response addRule(@ApiParam(value="rule object to save", required=true) RuleDTO ruleDTO) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String currentUserName = conversationState.getIdentity().getUserId();
            try {
                ruleDTO.setId(null);
                ruleDTO.setTitle(ruleDTO.getEvent() + "_" + ruleDTO.getArea());
                ruleDTO.setCreatedBy(currentUserName);
                ruleDTO.setLastModifiedBy(currentUserName);
                ruleDTO = this.ruleService.addRule(ruleDTO);
                return Response.ok().cacheControl(this.cacheControl).entity((Object)ruleDTO).build();
            }
            catch (EntityExistsException e) {
                LOG.error("Rule with event {} and domain {} already exist", new Object[]{ruleDTO.getEvent(), ruleDTO.getArea(), e});
                return Response.notModified().cacheControl(this.cacheControl).entity((Object)"Rule already exists").build();
            }
            catch (Exception e) {
                LOG.error("Error adding new rule {} by {} ", new Object[]{ruleDTO.getTitle(), currentUserName, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error adding new rule").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @PUT
    @RolesAllowed(value={"administrators"})
    @Path(value="/update")
    public Response updateRule(@Context HttpServletRequest request, @ApiParam(value="rule object to update", required=true) RuleDTO ruleDTO) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String currentUserName = conversationState.getIdentity().getUserId();
            try {
                Locale lc = request.getLocale();
                ruleDTO.setCreatedBy(currentUserName);
                ruleDTO.setLastModifiedBy(currentUserName);
                ruleDTO = this.ruleService.updateRule(ruleDTO);
                String actorId = this.identityManager.getOrCreateIdentity("organization", currentUserName).getId();
                LOG.info("service=gamification operation=edit-rule parameters=\"user_social_id:{},rule_id:{},rule_title:{},rule_description:{}\"", new Object[]{actorId, ruleDTO.getId(), ruleDTO.getTitle(), ruleDTO.getDescription()});
                return Response.ok().cacheControl(this.cacheControl).entity((Object)ruleDTO).build();
            }
            catch (EntityExistsException e) {
                LOG.error("Rule with event {} and domain {} already exist", new Object[]{ruleDTO.getEvent(), ruleDTO.getArea(), e});
                return Response.notModified().cacheControl(this.cacheControl).entity((Object)"Rule already exists").build();
            }
            catch (Exception e) {
                LOG.error("Error updating rule {} by {} ", new Object[]{ruleDTO.getTitle(), currentUserName, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error updating a rule").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @PUT
    @RolesAllowed(value={"administrators"})
    @Path(value="/delete/{id}")
    public Response deleteRule(@ApiParam(value="id of the rule", required=true) @PathParam(value="id") Long id) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            String currentUserName = conversationState.getIdentity().getUserId();
            try {
                this.ruleService.deleteRule(id);
                return Response.ok().cacheControl(this.cacheControl).entity((Object)("Rule " + id + " has been removed successfully ")).build();
            }
            catch (Exception e) {
                LOG.error("Error deleting rule {} by {} ", new Object[]{id, currentUserName, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error deleting a rule").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }
}

