/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationChildPlugin;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.service.setting.PluginContainer;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;

public class SocialNotificationUtils {
    private static final Log LOG = ExoLogger.getLogger(SocialNotificationUtils.class);
    public static final Pattern IMG_SRC_REGEX = Pattern.compile("<img[^>]*(?:(?:src\\s*=\\s*['\"]([^'\"]+)['\"])[^>]*(?:data-plugin-name\\s*=\\s*['\"](?:[^'\"]+)['\"]))[^>]*\\/>|<img[^>]*(?:(?:data-plugin-name\\s*=\\s*['\"](?:[^'\"]+)['\"])[^>]*(?:src\\s*=\\s*['\"]([^'\"]+)['\"]))[^>]*\\/>");
    public static final ArgumentLiteral<String> ACTIVITY_ID = new ArgumentLiteral(String.class, "activityId");
    public static final ArgumentLiteral<String> COMMENT_ID = new ArgumentLiteral(String.class, "commentId");
    public static final ArgumentLiteral<String> COMMENT_REPLY_ID = new ArgumentLiteral(String.class, "commentReplyId");
    public static final ArgumentLiteral<String> PARENT_ACTIVITY_ID = new ArgumentLiteral(String.class, "parentActivityId");
    public static final ArgumentLiteral<String> POSTER = new ArgumentLiteral(String.class, "poster");
    public static final ArgumentLiteral<String> LIKER = new ArgumentLiteral(String.class, "likersId");
    public static final ArgumentLiteral<String> SENDER = new ArgumentLiteral(String.class, "sender");
    public static final ArgumentLiteral<ExoSocialActivity> ACTIVITY = new ArgumentLiteral(ExoSocialActivity.class, "activity");
    public static final ArgumentLiteral<String> ORIGINAL_TITLE = new ArgumentLiteral(String.class, "original_title");
    public static final ArgumentLiteral<Profile> PROFILE = new ArgumentLiteral(Profile.class, "profile");
    public static final ArgumentLiteral<Space> SPACE = new ArgumentLiteral(Space.class, "space");
    public static final ArgumentLiteral<String> REMOTE_ID = new ArgumentLiteral(String.class, "remoteId");
    public static final ArgumentLiteral<String> SPACE_ID = new ArgumentLiteral(String.class, "spaceId");
    public static final ArgumentLiteral<String> REQUEST_FROM = new ArgumentLiteral(String.class, "request_from");
    public static final ArgumentLiteral<String> PRETTY_NAME = new ArgumentLiteral(String.class, "prettyName");
    public static final ArgumentLiteral<Relationship> RELATIONSHIP = new ArgumentLiteral(Relationship.class, "relationship");
    public static final ArgumentLiteral<String> RELATIONSHIP_ID = new ArgumentLiteral(String.class, "relationshipId");
    public static final ArgumentLiteral<Long> DLP_DETECTED_ITEM_ID = new ArgumentLiteral(Long.class, "dlp_detected_item_id");
    public static final ArgumentLiteral<String> DLP_RESTORED_ITEM_TITLE = new ArgumentLiteral(String.class, "dlp_restored_item_title");
    public static final ArgumentLiteral<String> DLP_RESTORED_ITEM_REFERENCE = new ArgumentLiteral(String.class, "dlp_restored_item_reference");
    public static final ArgumentLiteral<String> DLP_RESTORED_ITEM_AUTHOR = new ArgumentLiteral(String.class, "dlp_restored_item_author");
    public static final String EMPTY_STR = "";
    public static final String SPACE_STR = " ";
    public static final String DOT_STRING = ".";
    public static final String A_HREF_TAG_REGEX = "</?a[^>]*>";

    public static String getUserId(String identityId) {
        return Utils.getIdentityManager().getIdentity(identityId, false).getRemoteId();
    }

    public static List<String> toListUserIds(String ... userIds) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String userId : userIds) {
            ids.add(userId);
        }
        return ids;
    }

    public static boolean isSpaceActivity(ExoSocialActivity activity) {
        Identity id = Utils.getIdentityManager().getOrCreateIdentity("space", activity.getStreamOwner(), false);
        return id != null;
    }

    public static String getMessageInSpace(Map<String, List<String>> receiversMap, TemplateContext templateContext) {
        StringBuilder sb = new StringBuilder();
        Space space = null;
        String typeSpaceDisplay = templateContext.getPluginId().equals("PostActivitySpaceStreamPlugin") ? "space" : "space_members";
        for (Map.Entry<String, List<String>> entry : receiversMap.entrySet()) {
            sb.append("<li style=\"margin: 0 0 13px 14px; font-size: 13px; line-height: 18px; font-family: HelveticaNeue, Helvetica, Arial, sans-serif;\">");
            String id = entry.getKey();
            try {
                space = Utils.getSpaceService().getSpaceById(id);
            }
            catch (Exception e) {
                continue;
            }
            List<String> values = entry.getValue();
            int count = values.size();
            templateContext.put((Object)"SPACE", (Object)SocialNotificationUtils.buildRedirecUrl(typeSpaceDisplay, space.getId(), space.getDisplayName()));
            String[] keys = new String[]{"USER", "USER_LIST", "LAST3_USERS"};
            String key = EMPTY_STR;
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < count && i < 3; ++i) {
                Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", values.get(i), true);
                key = i > 1 && count == 3 ? keys[i - 1] : keys[i];
                value.append(SocialNotificationUtils.buildRedirecUrl("user", identity.getRemoteId(), identity.getProfile().getFullName()));
                if (count <= i + 1 || i >= 2) continue;
                value.append(", ");
            }
            templateContext.put((Object)key, (Object)value.toString());
            if (count > 3) {
                templateContext.put((Object)"COUNT", (Object)SocialNotificationUtils.buildRedirecUrl(typeSpaceDisplay, space.getId(), String.valueOf(count - 3)));
            }
            String digester = TemplateUtils.processDigest((TemplateContext)templateContext.digestType(count));
            sb.append(digester);
            sb.append("</li>");
        }
        return sb.toString();
    }

    public static String getMessageByIds(Map<String, List<String>> receiversMap, TemplateContext templateContext) {
        return SocialNotificationUtils.getMessageByIds(receiversMap, new HashMap<String, List<Pair<String, String>>>(), templateContext);
    }

    public static String getMessageByIds(Map<String, List<String>> receiversMap, Map<String, List<Pair<String, String>>> activityUserComments, TemplateContext templateContext) {
        StringBuilder sb = new StringBuilder();
        ExoSocialActivity activity = null;
        Space space = null;
        String typeActivityDisplay = templateContext.getPluginId().equals("LikePlugin") ? "view_likers_activity" : "view_full_activity";
        String typeSpaceDisplay = templateContext.getPluginId().equals("PostActivitySpaceStreamPlugin") ? "space" : "space_members";
        for (Map.Entry<String, List<String>> entry : receiversMap.entrySet()) {
            sb.append("<li style=\"margin: 0 0 13px 14px; font-size: 13px; line-height: 18px; font-family: HelveticaNeue, Helvetica, Arial, sans-serif;\">");
            String id = entry.getKey();
            try {
                if (templateContext.getPluginId().equals("PostActivitySpaceStreamPlugin")) {
                    space = Utils.getSpaceService().getSpaceById(id);
                } else {
                    activity = Utils.getActivityManager().getActivity(id);
                }
            }
            catch (Exception e) {
                continue;
            }
            List<String> values = entry.getValue();
            int count = values.size();
            if (activity != null) {
                String title = activity.getTitle();
                String imagePlaceHolder = SocialNotificationUtils.getImagePlaceHolder(templateContext.getLanguage());
                title = SocialNotificationUtils.processImageTitle(title, imagePlaceHolder);
                title = title.replaceAll(A_HREF_TAG_REGEX, EMPTY_STR);
                templateContext.put((Object)"ACTIVITY", (Object)SocialNotificationUtils.buildRedirecActivityUrl(typeActivityDisplay, activity.getId(), title));
            } else {
                templateContext.put((Object)"SPACE", (Object)SocialNotificationUtils.buildRedirecUrl(typeSpaceDisplay, space.getId(), space.getDisplayName()));
            }
            String[] keys = new String[]{"USER", "USER_LIST", "LAST3_USERS"};
            String key = EMPTY_STR;
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < count && i < 3; ++i) {
                Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", values.get(i), true);
                key = i > 1 && count == 3 ? keys[i - 1] : keys[i];
                value.append(SocialNotificationUtils.buildRedirecUrl("user", identity.getRemoteId(), identity.getProfile().getFullName()));
                if (count <= i + 1 || i >= 2) continue;
                value.append(", ");
            }
            templateContext.put((Object)key, (Object)value.toString());
            if (count > 3) {
                if (activity != null) {
                    templateContext.put((Object)"COUNT", (Object)SocialNotificationUtils.buildRedirecActivityUrl(typeActivityDisplay, activity.getId(), String.valueOf(count - 3)));
                } else {
                    templateContext.put((Object)"COUNT", (Object)SocialNotificationUtils.buildRedirecUrl(typeSpaceDisplay, space.getId(), String.valueOf(count - 3)));
                }
            }
            String digester = TemplateUtils.processDigest((TemplateContext)templateContext.digestType(count));
            sb.append(digester);
            List<Pair<String, String>> userComments = activityUserComments.get(id);
            if (userComments != null && userComments.size() > 0) {
                sb.append("<div style=\"background-color:#f9f9f9;padding: 10px;border-left:5px solid #AACDED; padding-left: 15px; color:black;overflow:hidden;text-overflow:ellipsis;max-width:500px;\">");
                Iterator<Pair<String, String>> iterator = userComments.iterator();
                if (iterator.hasNext()) {
                    Pair<String, String> pair = iterator.next();
                    if (userComments.size() > 1) {
                        sb.append("<b>").append((String)pair.getKey()).append(" : </b>");
                    }
                    sb.append("<div style=\"color:#333333; font-family: 'verdana,arial,sans-serif';white-space: normal; font-style: italic;max-height: 11px;\">").append((String)pair.getValue());
                    sb.append("</div>");
                    if (userComments.size() > 1) {
                        sb.append("...");
                    }
                    sb.append("<br/>");
                }
                sb.append("</div>");
                sb.append("<br/>");
            }
            sb.append("</li>");
        }
        return sb.toString();
    }

    public static String getMessageByIds(Map<String, List<String>> receiversMap, TemplateContext templateContext, String type) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : receiversMap.entrySet()) {
            sb.append("<li style=\"margin: 0 0 13px 14px; font-size: 13px; line-height: 18px; font-family: HelveticaNeue, Helvetica, Arial, sans-serif;\">");
            String targetId = entry.getKey();
            List<String> values = entry.getValue();
            int count = values.size();
            String[] keys = new String[]{"USER", "USER_LIST", "LAST3_USERS"};
            if ("space".equals(type)) {
                keys = new String[]{"SPACE", "SPACE_LIST", "LAST3_SPACES"};
            }
            String key = EMPTY_STR;
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < count && i < 3; ++i) {
                String name = EMPTY_STR;
                if ("new_user".equals(type) || "user".equals(type) || "connections_request".equals(type)) {
                    Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", values.get(i), true);
                    name = identity.getProfile().getFullName();
                } else {
                    Space space = Utils.getSpaceService().getSpaceById(values.get(i));
                    name = space.getDisplayName();
                }
                key = i > 1 && count == 3 ? keys[i - 1] : keys[i];
                value.append(SocialNotificationUtils.buildRedirecUrl("new_user".equals(type) ? "user" : type, values.get(i), name));
                if (count <= i + 1 || i >= 2) continue;
                value.append(", ");
            }
            templateContext.put((Object)key, (Object)value.toString());
            if (count > 3) {
                if ("user".equals(type)) {
                    templateContext.put((Object)"COUNT", (Object)SocialNotificationUtils.buildRedirecUrl("user_activity_stream", targetId, String.valueOf(count - 3)));
                    templateContext.put((Object)"ACTIVITY_STREAM", (Object)LinkProviderUtils.getRedirectUrl("user_activity_stream", targetId));
                } else if ("space".equals(type)) {
                    templateContext.put((Object)"COUNT", (Object)SocialNotificationUtils.buildRedirecUrl("space_invitation", targetId, String.valueOf(count - 3)));
                } else if ("new_user".equals(type)) {
                    templateContext.put((Object)"COUNT", (Object)SocialNotificationUtils.buildRedirecUrl("connections", "all", String.valueOf(count - 3)));
                } else {
                    templateContext.put((Object)"COUNT", (Object)SocialNotificationUtils.buildRedirecUrl("connections_request", targetId, String.valueOf(count - 3)));
                }
            } else if ("user".equals(type)) {
                templateContext.put((Object)"ACTIVITY_STREAM", (Object)LinkProviderUtils.getRedirectUrl("user_activity_stream", targetId));
            }
            String digester = TemplateUtils.processDigest((TemplateContext)templateContext.digestType(count));
            sb.append(digester);
            sb.append("</li>");
        }
        return sb.toString();
    }

    public static void processInforSendTo(Map<String, List<String>> map, String key, String value) {
        LinkedList<String> list = new LinkedList<String>();
        if (map.containsKey(key)) {
            list.addAll((Collection)map.get(key));
        }
        if (!list.contains(value)) {
            list.add(value);
        }
        map.put(key, new ArrayList(list));
    }

    public static void processInforUserComments(Map<String, List<Pair<String, String>>> map, String key, Pair<String, String> value) {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        if (map.containsKey(key)) {
            list.addAll((Collection)map.get(key));
        }
        list.add(value);
        map.put(key, list);
    }

    public static String buildRedirecUrl(String type, String id, String name) {
        String link = LinkProviderUtils.getRedirectUrl(type, id);
        return "<a target=\"_blank\" style=\"text-decoration: none; font-weight: bold; color: #2f5e92; font-family: 'HelveticaNeue Bold', Helvetica, Arial, sans-serif; font-size: 13px; line-height: 18px;\" href=\"" + link + "\">" + StringEscapeUtils.escapeHtml((String)name) + "</a>";
    }

    public static String buildRedirecActivityUrl(String type, String id, String activityTitle) {
        String link = LinkProviderUtils.getRedirectUrl(type, id);
        return "<a target=\"_blank\" style=\"text-decoration: none; color: #2f5e92; font-family: 'HelveticaNeue Bold', Helvetica, Arial, sans-serif; font-size: 13px; line-height: 18px;\" href=\"" + link + "\"><b>" + activityTitle + "</b></a>";
    }

    public static void addFooterAndFirstName(String remoteId, TemplateContext templateContext) {
        String firstName = EMPTY_STR;
        String redirectUrl = EMPTY_STR;
        Identity receiver = Utils.getIdentityManager().getOrCreateIdentity("organization", remoteId, true);
        if (receiver != null) {
            firstName = (String)receiver.getProfile().getProperty("firstName");
            redirectUrl = LinkProviderUtils.getRedirectUrl("notification_settings", receiver.getRemoteId());
        }
        templateContext.put((Object)"FIRSTNAME", (Object)firstName);
        templateContext.put((Object)"FOOTER_LINK", (Object)redirectUrl);
    }

    public static String processImageTitle(String body, String placeholder) {
        Matcher matcher = IMG_SRC_REGEX.matcher(body);
        int startIdex = 0;
        while (matcher.find(startIdex)) {
            String imageBody = matcher.group(0);
            body = body.replace(imageBody, "<i> [" + placeholder + "] </i>");
            startIdex = matcher.end(0);
        }
        return body;
    }

    public static String getImagePlaceHolder(String language) {
        return TemplateUtils.getResourceBundle((String)"Notification.label.InlineImage", (Locale)new Locale(language), (String)"locale.social.Webui");
    }

    public static String getBody(NotificationContext ctx, TemplateContext context, ExoSocialActivity activity) {
        PluginKey childKey = new PluginKey(activity.getType());
        PluginContainer pluginContainer = (PluginContainer)CommonsUtils.getService(PluginContainer.class);
        BaseNotificationPlugin child = pluginContainer.getPlugin(childKey);
        if (child == null || !(child instanceof AbstractNotificationChildPlugin)) {
            child = pluginContainer.getPlugin(new PluginKey("DEFAULT_ACTIVITY"));
        }
        context.put((Object)"ACTIVITY", (Object)((AbstractNotificationChildPlugin)child).makeContent(ctx));
        String body = TemplateUtils.processGroovy((TemplateContext)context);
        body = SocialNotificationUtils.processImageTitle(body, SocialNotificationUtils.getImagePlaceHolder(context.getLanguage()));
        return body;
    }

    public static NotificationInfo addUserToPreviousNotification(NotificationInfo notification, String propertyName, String activityId, String userId) {
        String commentId = notification.getValueOwnerParameter(COMMENT_ID.getKey());
        ArrayList<String> users = null;
        WebNotificationStorage storage = (WebNotificationStorage)CommonsUtils.getService(WebNotificationStorage.class);
        NotificationInfo previousNotification = storage.getUnreadNotification(notification.getKey().getId(), activityId, notification.getTo());
        if (previousNotification != null) {
            users = NotificationUtils.stringToList((String)previousNotification.getValueOwnerParameter(propertyName));
            Identity userIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", userId, true);
            if (users == null) {
                users = new ArrayList<String>();
            } else if (users.contains(userIdentity.getRemoteId())) {
                users.remove(userIdentity.getRemoteId());
            }
            users.add(userIdentity.getRemoteId());
            previousNotification.with(propertyName, NotificationUtils.listToString(users));
            previousNotification.with(NotificationMessageUtils.NOT_HIGHLIGHT_COMMENT_PORPERTY.getKey(), "true");
            previousNotification.setUpdate(true);
            previousNotification.setResetOnBadge(false);
            previousNotification.setLastModifiedDate(Calendar.getInstance());
            previousNotification.with(COMMENT_ID.getKey(), commentId);
            return previousNotification;
        }
        return notification;
    }

    public static List<String> mergeUsers(NotificationInfo notification, String propertyName, String activityId, String userId) {
        return NotificationUtils.stringToList((String)notification.getValueOwnerParameter(propertyName));
    }
}

