/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.dynamic.AbstractObjectNamingRule;
import com.datical.liquibase.ext.rules.api.Fact;
import com.datical.liquibase.ext.rules.api.FactEnum;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.api.Rule;
import com.datical.liquibase.ext.rules.api.Rules;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.AbstractRulesEngine;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.QualityChecksRulesEngine$RuleCombination;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import com.datical.liquibase.ext.rules.core.RuleIteration$FailureReason;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.license.LicenseServiceUtils;
import liquibase.logging.Logger;

public class QualityChecksRulesEngine
extends AbstractRulesEngine {
    private final CheckSettingsConfig checkSettingsConfig;
    private final List<QualityChecksRulesEngine$RuleCombination> executedRules = new ArrayList<QualityChecksRulesEngine$RuleCombination>();
    private final List<QualityChecksRulesEngine$RuleCombination> skippedRules = new ArrayList<QualityChecksRulesEngine$RuleCombination>();
    private final List<LiquibaseRuleResult> results = new ArrayList<LiquibaseRuleResult>();
    private final List<String> skippedBecauseOfExceptionRuleNames = new ArrayList<String>();
    public static final int COMMUNITY_CHECKS_LIMIT = 5;

    public List<QualityChecksRulesEngine$RuleCombination> getExecutedRules() {
        return this.executedRules;
    }

    public List<QualityChecksRulesEngine$RuleCombination> getSkippedRules() {
        return this.skippedRules;
    }

    public List<LiquibaseRuleResult> getResults() {
        return this.results;
    }

    public List<String> getSkippedBecauseOfExceptionRuleNames() {
        return this.skippedBecauseOfExceptionRuleNames;
    }

    public QualityChecksRulesEngine(CheckSettingsConfig checkSettingsConfig) {
        this.checkSettingsConfig = checkSettingsConfig;
    }

    @Override
    public void fire(Rules rules, Facts facts) {
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        this.triggerListenersBeforeRules(rules, facts);
        this.doFire(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
    }

    void doFire(Rules object, Facts facts) {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        if (((Rules)((Object)object)).isEmpty()) {
            logger.warning("No rules registered! Nothing to apply");
            return;
        }
        boolean bl2 = true;
        this.logEngineParameters();
        this.log((Rules)((Object)object));
        this.log(facts);
        logger.fine("Rules evaluation started");
        object = ((Rules)((Object)object)).iterator();
        block4: while (object.hasNext()) {
            Rule rule = object.next();
            String string = rule.getName();
            int n2 = rule.getPriority();
            if (n2 > this.parameters.getPriorityThreshold()) {
                logger.fine("Rule priority threshold (" + this.parameters.getPriorityThreshold() + ") exceeded at rule '" + string + "' with priority=" + n2 + ", next rule will be skipped");
                return;
            }
            if (!this.shouldBeEvaluated(rule, facts)) {
                logger.fine("Rule '" + string + "' has been skipped before being evaluated");
                continue;
            }
            List<AbstractConfigurableRule> list = this.getApplicableInstances(rule.getId());
            if (list == null) continue;
            for (AbstractConfigurableRule runtimeException : list) {
                boolean bl3;
                block15: {
                    facts.add(new Fact<AbstractConfigurableRule>(FactEnum.INSTANCE_SETTINGS.toString(), runtimeException));
                    if (rule instanceof AbstractLiquibaseRule) {
                        if (runtimeException instanceof DynamicRule) {
                            ((AbstractLiquibaseRule)rule).setResult(new LiquibaseRuleResult((AbstractLiquibaseRule)rule, (DynamicRule)runtimeException, new RuleIteration[0]));
                        } else {
                            ((AbstractLiquibaseRule)rule).setResult(new LiquibaseRuleResult((AbstractLiquibaseRule)rule));
                        }
                    }
                    bl3 = false;
                    if (!LicenseServiceUtils.isProLicenseValid() && this.executedRules.size() >= 5) {
                        this.skippedRules.add(new QualityChecksRulesEngine$RuleCombination(this, rule, runtimeException));
                        continue;
                    }
                    try {
                        if (!bl2 && rule instanceof AbstractObjectNamingRule) {
                            this.skippedBecauseOfExceptionRuleNames.add(this.getSkippedRuleName((AbstractObjectNamingRule)rule, runtimeException));
                            break block15;
                        }
                        bl3 = rule.evaluate(facts);
                        this.executedRules.add(new QualityChecksRulesEngine$RuleCombination(this, rule, runtimeException));
                        LiquibaseRuleResult exception = rule.getResult();
                        this.results.add(exception);
                        if (!exception.getExecutions().stream().anyMatch(ruleIteration -> RuleIteration$FailureReason.SQL_PARSING.equals((Object)ruleIteration.getFailureReason()))) break block15;
                        bl2 = false;
                    }
                    catch (RuntimeException runtimeException2) {
                        logger.severe("Rule '" + string + "' evaluated with error", runtimeException2);
                        Scope.getCurrentScope().getUI().sendErrorMessage("Rule '" + string + "' evaluated with error", runtimeException2);
                        this.triggerListenersOnEvaluationError(rule, facts, runtimeException2);
                        if (!this.parameters.isSkipOnFirstNonTriggeredRule()) break block15;
                        logger.fine("Next rule will be skipped since parameter skipOnFirstNonTriggeredRule is set");
                        continue block4;
                    }
                }
                if (bl3) {
                    logger.fine("Rule '" + string + "' triggered");
                    this.triggerListenersAfterEvaluate(rule, facts, true);
                    try {
                        this.triggerListenersBeforeExecute(rule, facts);
                        rule.execute(facts);
                        logger.fine("Rule '" + string + "' performed successfully");
                        this.triggerListenersOnSuccess(rule, facts);
                        if (!this.parameters.isSkipOnFirstAppliedRule()) continue;
                        logger.fine("Next rule will be skipped since parameter skipOnFirstAppliedRule is set");
                    }
                    catch (Exception exception) {
                        logger.severe("Rule '" + string + "' performed with error", exception);
                        this.triggerListenersOnFailure(rule, exception, facts);
                        if (!this.parameters.isSkipOnFirstFailedRule()) continue;
                        logger.fine("Next rule will be skipped since parameter skipOnFirstFailedRule is set");
                    }
                    continue block4;
                }
                logger.fine("Rule '" + string + "' has been evaluated to false, it has not been executed");
                this.triggerListenersAfterEvaluate(rule, facts, false);
                if (!this.parameters.isSkipOnFirstNonTriggeredRule()) continue;
                logger.fine("Next rule will be skipped since parameter skipOnFirstNonTriggeredRule is set");
                continue block4;
            }
        }
    }

    private String getSkippedRuleName(AbstractObjectNamingRule abstractObjectNamingRule, AbstractConfigurableRule abstractConfigurableRule) {
        if (abstractConfigurableRule instanceof DynamicRule) {
            return ((DynamicRule)abstractConfigurableRule).getShortName();
        }
        if (abstractObjectNamingRule.getShortName() != null) {
            return abstractObjectNamingRule.getShortName();
        }
        return abstractObjectNamingRule.getName();
    }

    public List<AbstractConfigurableRule> getApplicableInstances(UUID uUID) {
        return this.checkSettingsConfig.getRules().stream().filter(abstractConfigurableRule -> this.ruleMatches((AbstractConfigurableRule)abstractConfigurableRule, uUID)).collect(Collectors.toList());
    }

    private boolean ruleMatches(AbstractConfigurableRule abstractConfigurableRule, UUID uUID) {
        boolean bl2 = abstractConfigurableRule instanceof DynamicRule ? uUID.equals(abstractConfigurableRule.getId()) || ((DynamicRule)abstractConfigurableRule).getParentRuleId() != null && ((DynamicRule)abstractConfigurableRule).getParentRuleId().equals(uUID) : uUID.equals(abstractConfigurableRule.getId());
        return abstractConfigurableRule.isEnabled() && bl2;
    }

    private void logEngineParameters() {
        Scope.getCurrentScope().getLog(this.getClass()).fine(this.parameters.toString());
    }

    private void log(Rules object) {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        logger.fine("Registered rules:");
        object = ((Rules)object).iterator();
        while (object.hasNext()) {
            Rule rule = (Rule)object.next();
            logger.fine("Rule { name = '" + rule.getName() + "', description = '" + rule.getDescription() + "', priority = '" + rule.getPriority() + "'}");
        }
    }

    private void log(Facts object) {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        logger.fine("Known facts:");
        object = ((Facts)object).iterator();
        while (object.hasNext()) {
            Fact fact = (Fact)object.next();
            logger.fine(fact.toString());
        }
    }

    @Override
    public Map<Rule, Boolean> check(Rules rules, Facts facts) {
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        this.triggerListenersBeforeRules(rules, facts);
        Map<Rule, Boolean> map = this.doCheck(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
        return map;
    }

    private Map<Rule, Boolean> doCheck(Rules object, Facts facts) {
        Scope.getCurrentScope().getLog(this.getClass()).fine("Checking rules");
        HashMap<Rule, Boolean> hashMap = new HashMap<Rule, Boolean>();
        object = ((Rules)object).iterator();
        while (object.hasNext()) {
            Rule rule = (Rule)object.next();
            if (!this.shouldBeEvaluated(rule, facts)) continue;
            Rule rule2 = rule;
            hashMap.put(rule2, rule2.evaluate(facts));
        }
        return hashMap;
    }

    private void triggerListenersOnFailure(Rule rule, Exception exception, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onFailure(rule, facts, exception));
    }

    private void triggerListenersOnSuccess(Rule rule, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onSuccess(rule, facts));
    }

    private void triggerListenersBeforeExecute(Rule rule, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.beforeExecute(rule, facts));
    }

    private boolean triggerListenersBeforeEvaluate(Rule rule, Facts facts) {
        return this.ruleListeners.stream().allMatch(ruleListener -> ruleListener.beforeEvaluate(rule, facts));
    }

    private void triggerListenersAfterEvaluate(Rule rule, Facts facts, boolean bl2) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.afterEvaluate(rule, facts, bl2));
    }

    private void triggerListenersOnEvaluationError(Rule rule, Facts facts, Exception exception) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onEvaluationError(rule, facts, exception));
    }

    private void triggerListenersBeforeRules(Rules rules, Facts facts) {
        this.rulesEngineListeners.forEach(rulesEngineListener -> rulesEngineListener.beforeEvaluate(rules, facts));
    }

    private void triggerListenersAfterRules(Rules rules, Facts facts) {
        this.rulesEngineListeners.forEach(rulesEngineListener -> rulesEngineListener.afterExecute(rules, facts));
    }

    private boolean shouldBeEvaluated(Rule rule, Facts facts) {
        return this.triggerListenersBeforeEvaluate(rule, facts);
    }
}

