/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Collections;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.quality.DefaultAbsoluteExternalPositionalAccuracy;
import org.apache.sis.metadata.iso.quality.DefaultConformanceResult;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.metadata.quality.Result;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;

@XmlTransient
public final class PositionalAccuracyConstant
extends DefaultAbsoluteExternalPositionalAccuracy {
    private static final long serialVersionUID = -2554090935254116470L;
    public static final double UNKNOWN_ACCURACY = 3000.0;
    private static final double DATUM_SHIFT_ACCURACY = 25.0;
    public static final PositionalAccuracy DATUM_SHIFT_APPLIED;
    public static final PositionalAccuracy DATUM_SHIFT_OMITTED;

    private PositionalAccuracyConstant(InternationalString internationalString, InternationalString internationalString2, boolean bl) {
        DefaultConformanceResult defaultConformanceResult = new DefaultConformanceResult(Citations.SIS, (CharSequence)internationalString2, bl);
        this.setResults(Collections.singleton(defaultConformanceResult));
        this.setMeasureDescription(internationalString);
        this.setEvaluationMethodDescription(internationalString2);
        this.setEvaluationMethodType(EvaluationMethodType.DIRECT_INTERNAL);
        this.transitionTo(ModifiableMetadata.State.FINAL);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.equals(DATUM_SHIFT_APPLIED)) {
            return DATUM_SHIFT_APPLIED;
        }
        if (this.equals(DATUM_SHIFT_OMITTED)) {
            return DATUM_SHIFT_OMITTED;
        }
        return this;
    }

    public static double getLinearAccuracy(CoordinateOperation coordinateOperation) {
        double d = Double.NaN;
        Collection collection = coordinateOperation.getCoordinateOperationAccuracy();
        for (PositionalAccuracy positionalAccuracy : collection) {
            for (Result result : positionalAccuracy.getResults()) {
                Unit unit;
                QuantitativeResult quantitativeResult;
                Collection collection2;
                if (!(result instanceof QuantitativeResult) || (collection2 = (quantitativeResult = (QuantitativeResult)result).getValues()) == null || !Units.isLinear((Unit)(unit = quantitativeResult.getValueUnit()))) continue;
                Unit unit2 = unit.asType(Length.class);
                for (Record record : collection2) {
                    for (Object v : record.getAttributes().values()) {
                        if (!(v instanceof Number)) continue;
                        double d2 = ((Number)v).doubleValue();
                        d2 = unit2.getConverterTo(Units.METRE).convert(d2);
                        if (!(d2 >= 0.0) || d2 <= d) continue;
                        d = d2;
                    }
                }
            }
        }
        if (Double.isNaN(d)) {
            if (coordinateOperation instanceof Conversion) {
                return 0.0;
            }
            if (coordinateOperation instanceof Transformation) {
                if (collection.contains(DATUM_SHIFT_APPLIED)) {
                    return 25.0;
                }
                if (collection.contains(DATUM_SHIFT_OMITTED)) {
                    return 3000.0;
                }
            }
            if (coordinateOperation instanceof ConcatenatedOperation) {
                for (PositionalAccuracy positionalAccuracy : ((ConcatenatedOperation)coordinateOperation).getOperations()) {
                    double d3 = Math.abs(PositionalAccuracyConstant.getLinearAccuracy((CoordinateOperation)positionalAccuracy));
                    if (Double.isNaN(d3)) continue;
                    if (Double.isNaN(d)) {
                        d = d3;
                        continue;
                    }
                    d += d3;
                }
            }
        }
        return d;
    }

    static {
        InternationalString internationalString = Vocabulary.formatInternational((short)103);
        InternationalString internationalString2 = Resources.formatInternational((short)11);
        DATUM_SHIFT_APPLIED = new PositionalAccuracyConstant(internationalString, internationalString2, true);
        DATUM_SHIFT_OMITTED = new PositionalAccuracyConstant(internationalString, internationalString2, false);
    }
}

