/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Disposable;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.Startable;
import org.picocontainer.defaults.AbstractPicoVisitor;

public class LifecycleVisitor
extends AbstractPicoVisitor {
    private static final Method START;
    private static final Method STOP;
    private static final Method DISPOSE;
    private final Method method;
    private final Class type;
    private final boolean visitInInstantiationOrder;
    private final List componentInstances;

    public LifecycleVisitor(Method method, Class ofType, boolean visitInInstantiationOrder) {
        this.method = method;
        this.type = ofType;
        this.visitInInstantiationOrder = visitInInstantiationOrder;
        this.componentInstances = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object traverse(Object node) {
        this.componentInstances.clear();
        try {
            super.traverse(node);
            if (!this.visitInInstantiationOrder) {
                Collections.reverse(this.componentInstances);
            }
            Iterator iterator = this.componentInstances.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                long startTime = System.currentTimeMillis();
                try {
                    try {
                        this.method.invoke(o, null);
                    }
                    catch (IllegalArgumentException e) {
                        throw new PicoIntrospectionException("Can't call " + this.method.getName() + " on " + o, e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PicoIntrospectionException("Can't call " + this.method.getName() + " on " + o, e);
                    }
                    catch (InvocationTargetException e) {
                        throw new PicoIntrospectionException("Failed when calling " + this.method.getName() + " on " + o, e.getTargetException());
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                    return Void.TYPE;
                }
            }
        }
        finally {
            this.componentInstances.clear();
        }
    }

    public void visitContainer(PicoContainer pico) {
        this.checkTraversal();
        this.componentInstances.addAll(pico.getComponentInstancesOfType(this.type));
    }

    public void visitComponentAdapter(ComponentAdapter componentAdapter) {
        this.checkTraversal();
    }

    public void visitParameter(Parameter parameter) {
        this.checkTraversal();
    }

    public static void start(Object node) {
        new LifecycleVisitor(START, Startable.class, true).traverse(node);
    }

    public static void stop(Object node) {
        new LifecycleVisitor(STOP, Startable.class, false).traverse(node);
    }

    public static void dispose(Object node) {
        new LifecycleVisitor(DISPOSE, Disposable.class, false).traverse(node);
    }

    static {
        try {
            START = Startable.class.getMethod("start", null);
            STOP = Startable.class.getMethod("stop", null);
            DISPOSE = Disposable.class.getMethod("dispose", null);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

