/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.IllformedLocaleException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.UnaryOperator;
import java.util.logging.Filter;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.validation.Schema;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.internal.xml.LegacyNamespaces;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Locales;
import org.apache.sis.util.Version;
import org.apache.sis.util.logging.WarningListener;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.Implementation;
import org.apache.sis.xml.ReferenceResolver;
import org.apache.sis.xml.TransformVersion;
import org.apache.sis.xml.ValueConverter;

abstract class Pooled {
    private static final String[] SCHEMA_KEYS = new String[]{"cat", "gmd"};
    private final boolean internal;
    final Map<Object, Object> initialProperties;
    private int bitMasks;
    private Locale locale;
    private TimeZone timezone;
    private Map<String, String> schemas;
    private Version versionGML;
    private Version versionMetadata;
    private ReferenceResolver resolver;
    private ValueConverter converter;
    private UnaryOperator<Object>[] rootAdapters;
    private Filter warningListener;
    volatile long resetTime;

    Pooled(boolean bl) {
        this.internal = bl;
        this.initialProperties = new LinkedHashMap<Object, Object>();
    }

    Pooled(Pooled pooled) {
        this.initialProperties = new LinkedHashMap<Object, Object>();
        this.internal = pooled.internal;
    }

    final void initialize(Pooled pooled) throws JAXBException {
        this.reset(pooled);
        for (Map.Entry<Object, Object> entry : pooled.initialProperties.entrySet()) {
            this.setStandardProperty((String)entry.getKey(), entry.getValue());
        }
    }

    public final void reset(Pooled pooled) throws JAXBException {
        for (Map.Entry<Object, Object> entry : this.initialProperties.entrySet()) {
            this.reset(entry.getKey(), entry.getValue());
        }
        this.initialProperties.clear();
        this.bitMasks = pooled.bitMasks;
        this.locale = pooled.locale;
        this.timezone = pooled.timezone;
        this.schemas = pooled.schemas;
        this.versionGML = pooled.versionGML;
        this.versionMetadata = pooled.versionMetadata;
        this.resolver = pooled.resolver;
        this.converter = pooled.converter;
        this.rootAdapters = pooled.rootAdapters;
        this.warningListener = pooled.warningListener;
        this.resetTime = System.nanoTime();
        if (this instanceof Marshaller) {
            this.bitMasks |= 1;
        }
    }

    protected abstract void reset(Object var1, Object var2) throws JAXBException;

    final TransformVersion getTransformVersion() {
        int n;
        boolean bl = (this.bitMasks & 0x41) == 64;
        int n2 = n = (this.specificBitMasks() & 0x20) != 0 ? 2 : 0;
        if (this.versionGML == null ? bl : this.versionGML.compareTo(LegacyNamespaces.VERSION_3_2_1) < 0) {
            n = 1;
        }
        if (this.versionMetadata == null ? bl : this.versionMetadata.compareTo(LegacyNamespaces.VERSION_2014) < 0) {
            n |= 2;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return TransformVersion.GML31;
            }
            case 2: {
                return TransformVersion.ISO19139;
            }
            case 3: {
                return TransformVersion.ALL;
            }
        }
        throw new AssertionError(n);
    }

    final boolean isPropertySaved(Class<?> clazz) {
        return this.initialProperties.containsKey(clazz);
    }

    final <E> void saveProperty(Class<E> clazz, E e) {
        if (this.initialProperties.put(clazz, e) != null) {
            throw new ConcurrentModificationException(Errors.format((short)134, (Object)(clazz.getInterfaces()[0].getSimpleName() + ".get" + clazz.getSimpleName())));
        }
    }

    public final void setProperty(String string, Object object) throws PropertyException {
        try {
            switch (string) {
                case "org.apache.sis.xml.locale": {
                    this.locale = object instanceof CharSequence ? Locales.parse((String)object.toString()) : (Locale)object;
                    return;
                }
                case "org.apache.sis.xml.timezone": {
                    this.timezone = object instanceof CharSequence ? TimeZone.getTimeZone(object.toString()) : (TimeZone)object;
                    return;
                }
                case "org.apache.sis.xml.schemas": {
                    Map map = (Map)object;
                    Map<String, String> map2 = null;
                    if (map != null) {
                        map2 = new HashMap(4);
                        for (String string2 : SCHEMA_KEYS) {
                            Object v = map.get(string2);
                            if (v == null) continue;
                            if (!(v instanceof String)) {
                                throw new PropertyException(Errors.format((short)58, (Object)Strings.bracket((String)string, (Object)string2), object.getClass()));
                            }
                            map2.put(string2, (String)v);
                        }
                        map2 = CollectionsExt.unmodifiableOrCopy(map2);
                    }
                    this.schemas = map2;
                    return;
                }
                case "org.apache.sis.gml.version": {
                    this.versionGML = object instanceof CharSequence ? new Version(object.toString()) : (Version)object;
                    return;
                }
                case "org.apache.sis.xml.version.metadata": {
                    this.versionMetadata = object instanceof CharSequence ? new Version(object.toString()) : (Version)object;
                    return;
                }
                case "org.apache.sis.xml.resolver": {
                    this.resolver = (ReferenceResolver)object;
                    return;
                }
                case "org.apache.sis.xml.converter": {
                    this.converter = (ValueConverter)object;
                    return;
                }
                case "org.apache.sis.xml.lenient": {
                    this.bitMasks = (object instanceof CharSequence ? Boolean.parseBoolean(object.toString()) : (Boolean)object != false) ? (this.bitMasks |= 0x40) : (this.bitMasks &= 0xFFFFFFBF);
                    return;
                }
                case "org.apache.sis.xml.stringSubstitutes": {
                    this.bitMasks &= 0xFFFFFFE1;
                    if (object != null) {
                        for (CharSequence charSequence : (CharSequence[])object) {
                            if (CharSequences.equalsIgnoreCase((CharSequence)charSequence, (CharSequence)"language")) {
                                this.bitMasks |= 2;
                                continue;
                            }
                            if (CharSequences.equalsIgnoreCase((CharSequence)charSequence, (CharSequence)"country")) {
                                this.bitMasks |= 4;
                                continue;
                            }
                            if (CharSequences.equalsIgnoreCase((CharSequence)charSequence, (CharSequence)"filename")) {
                                this.bitMasks |= 8;
                                continue;
                            }
                            if (!CharSequences.equalsIgnoreCase((CharSequence)charSequence, (CharSequence)"mimetype")) continue;
                            this.bitMasks |= 0x10;
                        }
                    }
                    return;
                }
                case "org.apache.sis.xml.warningFilter": {
                    this.warningListener = (Filter)object;
                    return;
                }
                case "org.apache.sis.xml.warningListener": {
                    this.warningListener = ((WarningListener)object).asFilter();
                    return;
                }
                case "org.apache.sis.xml.rootAdapters": {
                    UnaryOperator[] unaryOperatorArray = (UnaryOperator[])object;
                    this.rootAdapters = unaryOperatorArray;
                    return;
                }
            }
        }
        catch (ClassCastException | IllformedLocaleException runtimeException) {
            throw new PropertyException(Errors.format((short)58, (Object)string, object.getClass()), (Throwable)runtimeException);
        }
        if (this.internal) {
            string = Implementation.toInternal(string);
        }
        if (!this.initialProperties.containsKey(string) && this.initialProperties.put(string, this.getStandardProperty(string)) != null) {
            throw new ConcurrentModificationException(string);
        }
        this.setStandardProperty(string, object);
    }

    public final Object getProperty(String string) throws PropertyException {
        switch (string) {
            case "org.apache.sis.xml.locale": {
                return this.locale;
            }
            case "org.apache.sis.xml.timezone": {
                return this.timezone;
            }
            case "org.apache.sis.xml.schemas": {
                return this.schemas;
            }
            case "org.apache.sis.gml.version": {
                return this.versionGML;
            }
            case "org.apache.sis.xml.version.metadata": {
                return this.versionMetadata;
            }
            case "org.apache.sis.xml.resolver": {
                return this.resolver;
            }
            case "org.apache.sis.xml.converter": {
                return this.converter;
            }
            case "org.apache.sis.xml.warningFilter": {
                return this.warningListener;
            }
            case "org.apache.sis.xml.warningListener": {
                return null;
            }
            case "org.apache.sis.xml.lenient": {
                return (this.bitMasks & 0x40) != 0;
            }
            case "org.apache.sis.xml.stringSubstitutes": {
                int n = 0;
                Object[] objectArray = new String[4];
                if ((this.bitMasks & 2) != 0) {
                    objectArray[n++] = "language";
                }
                if ((this.bitMasks & 4) != 0) {
                    objectArray[n++] = "country";
                }
                if ((this.bitMasks & 8) != 0) {
                    objectArray[n++] = "filename";
                }
                if ((this.bitMasks & 0x10) != 0) {
                    objectArray[n++] = "mimetype";
                }
                return n != 0 ? ArraysExt.resize((Object[])objectArray, (int)n) : null;
            }
            case "org.apache.sis.xml.rootAdapters": {
                return this.rootAdapters != null ? this.rootAdapters.clone() : null;
            }
        }
        if (this.internal) {
            string = Implementation.toInternal(string);
        }
        return this.getStandardProperty(string);
    }

    abstract void setStandardProperty(String var1, Object var2) throws PropertyException;

    abstract Object getStandardProperty(String var1) throws PropertyException;

    public final void setAdapter(XmlAdapter xmlAdapter) {
        this.setAdapter(xmlAdapter.getClass(), xmlAdapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> clazz, A a) {
        if (!this.isPropertySaved(clazz)) {
            this.saveProperty(clazz, this.getAdapter(clazz));
        }
    }

    public abstract <A extends XmlAdapter> A getAdapter(Class<A> var1);

    final UnaryOperator<Object>[] getRootAdapters() {
        return this.rootAdapters;
    }

    public void setSchema(Schema schema) {
        if (!this.isPropertySaved(Schema.class)) {
            this.saveProperty(Schema.class, this.getSchema());
        }
    }

    public abstract Schema getSchema();

    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        if (!this.initialProperties.containsKey(ValidationEventHandler.class)) {
            this.saveProperty(ValidationEventHandler.class, this.getEventHandler());
        }
    }

    public abstract ValidationEventHandler getEventHandler() throws JAXBException;

    int specificBitMasks() {
        return 0;
    }

    final Context begin() {
        return new Context(this.bitMasks | this.specificBitMasks(), this.locale, this.timezone, this.schemas, this.versionGML, this.versionMetadata, this.resolver, this.converter, this.warningListener);
    }
}

