/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.configuration;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.entities.domain.configuration.RuleEntity;
import org.exoplatform.addons.gamification.service.ChallengeService;
import org.exoplatform.addons.gamification.service.dto.configuration.Challenge;
import org.exoplatform.addons.gamification.service.mapper.EntityMapper;
import org.exoplatform.addons.gamification.storage.RuleStorage;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ChallengeServiceImpl
implements ChallengeService {
    private RuleStorage challengeStorage;
    private SpaceService spaceService;
    private String groupOfCreators;
    private static final String CREATORS_GROUP_KEY = "challenge.creator.group";

    public ChallengeServiceImpl(RuleStorage challengeStorage, SpaceService spaceService, InitParams params) {
        this.challengeStorage = challengeStorage;
        this.spaceService = spaceService;
        if (params != null && params.containsKey((Object)CREATORS_GROUP_KEY)) {
            this.groupOfCreators = params.getValueParam(CREATORS_GROUP_KEY).getValue();
        }
    }

    @Override
    public Challenge createChallenge(Challenge challenge, String username) throws IllegalAccessException {
        if (challenge == null) {
            throw new IllegalArgumentException("Challenge is mandatory");
        }
        if (challenge.getId() != 0L) {
            throw new IllegalArgumentException("challenge id must be equal to 0");
        }
        Identity identity = Utils.getIdentityByTypeAndId("organization", username);
        if (identity == null) {
            throw new IllegalArgumentException("identity is not exist");
        }
        String idSpace = String.valueOf(challenge.getAudience());
        if (StringUtils.isBlank((CharSequence)idSpace)) {
            throw new IllegalArgumentException("space id must not be null or empty");
        }
        Date startDate = Utils.parseSimpleDate(challenge.getStartDate());
        Date endDate = Utils.parseSimpleDate(challenge.getEndDate());
        if (startDate != null && endDate != null && endDate.compareTo(startDate) <= 0) {
            throw new IllegalArgumentException("endDate must be greater than startDate");
        }
        Space space = this.spaceService.getSpaceById(idSpace);
        if (!this.spaceService.isManager(space, username)) {
            throw new IllegalAccessException("user is not allowed to create challenge");
        }
        return this.challengeStorage.saveChallenge(challenge, username);
    }

    @Override
    public Challenge createChallenge(Challenge challenge) {
        return this.challengeStorage.saveChallenge(challenge, "SYSTEM");
    }

    @Override
    public Challenge getChallengeById(long challengeId, String username) throws IllegalAccessException {
        if (challengeId <= 0L) {
            throw new IllegalArgumentException("Challenge id has to be positive integer");
        }
        Challenge challenge = this.challengeStorage.getChallengeById(challengeId);
        if (challenge == null) {
            return null;
        }
        String idSpace = String.valueOf(challenge.getAudience());
        if (StringUtils.isBlank((CharSequence)idSpace)) {
            throw new IllegalArgumentException("space id must not be null or empty");
        }
        Space space = this.spaceService.getSpaceById(idSpace);
        if (!this.spaceService.isManager(space, username) && !this.spaceService.isMember(space, username)) {
            throw new IllegalAccessException("user is not allowed to access to the challenge");
        }
        return challenge;
    }

    @Override
    public Challenge updateChallenge(Challenge challenge, String username) throws IllegalArgumentException, ObjectNotFoundException, IllegalAccessException {
        if (challenge == null) {
            throw new IllegalArgumentException("Challenge is mandatory");
        }
        if (challenge.getId() == 0L) {
            throw new IllegalArgumentException("challenge id must not be equal to 0");
        }
        String idSpace = String.valueOf(challenge.getAudience());
        if (StringUtils.isBlank((CharSequence)idSpace)) {
            throw new IllegalArgumentException("space id must not be null or empty");
        }
        Space space = this.spaceService.getSpaceById(idSpace);
        if (!this.spaceService.isManager(space, username)) {
            throw new IllegalAccessException("user is not allowed to modify challenge");
        }
        Challenge oldChallenge = this.challengeStorage.getChallengeById(challenge.getId());
        if (oldChallenge == null) {
            throw new ObjectNotFoundException("challenge is not exist");
        }
        if (oldChallenge.equals(challenge)) {
            throw new IllegalArgumentException("there are no changes to save");
        }
        return this.challengeStorage.saveChallenge(challenge, username);
    }

    @Override
    public boolean canAddChallenge() {
        if (this.groupOfCreators != null) {
            return ConversationState.getCurrent().getIdentity().isMemberOf(this.groupOfCreators);
        }
        return false;
    }

    @Override
    public List<Challenge> getAllChallengesByUser(int offset, int limit, String userName) throws Exception {
        int limitToFetch;
        if (StringUtils.isBlank((CharSequence)userName)) {
            throw new IllegalAccessException("user name must not be null");
        }
        ArrayList<Long> listIdSpace = new ArrayList<Long>();
        ListAccess userSpaces = this.spaceService.getMemberSpaces(userName);
        int spacesSize = userSpaces.getSize();
        int offsetToFetch = 0;
        int n = limitToFetch = spacesSize > 20 ? 20 : spacesSize;
        while (limitToFetch > 0) {
            Space[] spaces = (Space[])userSpaces.load(offsetToFetch, limitToFetch);
            Arrays.stream(spaces).forEach(space -> listIdSpace.add(Long.valueOf(space.getId())));
            limitToFetch = spacesSize - (offsetToFetch += limitToFetch) > 20 ? 20 : spacesSize - offsetToFetch;
        }
        if (listIdSpace.isEmpty()) {
            return Collections.emptyList();
        }
        List<RuleEntity> challengeEntities = this.challengeStorage.findAllChallengesByUser(offset, limit, listIdSpace);
        return EntityMapper.fromChallengeEntities(challengeEntities);
    }

    @Override
    public void clearUserChallengeCache() {
        this.challengeStorage.clearCache();
    }

    @Override
    public void deleteChallenge(Long challengeId, String username) throws IllegalAccessException, ObjectNotFoundException {
        Date currentDate;
        if (challengeId <= 0L) {
            throw new IllegalArgumentException("Challenge id has to be positive integer");
        }
        Challenge challenge = this.challengeStorage.getChallengeById(challengeId);
        if (challenge == null) {
            throw new ObjectNotFoundException("challenge is not exist");
        }
        if (!Utils.canEditChallenge(challenge.getManagers(), String.valueOf(challenge.getAudience()))) {
            throw new IllegalAccessException("your are not able to delete challenge");
        }
        if (Utils.countAnnouncementsByChallenge(challengeId) > 0L) {
            throw new IllegalArgumentException("challenge already have announcements");
        }
        Date endDate = Utils.parseSimpleDate(challenge.getEndDate());
        if (endDate.after(currentDate = Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant())) || endDate.equals(currentDate)) {
            throw new IllegalArgumentException("Challenge does not ended yet");
        }
        this.challengeStorage.deleteChallenge(challenge);
    }
}

