/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.ContextExpression;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.IncludeAllFilter;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ValidatingVisitor;
import liquibase.database.Database;
import liquibase.database.DatabaseList;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.exception.LiquibaseException;
import liquibase.exception.SetupException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.UnknownChangelogFormatException;
import liquibase.exception.ValidationFailedException;
import liquibase.logging.Logger;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.precondition.Conditional;
import liquibase.precondition.Precondition;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.LiquibaseService;
import liquibase.util.FilenameUtil;
import liquibase.util.StringUtil;

public class DatabaseChangeLog
implements Comparable<DatabaseChangeLog>,
Conditional {
    private static final ThreadLocal<DatabaseChangeLog> ROOT_CHANGE_LOG = new ThreadLocal();
    private static final ThreadLocal<DatabaseChangeLog> PARENT_CHANGE_LOG = new ThreadLocal();
    private static final Logger LOG = Scope.getCurrentScope().getLog(DatabaseChangeLog.class);
    private PreconditionContainer preconditionContainer = new GlobalPreconditionContainer();
    private String physicalFilePath;
    private String logicalFilePath;
    private String changeLogId;
    private ObjectQuotingStrategy objectQuotingStrategy;
    private List<ChangeSet> changeSets = new ArrayList<ChangeSet>();
    private ChangeLogParameters changeLogParameters;
    private RuntimeEnvironment runtimeEnvironment;
    private DatabaseChangeLog rootChangeLog = ROOT_CHANGE_LOG.get();
    private DatabaseChangeLog parentChangeLog = PARENT_CHANGE_LOG.get();
    private ContextExpression contexts;
    private ContextExpression includeContexts;
    private LabelExpression includeLabels;
    private boolean includeIgnore;

    public DatabaseChangeLog() {
    }

    public DatabaseChangeLog(String physicalFilePath) {
        this.physicalFilePath = physicalFilePath;
    }

    public void setRootChangeLog(DatabaseChangeLog rootChangeLog) {
        this.rootChangeLog = rootChangeLog;
    }

    public DatabaseChangeLog getRootChangeLog() {
        return this.rootChangeLog != null ? this.rootChangeLog : this;
    }

    public void setParentChangeLog(DatabaseChangeLog parentChangeLog) {
        this.parentChangeLog = parentChangeLog;
    }

    public DatabaseChangeLog getParentChangeLog() {
        return this.parentChangeLog;
    }

    public RuntimeEnvironment getRuntimeEnvironment() {
        return this.runtimeEnvironment;
    }

    public void setRuntimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
        this.runtimeEnvironment = runtimeEnvironment;
    }

    @Override
    public PreconditionContainer getPreconditions() {
        return this.preconditionContainer;
    }

    @Override
    public void setPreconditions(PreconditionContainer precond) {
        this.preconditionContainer.addNestedPrecondition(precond);
    }

    public ChangeLogParameters getChangeLogParameters() {
        return this.changeLogParameters;
    }

    public void setChangeLogParameters(ChangeLogParameters changeLogParameters) {
        this.changeLogParameters = changeLogParameters;
    }

    public String getPhysicalFilePath() {
        return this.physicalFilePath;
    }

    public void setPhysicalFilePath(String physicalFilePath) {
        this.physicalFilePath = physicalFilePath;
    }

    public String getChangeLogId() {
        return this.changeLogId;
    }

    public void setChangeLogId(String changeLogId) {
        this.changeLogId = changeLogId;
    }

    public String getLogicalFilePath() {
        String returnPath = this.logicalFilePath;
        if (this.logicalFilePath == null) {
            returnPath = this.physicalFilePath;
        }
        return returnPath.replaceAll("\\\\", "/").replaceFirst("^/", "");
    }

    public void setLogicalFilePath(String logicalFilePath) {
        this.logicalFilePath = logicalFilePath;
    }

    public String getFilePath() {
        if (this.logicalFilePath == null) {
            return this.physicalFilePath;
        }
        return this.getLogicalFilePath();
    }

    public ObjectQuotingStrategy getObjectQuotingStrategy() {
        return this.objectQuotingStrategy;
    }

    public void setObjectQuotingStrategy(ObjectQuotingStrategy objectQuotingStrategy) {
        this.objectQuotingStrategy = objectQuotingStrategy;
    }

    public ContextExpression getContexts() {
        return this.contexts;
    }

    public void setContexts(ContextExpression contexts) {
        this.contexts = contexts;
    }

    public ContextExpression getIncludeContexts() {
        return this.includeContexts;
    }

    public void setIncludeLabels(LabelExpression labels) {
        this.includeLabels = labels;
    }

    public LabelExpression getIncludeLabels() {
        return this.includeLabels;
    }

    public void setIncludeIgnore(boolean ignore) {
        this.includeIgnore = ignore;
    }

    public boolean isIncludeIgnore() {
        return this.includeIgnore;
    }

    public void setIncludeContexts(ContextExpression includeContexts) {
        this.includeContexts = includeContexts;
    }

    public String toString() {
        return this.getFilePath();
    }

    @Override
    public int compareTo(DatabaseChangeLog o2) {
        return this.getFilePath().compareTo(o2.getFilePath());
    }

    public ChangeSet getChangeSet(String path, String author, String id2) {
        for (ChangeSet changeSet : this.changeSets) {
            String normalizedPath = DatabaseChangeLog.normalizePath(changeSet.getFilePath());
            if (normalizedPath == null || !normalizedPath.equalsIgnoreCase(DatabaseChangeLog.normalizePath(path)) || !changeSet.getAuthor().equalsIgnoreCase(author) || !changeSet.getId().equalsIgnoreCase(id2) || !this.isDbmsMatch(changeSet.getDbmsSet())) continue;
            return changeSet;
        }
        return null;
    }

    public List<ChangeSet> getChangeSets() {
        return this.changeSets;
    }

    public void addChangeSet(ChangeSet changeSet) {
        if (changeSet.getRunOrder() == null) {
            ListIterator<ChangeSet> it2 = this.changeSets.listIterator(this.changeSets.size());
            boolean added = false;
            while (it2.hasPrevious() && !added) {
                if ("last".equals(it2.previous().getRunOrder())) continue;
                it2.next();
                it2.add(changeSet);
                added = true;
            }
            if (!added) {
                it2.add(changeSet);
            }
        } else if ("first".equals(changeSet.getRunOrder())) {
            ListIterator<ChangeSet> it3 = this.changeSets.listIterator();
            boolean added = false;
            while (it3.hasNext() && !added) {
                if ("first".equals(it3.next().getRunOrder())) continue;
                it3.previous();
                it3.add(changeSet);
                added = true;
            }
            if (!added) {
                this.changeSets.add(changeSet);
            }
        } else if ("last".equals(changeSet.getRunOrder())) {
            this.changeSets.add(changeSet);
        } else {
            throw new UnexpectedLiquibaseException("Unknown runOrder: " + changeSet.getRunOrder());
        }
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DatabaseChangeLog that = (DatabaseChangeLog)o2;
        return this.getFilePath().equals(that.getFilePath());
    }

    public int hashCode() {
        return this.getFilePath().hashCode();
    }

    public void validate(Database database, String ... contexts) throws LiquibaseException {
        this.validate(database, new Contexts(contexts), new LabelExpression());
    }

    public void validate(Database database, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        database.setObjectQuotingStrategy(this.objectQuotingStrategy);
        ChangeLogIterator logIterator = new ChangeLogIterator(this, new DbmsChangeSetFilter(database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression));
        ValidatingVisitor validatingVisitor = new ValidatingVisitor(database.getRanChangeSetList());
        validatingVisitor.validate(database, this);
        logIterator.run(validatingVisitor, new RuntimeEnvironment(database, contexts, labelExpression));
        for (String message : validatingVisitor.getWarnings().getMessages()) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(message);
        }
        if (!validatingVisitor.validationPassed()) {
            throw new ValidationFailedException(validatingVisitor);
        }
    }

    public ChangeSet getChangeSet(RanChangeSet ranChangeSet) {
        ChangeSet changeSet = this.getChangeSet(ranChangeSet.getChangeLog(), ranChangeSet.getAuthor(), ranChangeSet.getId());
        if (changeSet != null) {
            changeSet.setStoredFilePath(ranChangeSet.getStoredChangeLog());
        }
        return changeSet;
    }

    public void load(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException, SetupException {
        this.setChangeLogId(parsedNode.getChildValue((String)null, "changeLogId", String.class));
        this.setLogicalFilePath(parsedNode.getChildValue((String)null, "logicalFilePath", String.class));
        this.setContexts(new ContextExpression(parsedNode.getChildValue((String)null, "context", String.class)));
        String objectQuotingStrategy = parsedNode.getChildValue((String)null, "objectQuotingStrategy", String.class);
        if (objectQuotingStrategy != null) {
            this.setObjectQuotingStrategy(ObjectQuotingStrategy.valueOf(objectQuotingStrategy));
        }
        for (ParsedNode childNode : parsedNode.getChildren()) {
            this.handleChildNode(childNode, resourceAccessor);
        }
    }

    protected void expandExpressions(ParsedNode parsedNode) {
        if (this.changeLogParameters == null) {
            return;
        }
        try {
            List<ParsedNode> children;
            Object value = parsedNode.getValue();
            if (value != null && value instanceof String) {
                parsedNode.setValue(this.changeLogParameters.expandExpressions(parsedNode.getValue(String.class), this));
            }
            if ((children = parsedNode.getChildren()) != null) {
                for (ParsedNode child : children) {
                    this.expandExpressions(child);
                }
            }
        }
        catch (ParsedNodeException e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void handleChildNode(ParsedNode node, ResourceAccessor resourceAccessor) throws ParsedNodeException, SetupException {
        this.expandExpressions(node);
        var4_4 = nodeName = node.getName();
        var5_5 = -1;
        switch (var4_4.hashCode()) {
            case 1455248018: {
                if (!var4_4.equals("changeSet")) break;
                var5_5 = 0;
                break;
            }
            case 1942574248: {
                if (!var4_4.equals("include")) break;
                var5_5 = 1;
                break;
            }
            case 840141785: {
                if (!var4_4.equals("includeAll")) break;
                var5_5 = 2;
                break;
            }
            case -1006692933: {
                if (!var4_4.equals("preConditions")) break;
                var5_5 = 3;
                break;
            }
            case -993141291: {
                if (!var4_4.equals("property")) break;
                var5_5 = 4;
            }
        }
        switch (var5_5) {
            case 0: {
                if (!this.isDbmsMatch(node.getChildValue((String)null, "dbms", String.class))) break;
                this.addChangeSet(this.createChangeSet(node, resourceAccessor));
                break;
            }
            case 1: {
                path = node.getChildValue((String)null, "file", String.class);
                if (path == null) {
                    throw new UnexpectedLiquibaseException("No 'file' attribute on 'include'");
                }
                path = path.replace('\\', '/');
                includeContexts = new ContextExpression(node.getChildValue((String)null, "context", String.class));
                labelExpression = new LabelExpression(node.getChildValue((String)null, "labels", String.class));
                ignore = node.getChildValue((String)null, "ignore", Boolean.class);
                try {
                    this.include(path, node.getChildValue(null, "relativeToChangelogFile", false), resourceAccessor, includeContexts, labelExpression, ignore, true);
                    break;
                }
                catch (LiquibaseException e) {
                    throw new SetupException(e);
                }
            }
            case 2: {
                path = node.getChildValue((String)null, "path", String.class);
                resourceFilterDef = node.getChildValue((String)null, "filter", String.class);
                if (resourceFilterDef == null) {
                    resourceFilterDef = node.getChildValue((String)null, "resourceFilter", String.class);
                }
                resourceFilter = null;
                if (resourceFilterDef != null) {
                    try {
                        resourceFilter = (IncludeAllFilter)Class.forName(resourceFilterDef).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new SetupException(e);
                    }
                }
                resourceComparatorDef = node.getChildValue((String)null, "resourceComparator", String.class);
                resourceComparator = null;
                if (resourceComparatorDef != null) {
                    try {
                        resourceComparator = (Comparator<String>)Class.forName(resourceComparatorDef).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ReflectiveOperationException e) {
                        Scope.getCurrentScope().getLog(this.getClass()).info("no resourceComparator defined - taking default implementation");
                        resourceComparator = this.getStandardChangeLogComparator();
                    }
                }
                includeContexts = new ContextExpression(node.getChildValue((String)null, "context", String.class));
                labelExpression = new LabelExpression(node.getChildValue((String)null, "labels", String.class));
                ignore = node.getChildValue((String)null, "ignore", Boolean.class);
                if (ignore == null) {
                    ignore = false;
                }
                this.includeAll(path, node.getChildValue(null, "relativeToChangelogFile", false), resourceFilter, node.getChildValue(null, "errorIfMissingOrEmpty", true), resourceComparator, resourceAccessor, includeContexts, labelExpression, ignore);
                break;
            }
            case 3: {
                parsedContainer = new PreconditionContainer();
                try {
                    parsedContainer.load(node, resourceAccessor);
                    this.preconditionContainer.addNestedPrecondition(parsedContainer);
                }
                catch (ParsedNodeException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                try {
                    context = node.getChildValue((String)null, "context", String.class);
                    dbms = node.getChildValue((String)null, "dbms", String.class);
                    labels = node.getChildValue((String)null, "labels", String.class);
                    global = node.getChildValue((String)null, "global", Boolean.class);
                    if (global == null) {
                        global = true;
                    }
                    if ((file = node.getChildValue((String)null, "file", String.class)) == null) {
                        name = node.getChildValue((String)null, "name", String.class);
                        value = node.getChildValue((String)null, "value", String.class);
                        this.changeLogParameters.set(name, value, context, labels, dbms, (boolean)global, this);
                        ** break;
                    }
                    props = new Properties();
                    propertiesStream = resourceAccessor.openStream(null, file);
                    var13_33 = null;
                    if (propertiesStream != null) {
                        props.load(propertiesStream);
                        for (Map.Entry<Object, Object> entry : props.entrySet()) {
                            this.changeLogParameters.set(entry.getKey().toString(), entry.getValue().toString(), context, labels, dbms, (boolean)global, this);
                        }
                    } else {
                        Scope.getCurrentScope().getLog(this.getClass()).info("Could not open properties file " + file);
                    }
                    if (propertiesStream == null) break;
                    if (var13_33 == null) ** GOTO lbl112
                    try {
                        propertiesStream.close();
                    }
                    catch (Throwable var14_35) {
                        var13_33.addSuppressed(var14_35);
                    }
                    break;
lbl112:
                    // 1 sources

                    propertiesStream.close();
                    ** break;
                    catch (Throwable var14_36) {
                        try {
                            var13_33 = var14_36;
                            throw var14_36;
                        }
                        catch (Throwable var16_38) {
                            if (propertiesStream != null) {
                                if (var13_33 != null) {
                                    try {
                                        propertiesStream.close();
                                    }
                                    catch (Throwable var17_39) {
                                        var13_33.addSuppressed(var17_39);
                                    }
                                } else {
                                    propertiesStream.close();
                                }
                            }
                            throw var16_38;
lbl129:
                            // 2 sources

                            break;
                        }
                    }
                }
                catch (IOException e) {
                    throw new ParsedNodeException(e);
                }
            }
            default: {
                if (node.getChildren() == null || node.getChildren().isEmpty()) break;
                throw new ParsedNodeException("Unexpected node found under databaseChangeLog: " + nodeName);
            }
        }
    }

    public boolean isDbmsMatch(String dbmsList) {
        return this.isDbmsMatch(DatabaseList.toDbmsSet(dbmsList));
    }

    public boolean isDbmsMatch(Set<String> dbmsSet) {
        return dbmsSet == null || this.changeLogParameters == null || this.changeLogParameters.getValue("database.typeName", this) == null || DatabaseList.definitionMatches(dbmsSet, this.changeLogParameters.getValue("database.typeName", this).toString(), true);
    }

    public void includeAll(String pathName, boolean isRelativeToChangelogFile, IncludeAllFilter resourceFilter, boolean errorIfMissingOrEmpty, Comparator<String> resourceComparator, ResourceAccessor resourceAccessor, ContextExpression includeContexts, LabelExpression labelExpression, boolean ignore) throws SetupException {
        try {
            SortedSet<String> unsortedResources;
            block11: {
                if (pathName == null) {
                    throw new SetupException("No path attribute for includeAll");
                }
                if (StringUtil.isNotEmpty(pathName = pathName.replace('\\', '/')) && !pathName.endsWith("/")) {
                    pathName = pathName + '/';
                }
                LOG.fine("includeAll for " + pathName);
                LOG.fine("Using file opener for includeAll: " + resourceAccessor.toString());
                String relativeTo = null;
                if (isRelativeToChangelogFile) {
                    relativeTo = this.getPhysicalFilePath();
                }
                unsortedResources = null;
                try {
                    unsortedResources = resourceAccessor.list(relativeTo, pathName, true, true, false);
                }
                catch (IOException e2) {
                    if (!errorIfMissingOrEmpty) break block11;
                    throw e2;
                }
            }
            TreeSet<String> resources = new TreeSet<String>(resourceComparator);
            if (unsortedResources != null) {
                for (String resourcePath : unsortedResources) {
                    if (resourceFilter != null && !resourceFilter.include(resourcePath)) continue;
                    resources.add(resourcePath);
                }
            }
            if (resources.isEmpty() && errorIfMissingOrEmpty) {
                throw new SetupException("Could not find directory or directory was empty for includeAll '" + pathName + "'");
            }
            for (String path : resources) {
                Scope.getCurrentScope().getLog(this.getClass()).info("Reading resource: " + path);
                this.include(path, false, resourceAccessor, includeContexts, labelExpression, ignore, false);
            }
        }
        catch (Exception e3) {
            throw new SetupException(e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean include(String fileName, boolean isRelativePath, ResourceAccessor resourceAccessor, ContextExpression includeContexts, LabelExpression labelExpression, Boolean ignore, boolean logEveryUnknownFileFormat) throws LiquibaseException {
        DatabaseChangeLog changeLog;
        if (".svn".equalsIgnoreCase(fileName) || "cvs".equalsIgnoreCase(fileName)) {
            return false;
        }
        String relativeBaseFileName = this.getPhysicalFilePath();
        if (isRelativePath) {
            relativeBaseFileName = relativeBaseFileName.replaceFirst("classpath:", "");
            fileName = FilenameUtil.concat(FilenameUtil.getDirectory(relativeBaseFileName), fileName);
        }
        fileName = fileName.replaceFirst("classpath:", "");
        try {
            DatabaseChangeLog rootChangeLog = ROOT_CHANGE_LOG.get();
            if (rootChangeLog == null) {
                ROOT_CHANGE_LOG.set(this);
            }
            DatabaseChangeLog parentChangeLog = PARENT_CHANGE_LOG.get();
            PARENT_CHANGE_LOG.set(this);
            try {
                ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser(fileName, resourceAccessor);
                changeLog = parser.parse(fileName, this.changeLogParameters, resourceAccessor);
                changeLog.setIncludeContexts(includeContexts);
                changeLog.setIncludeLabels(labelExpression);
                changeLog.setIncludeIgnore(ignore != null ? ignore : false);
            }
            finally {
                if (rootChangeLog == null) {
                    ROOT_CHANGE_LOG.remove();
                }
                if (parentChangeLog == null) {
                    PARENT_CHANGE_LOG.remove();
                } else {
                    PARENT_CHANGE_LOG.set(parentChangeLog);
                }
            }
        }
        catch (UnknownChangelogFormatException e2) {
            boolean matchesFileExtension = StringUtil.trimToEmpty(fileName).matches("\\.\\w+$");
            if (matchesFileExtension || logEveryUnknownFileFormat) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("included file " + relativeBaseFileName + "/" + fileName + " is not a recognized file type");
            }
            return false;
        }
        PreconditionContainer preconditions = changeLog.getPreconditions();
        if (preconditions != null) {
            if (null == this.getPreconditions()) {
                this.setPreconditions(new PreconditionContainer());
            }
            this.getPreconditions().addNestedPrecondition(preconditions);
        }
        for (ChangeSet changeSet : changeLog.getChangeSets()) {
            this.addChangeSet(changeSet);
        }
        return true;
    }

    protected ChangeSet createChangeSet(ParsedNode node, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        ChangeSet changeSet = new ChangeSet(this);
        changeSet.setChangeLogParameters(this.getChangeLogParameters());
        changeSet.load(node, resourceAccessor);
        return changeSet;
    }

    protected Comparator<String> getStandardChangeLogComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.replace("WEB-INF/classes/", "").compareTo(o2.replace("WEB-INF/classes/", ""));
            }
        };
    }

    public static String normalizePath(String filePath) {
        if (filePath == null) {
            return null;
        }
        return filePath.replaceFirst("^classpath:", "").replaceAll("\\\\", "/").replaceAll("//+", "/").replaceFirst("^[a-zA-Z]:", "").replaceFirst("^/", "");
    }

    public void clearCheckSums() {
        for (ChangeSet changeSet : this.getChangeSets()) {
            changeSet.clearCheckSum();
        }
    }

    @LiquibaseService(skip=true)
    private static class GlobalPreconditionContainer
    extends PreconditionContainer {
        private GlobalPreconditionContainer() {
        }

        @Override
        public PreconditionContainer.OnSqlOutputOption getOnSqlOutput() {
            return PreconditionContainer.OnSqlOutputOption.TEST;
        }

        @Override
        public void addNestedPrecondition(Precondition precondition) {
            super.addNestedPrecondition(precondition);
        }
    }
}

