/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import org.exoplatform.web.application.CompoundApplicationMessage;
import org.exoplatform.webui.form.validator.NumberFormatValidator;

public class NumberRangeValidator
extends NumberFormatValidator {
    private int min;
    private int max;

    public NumberRangeValidator(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    protected String getMessageLocalizationKey() {
        return "NumberRangeValidator.msg.Invalid-number";
    }

    @Override
    protected Integer validateInteger(String value, String label, CompoundApplicationMessage messages) {
        Integer integer = super.validateInteger(value, label, messages);
        if (integer == null) {
            return null;
        }
        if (integer < this.min || integer > this.max) {
            messages.addMessage(this.getMessageLocalizationKey(), new Object[]{label, this.min, this.max});
            return null;
        }
        return integer;
    }
}

