/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search.listener;

import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;

public class ProfileESListenerImpl
extends ProfileListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(ProfileESListenerImpl.class);

    public void headerSectionUpdated(ProfileLifeCycleEvent event) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getProfile().getIdentity().getId();
        LOG.debug("Notifying indexing service for profile header information update id={}", new Object[]{id});
        indexingService.reindex("profile", id);
    }

    public void avatarUpdated(ProfileLifeCycleEvent event) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getProfile().getIdentity().getId();
        LOG.debug("Notifying indexing service for profile avatar update id={}", new Object[]{id});
        indexingService.reindex("profile", id);
    }

    public void bannerUpdated(ProfileLifeCycleEvent event) {
        LOG.debug("Profile banner of user {} has been updated", new Object[]{event.getProfile().getIdentity().getId()});
    }

    public void basicInfoUpdated(ProfileLifeCycleEvent event) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getProfile().getIdentity().getId();
        LOG.debug("Notifying indexing service for the basic information update id={}", new Object[]{id});
        indexingService.reindex("profile", id);
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getProfile().getIdentity().getId();
        LOG.debug("Notifying indexing service for the profile contact update id={}", new Object[]{id});
        indexingService.reindex("profile", id);
    }

    public void aboutMeUpdated(ProfileLifeCycleEvent event) {
        String id = event.getProfile().getIdentity().getId();
        LOG.debug("Notifying indexing service for the profile aboutme update id={}", new Object[]{id});
        ((IndexingService)CommonsUtils.getService(IndexingService.class)).reindex("profile", id);
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
        String id = event.getProfile().getIdentity().getId();
        LOG.debug("Notifying indexing service for the profile experience update id={}", new Object[]{id});
        ((IndexingService)CommonsUtils.getService(IndexingService.class)).reindex("profile", id);
    }

    public void createProfile(ProfileLifeCycleEvent event) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getProfile().getIdentity().getId();
        LOG.debug("Notifying indexing service for the profile creation id={}", new Object[]{id});
        indexingService.index("profile", id);
    }

    public void technicalUpdated(ProfileLifeCycleEvent event) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getProfile().getIdentity().getId();
        LOG.debug("Notifying indexing service for the profile update id={}, technical property changed", new Object[]{id});
        indexingService.reindex("profile", id);
    }
}

