/*
 * Decompiled with CFR 0.152.
 */
package liquibase.hub.core;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.exception.LiquibaseException;
import liquibase.hub.HubConfiguration;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.LiquibaseHubObjectNotFoundException;
import liquibase.hub.LiquibaseHubSecurityException;
import liquibase.hub.LiquibaseHubUserException;
import liquibase.hub.core.HttpClient;
import liquibase.hub.model.Connection;
import liquibase.hub.model.HubChange;
import liquibase.hub.model.HubChangeLog;
import liquibase.hub.model.HubLink;
import liquibase.hub.model.HubModel;
import liquibase.hub.model.HubRegister;
import liquibase.hub.model.HubRegisterResponse;
import liquibase.hub.model.HubUser;
import liquibase.hub.model.ListResponse;
import liquibase.hub.model.Operation;
import liquibase.hub.model.OperationChange;
import liquibase.hub.model.OperationChangeEvent;
import liquibase.hub.model.OperationEvent;
import liquibase.hub.model.Organization;
import liquibase.hub.model.Project;
import liquibase.integration.IntegrationDetails;
import liquibase.logging.Logger;
import liquibase.util.ISODateFormat;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtil;

public class StandardHubService
implements HubService {
    private static final String DATE_TIME_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private Boolean available;
    private UUID organizationId;
    private String organizationName;
    private UUID userId;
    private Map<UUID, HubChangeLog> hubChangeLogCache = new HashMap<UUID, HubChangeLog>();
    private HttpClient http = this.createHttpClient();

    public HttpClient createHttpClient() {
        return new HttpClient();
    }

    @Override
    public int getPriority() {
        return 101;
    }

    @Override
    public boolean isOnline() {
        return HubConfiguration.LIQUIBASE_HUB_MODE.getCurrentValue() != HubConfiguration.HubMode.OFF;
    }

    public boolean isHubAvailable() {
        if (this.available == null) {
            Logger log = Scope.getCurrentScope().getLog(this.getClass());
            HubServiceFactory hubServiceFactory = Scope.getCurrentScope().getSingleton(HubServiceFactory.class);
            if (HubConfiguration.LIQUIBASE_HUB_MODE.getCurrentValue() == HubConfiguration.HubMode.OFF) {
                hubServiceFactory.setOfflineReason("property liquibase.hub.mode is 'OFF'. To send data to Liquibase Hub, please set it to \"all\"");
                this.available = false;
            } else if (this.getApiKey() == null) {
                hubServiceFactory.setOfflineReason("liquibase.hub.apiKey was not specified");
                this.available = false;
            } else {
                try {
                    if (this.userId == null) {
                        HubUser me2 = this.getMe();
                        this.userId = me2.getId();
                    }
                    if (this.organizationId == null) {
                        Organization organization = this.getOrganization();
                        this.organizationId = organization.getId();
                    }
                    log.info("Connected to Liquibase Hub with an API Key '" + HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValueObfuscated() + "'");
                    this.available = true;
                }
                catch (LiquibaseHubException e2) {
                    if (e2.getCause() instanceof ConnectException) {
                        hubServiceFactory.setOfflineReason("Cannot connect to Liquibase Hub");
                    } else {
                        hubServiceFactory.setOfflineReason(e2.getMessage());
                    }
                    log.info(e2.getMessage(), e2);
                    this.available = false;
                }
            }
            String apiKey = this.getApiKey();
            if (!this.available.booleanValue() && apiKey != null) {
                String message = "Hub communication failure: " + hubServiceFactory.getOfflineReason() + ".\nThe data for your operations will not be recorded in your Liquibase Hub project";
                Scope.getCurrentScope().getUI().sendMessage(message);
                log.info(message);
            }
        }
        return this.available;
    }

    public String getApiKey() {
        return StringUtil.trimToNull(HubConfiguration.LIQUIBASE_HUB_API_KEY.getCurrentValue());
    }

    @Override
    public HubUser getMe() throws LiquibaseHubException {
        Map response;
        try {
            response = this.http.doGet("/api/v1/users/me", Map.class);
        }
        catch (LiquibaseHubSecurityException e2) {
            throw new LiquibaseHubSecurityException("Invalid Liquibase Hub api key", e2);
        }
        HubUser user = new HubUser();
        user.setId(UUID.fromString((String)response.get("id")));
        user.setUsername((String)response.get("userName"));
        return user;
    }

    @Override
    public Organization getOrganization() throws LiquibaseHubException {
        if (this.organizationId == null) {
            Map response = this.http.doGet("/api/v1/organizations", Map.class);
            List contentList = (List)response.get("content");
            String id2 = (String)((Map)contentList.get(0)).get("id");
            if (id2 != null) {
                this.organizationId = UUID.fromString(id2);
            }
            this.organizationName = (String)((Map)contentList.get(0)).get("name");
        }
        Organization org = new Organization();
        org.setId(this.organizationId);
        org.setName(this.organizationName);
        return org;
    }

    @Override
    public Project getProject(UUID projectId) throws LiquibaseHubException {
        UUID organizationId = this.getOrganization().getId();
        try {
            return this.http.doGet("/api/v1/organizations/" + organizationId.toString() + "/projects/" + projectId, Project.class);
        }
        catch (LiquibaseHubObjectNotFoundException lbe) {
            Scope.getCurrentScope().getLog(this.getClass()).severe(lbe.getMessage(), lbe);
            return null;
        }
    }

    @Override
    public Project findProjectByConnectionIdOrJdbcUrl(UUID connectionId, String jdbcUrl) throws LiquibaseHubException {
        AtomicReference<UUID> organizationId = new AtomicReference<UUID>(this.getOrganization().getId());
        String searchParam = null;
        if (connectionId != null) {
            searchParam = "connections.id:\"" + connectionId.toString() + "\"";
        } else if (jdbcUrl != null) {
            searchParam = "connections.jdbcUrl:\"" + jdbcUrl + "\"";
        } else {
            throw new LiquibaseHubException("connectionId or jdbcUrl should be specified");
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("search", searchParam);
        Map response = this.http.doGet("/api/v1/organizations/" + organizationId.toString() + "/projects", parameters, Map.class);
        List<Project> returnList = this.transformProjectResponseToList(response);
        if (returnList.size() > 1) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(String.format("JDBC URL: %s was associated with multiple projects.", jdbcUrl));
            return null;
        }
        if (returnList.isEmpty()) {
            return null;
        }
        return returnList.get(0);
    }

    private List<Project> transformProjectResponseToList(Map<String, List<Map>> response) {
        List<Map> contentList = response.get("content");
        ArrayList<Project> returnList = new ArrayList<Project>();
        for (int i2 = 0; i2 < contentList.size(); ++i2) {
            String id2 = (String)contentList.get(i2).get("id");
            String name = (String)contentList.get(i2).get("name");
            String dateString = (String)contentList.get(i2).get("createDate");
            Date date = null;
            try {
                date = this.parseDate(dateString);
            }
            catch (ParseException dpe) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("Project '" + name + "' has an invalid create date of '" + dateString + "'");
            }
            Project project = new Project();
            project.setId(UUID.fromString(id2));
            project.setName(name);
            project.setCreateDate(date);
            returnList.add(project);
        }
        return returnList;
    }

    private String encodeValue(String value) throws LiquibaseHubException {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e2) {
            throw new LiquibaseHubException(e2);
        }
    }

    @Override
    public List<Project> getProjects() throws LiquibaseHubException {
        AtomicReference<UUID> organizationId = new AtomicReference<UUID>(this.getOrganization().getId());
        Map response = this.http.doGet("/api/v1/organizations/" + organizationId.toString() + "/projects", Map.class);
        return this.transformProjectResponseToList(response);
    }

    @Override
    public HubRegisterResponse register(String email) throws LiquibaseException {
        HubRegister hubRegister = new HubRegister();
        hubRegister.setEmail(email);
        try {
            HubRegisterResponse response = this.http.doPost("/api/v1/register", hubRegister, HubRegisterResponse.class);
            if (response.getApiKey() != null) {
                return response;
            }
        }
        catch (LiquibaseHubException e2) {
            throw new LiquibaseException(e2.getMessage(), e2);
        }
        return null;
    }

    @Override
    public Project createProject(Project project) throws LiquibaseException {
        UUID organizationId = this.getOrganization().getId();
        return this.http.doPost("/api/v1/organizations/" + organizationId.toString() + "/projects", project, Project.class);
    }

    @Override
    public HubChangeLog createChangeLog(HubChangeLog hubChangeLog) throws LiquibaseException {
        UUID organizationId = this.getOrganization().getId();
        return this.http.doPost("/api/v1/organizations/" + organizationId.toString() + "/projects/" + hubChangeLog.getProject().getId() + "/changelogs", hubChangeLog, HubChangeLog.class);
    }

    @Override
    public HubChangeLog deactivateChangeLog(HubChangeLog hubChangeLog) throws LiquibaseHubException {
        return this.http.doPut("/api/v1/organizations/" + this.getOrganization().getId() + "/projects/" + hubChangeLog.getProject().getId().toString() + "/changelogs/" + hubChangeLog.getId().toString(), hubChangeLog, HubChangeLog.class);
    }

    @Override
    public void setRanChangeSets(Connection connection, List<RanChangeSet> ranChangeSets) throws LiquibaseHubException {
        ArrayList<HubChange> hubChangeList = new ArrayList<HubChange>();
        for (RanChangeSet ranChangeSet : ranChangeSets) {
            hubChangeList.add(new HubChange(ranChangeSet));
        }
        this.http.doPut("/api/v1/organizations/" + this.getOrganization().getId() + "/connections/" + connection.getId() + "/changes", hubChangeList, ArrayList.class);
    }

    @Override
    public Connection getConnection(Connection exampleConnection, boolean createIfNotExists) throws LiquibaseHubException {
        List<Connection> connections;
        if (exampleConnection.getId() != null) {
            return this.http.doGet("/api/v1/connections/" + exampleConnection.getId().toString(), null, Connection.class);
        }
        try {
            connections = this.getConnections(exampleConnection);
        }
        catch (LiquibaseHubObjectNotFoundException e2) {
            if (createIfNotExists) {
                return this.createConnection(exampleConnection);
            }
            throw new LiquibaseHubObjectNotFoundException("Connection not found");
        }
        if (connections.size() == 0) {
            if (createIfNotExists) {
                return this.createConnection(exampleConnection);
            }
            throw new LiquibaseHubObjectNotFoundException("Connection not found");
        }
        if (connections.size() == 1) {
            return connections.get(0);
        }
        throw new LiquibaseHubException("The url " + exampleConnection.getJdbcUrl() + " is used by more than one connection. Please specify 'hubConnectionId=<hubConnectionId>' or 'changeLogFile=<changeLogFileName>' in liquibase.properties or the command line");
    }

    @Override
    public List<Connection> getConnections(Connection exampleConnection) throws LiquibaseHubException {
        ListResponse response;
        Organization organization = this.getOrganization();
        try {
            response = this.http.doGet("/api/v1/organizations/" + organization.getId() + "/connections", Collections.singletonMap("search", this.toSearchString(exampleConnection)), ListResponse.class, Connection.class);
        }
        catch (LiquibaseHubObjectNotFoundException e2) {
            return new ArrayList<Connection>();
        }
        ArrayList<Connection> returnList = new ArrayList<Connection>();
        try {
            for (Map object : response.getContent()) {
                returnList.add(new Connection().setId(UUID.fromString((String)object.get("id"))).setJdbcUrl((String)object.get("jdbcUrl")).setName((String)object.get("name")).setDescription((String)object.get("description")).setCreateDate(this.parseDate((String)object.get("createDate"))).setUpdateDate(this.parseDate((String)object.get("updateDate"))).setRemoveDate(this.parseDate((String)object.get("removeDate"))).setProject(exampleConnection != null ? exampleConnection.getProject() : null));
            }
        }
        catch (ParseException e3) {
            throw new LiquibaseHubException(e3);
        }
        return returnList;
    }

    protected Date parseDate(String stringDate) throws ParseException {
        if (stringDate == null) {
            return null;
        }
        return new ISODateFormat().parse(stringDate);
    }

    @Override
    public Connection createConnection(Connection connection) throws LiquibaseHubException {
        if (connection.getProject() == null || connection.getProject().getId() == null) {
            throw new LiquibaseHubUserException("projectId is required to create a connection");
        }
        Connection sendConnection = new Connection().setName(connection.getName()).setJdbcUrl(connection.getJdbcUrl()).setDescription(connection.getDescription());
        if (sendConnection.getName() == null) {
            sendConnection.setName(sendConnection.getJdbcUrl());
        }
        return this.http.doPost("/api/v1/organizations/" + this.getOrganization().getId() + "/projects/" + connection.getProject().getId() + "/connections", sendConnection, Connection.class);
    }

    @Override
    public String shortenLink(String url) throws LiquibaseException {
        HubLinkRequest reportHubLink = new HubLinkRequest();
        reportHubLink.url = url;
        return this.http.getHubUrl() + this.http.doPut("/api/v1/links", reportHubLink, HubLink.class).getShortUrl();
    }

    @Override
    public HubChangeLog getHubChangeLog(UUID changeLogId) throws LiquibaseHubException {
        return this.getHubChangeLog(changeLogId, null);
    }

    @Override
    public HubChangeLog getHubChangeLog(UUID changeLogId, String includeStatus) {
        if (includeStatus == null && this.hubChangeLogCache.containsKey(changeLogId)) {
            return this.hubChangeLogCache.get(changeLogId);
        }
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (includeStatus != null) {
                parameters.put("includeStatus", includeStatus);
            }
            HubChangeLog hubChangeLog = this.http.doGet("/api/v1/changelogs/" + changeLogId, parameters, HubChangeLog.class);
            this.hubChangeLogCache.put(changeLogId, hubChangeLog);
            return hubChangeLog;
        }
        catch (LiquibaseHubException lbe) {
            String message = lbe.getMessage();
            String uiMessage = "Retrieving Hub Change Log failed for Changelog ID " + changeLogId.toString();
            Scope.getCurrentScope().getUI().sendMessage(uiMessage + ": " + message);
            Scope.getCurrentScope().getLog(this.getClass()).warning(message, lbe);
            return null;
        }
    }

    @Override
    public Operation createOperation(String operationType, String operationCommand, HubChangeLog changeLog, Connection connection) throws LiquibaseHubException {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable e2) {
            Scope.getCurrentScope().getLog(this.getClass()).severe("Cannot determine hostname to send to hub", e2);
            hostName = null;
        }
        IntegrationDetails integrationDetails = (IntegrationDetails)((Object)Scope.getCurrentScope().get("integrationDetails", IntegrationDetails.class));
        HashMap<String, String> clientMetadata = new HashMap<String, String>();
        clientMetadata.put("liquibaseVersion", LiquibaseUtil.getBuildVersion());
        clientMetadata.put("hostName", hostName);
        clientMetadata.put("systemUser", System.getProperty("user.name"));
        if (integrationDetails != null) {
            clientMetadata.put("clientInterface", integrationDetails.getName());
        }
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("connectionId", connection.getId());
        requestBody.put("connectionJdbcUrl", connection.getJdbcUrl());
        requestBody.put("projectId", connection.getProject() == null ? null : connection.getProject().getId());
        requestBody.put("changelogId", changeLog == null ? null : changeLog.getId());
        requestBody.put("operationType", operationType);
        requestBody.put("operationCommand", operationCommand);
        requestBody.put("operationStatusType", "PASS");
        requestBody.put("statusMessage", operationType);
        requestBody.put("clientMetadata", clientMetadata);
        if (integrationDetails != null) {
            requestBody.put("operationParameters", this.getCleanOperationParameters(integrationDetails.getParameters()));
        }
        Operation operation = this.http.doPost("/api/v1/operations", requestBody, Operation.class);
        operation.setConnection(connection);
        return operation;
    }

    protected Map<String, String> getCleanOperationParameters(Map<String, String> originalParams) {
        if (originalParams == null) {
            return null;
        }
        HashSet<String> paramsToRemove = new HashSet<String>(Arrays.asList("url", "username", "password", "apiKey", "classpath"));
        HashMap<String, String> returnMap = new HashMap<String, String>();
        for (Map.Entry<String, String> param : originalParams.entrySet()) {
            boolean allowed = true;
            for (String skipKey : paramsToRemove) {
                if (!param.getKey().toLowerCase().contains(skipKey.toLowerCase())) continue;
                allowed = false;
                break;
            }
            if (!allowed) continue;
            String value = param.getValue();
            if (param.getKey().toLowerCase().contains("liquibaseProLicenseKey".toLowerCase()) && value != null && value.length() > 8) {
                value = value.substring(0, 8) + "************";
            }
            returnMap.put(param.getKey(), value);
        }
        return returnMap;
    }

    @Override
    public OperationEvent sendOperationEvent(Operation operation, OperationEvent operationEvent) throws LiquibaseException {
        Organization organization = this.getOrganization();
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put("eventType", operationEvent.getEventType());
        requestParams.put("startDate", operationEvent.getStartDate());
        requestParams.put("endDate", operationEvent.getEndDate());
        if (operationEvent.getOperationEventStatus() != null) {
            requestParams.put("statusType", operationEvent.getOperationEventStatus().getOperationEventStatusType());
            requestParams.put("statusMessage", operationEvent.getOperationEventStatus().getStatusMessage());
            requestParams.put("operationEventStatusType", operationEvent.getOperationEventStatus().getOperationEventStatusType());
        }
        if (operationEvent.getOperationEventLog() != null && HubConfiguration.LIQUIBASE_HUB_MODE.getCurrentValue() != HubConfiguration.HubMode.META) {
            requestParams.put("logs", operationEvent.getOperationEventLog().getLogMessage());
            requestParams.put("logsTimestamp", operationEvent.getOperationEventLog().getTimestampLog());
        }
        return this.http.doPost("/api/v1/organizations/" + organization.getId() + "/projects/" + operation.getConnection().getProject().getId() + "/operations/" + operation.getId() + "/operation-events", requestParams, OperationEvent.class);
    }

    private Date convertDateToUTC(Date dateInString) {
        return null;
    }

    @Override
    public void sendOperationChangeEvent(OperationChangeEvent operationChangeEvent) throws LiquibaseException {
        String changesetBody = null;
        String[] generatedSql = null;
        String logs = null;
        Date logsTimestamp = operationChangeEvent.getLogsTimestamp();
        if (HubConfiguration.LIQUIBASE_HUB_MODE.getCurrentValue() != HubConfiguration.HubMode.META) {
            changesetBody = operationChangeEvent.getChangesetBody();
            generatedSql = operationChangeEvent.getGeneratedSql();
            logs = operationChangeEvent.getLogs();
        }
        OperationChangeEvent sendOperationChangeEvent = new OperationChangeEvent().setEventType(operationChangeEvent.getEventType()).setChangesetId(operationChangeEvent.getChangesetId()).setChangesetAuthor(operationChangeEvent.getChangesetAuthor()).setChangesetFilename(operationChangeEvent.getChangesetFilename()).setStartDate(operationChangeEvent.getStartDate()).setEndDate(operationChangeEvent.getEndDate()).setDateExecuted(operationChangeEvent.getDateExecuted()).setOperationStatusType(operationChangeEvent.getOperationStatusType()).setChangesetBody(changesetBody).setGeneratedSql(generatedSql).setLogs(logs).setStatusMessage(operationChangeEvent.getStatusMessage()).setLogsTimestamp(logsTimestamp);
        this.http.doPost("/api/v1/organizations/" + this.getOrganization().getId().toString() + "/projects/" + operationChangeEvent.getProject().getId().toString() + "/operations/" + operationChangeEvent.getOperation().getId().toString() + "/change-events", sendOperationChangeEvent, OperationChangeEvent.class);
    }

    @Override
    public void sendOperationChanges(OperationChange operationChange) throws LiquibaseHubException {
        ArrayList<HubChange> hubChangeList = new ArrayList<HubChange>();
        for (ChangeSet changeSet : operationChange.getChangeSets()) {
            hubChangeList.add(new HubChange(changeSet));
        }
        this.http.doPost("/api/v1/organizations/" + this.getOrganization().getId().toString() + "/projects/" + operationChange.getProject().getId().toString() + "/operations/" + operationChange.getOperation().getId().toString() + "/changes", hubChangeList, ArrayList.class);
    }

    protected String toSearchString(HubModel object) {
        if (object == null) {
            return "";
        }
        TreeSet<String> clauses = new TreeSet<String>();
        this.toSearchString(object, "", clauses);
        return StringUtil.join(clauses, " AND ");
    }

    private void toSearchString(HubModel object, String clausePrefix, SortedSet<String> clauses) {
        Field[] fields;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            try {
                Object value;
                field.setAccessible(true);
                if (field.isSynthetic() || (value = field.get(object)) == null) continue;
                if (value instanceof HubModel) {
                    UUID modelId = ((HubModel)value).getId();
                    if (modelId == null) {
                        String newPrefix = clausePrefix + field.getName() + ".";
                        newPrefix = newPrefix.replaceFirst("^\\.", "");
                        this.toSearchString((HubModel)value, newPrefix, clauses);
                        continue;
                    }
                    clauses.add(clausePrefix + field.getName() + ".id:\"" + modelId + "\"");
                    continue;
                }
                value = value.toString().replace("\"", "\\\"");
                clauses.add(clausePrefix + field.getName() + ":\"" + value + "\"");
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    protected static class HubLinkRequest {
        protected String url;

        protected HubLinkRequest() {
        }
    }
}

