/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.space;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.application.registry.Application;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.deprecation.DeprecatedAPI;
import org.exoplatform.deprecation.DeprecatedAPIAspect;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.model.SpaceExternalInvitation;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceListAccess;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.api.SpaceRestResources;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.BaseEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.SpaceEntity;
import org.exoplatform.social.rest.impl.activity.ActivityRestResourcesV1;
import org.exoplatform.social.rest.impl.space.SpaceRestResourcesV1$AjcClosure1;
import org.exoplatform.social.rest.impl.space.SpaceRestResourcesV1$AjcClosure3;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;

@Path(value="v1/social/spaces")
@Api(tags={"v1/social/spaces"}, value="v1/social/spaces", description="Operations on spaces with their activities and users")
public class SpaceRestResourcesV1
implements SpaceRestResources {
    private static final Log LOG;
    private static final String SPACE_FILTER_TYPE_ALL = "all";
    private static final String SPACE_FILTER_TYPE_MEMBER = "member";
    private static final String SPACE_FILTER_TYPE_MANAGER = "manager";
    private static final String SPACE_FILTER_TYPE_PENDING = "pending";
    private static final String SPACE_FILTER_TYPE_INVITED = "invited";
    private static final String SPACE_FILTER_TYPE_REQUESTS = "requests";
    private static final CacheControl CACHE_CONTROL;
    private static final Date DEFAULT_IMAGES_LAST_MODIFED;
    private static final int CACHE_IN_SECONDS = 604800;
    private static final int CACHE_IN_MILLI_SECONDS = 604800000;
    private ActivityRestResourcesV1 activityRestResourcesV1;
    private IdentityManager identityManager;
    private UploadService uploadService;
    private SpaceService spaceService;
    private byte[] defaultSpaceAvatar = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public SpaceRestResourcesV1(ActivityRestResourcesV1 activityRestResourcesV1, SpaceService spaceService, IdentityManager identityManager, UploadService uploadService) {
        this.activityRestResourcesV1 = activityRestResourcesV1;
        this.spaceService = spaceService;
        this.identityManager = identityManager;
        this.uploadService = uploadService;
        CACHE_CONTROL.setMaxAge(604800);
    }

    @Override
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets spaces of user", httpMethod="GET", response=Response.class, notes="This returns a list of spaces switch request parameters")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getSpaces(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="Space name search information", required=false) @QueryParam(value="q") String q, @ApiParam(value="Type of spaces to retrieve: all, userSpaces, invited, pending or requests", defaultValue="all", required=false) @QueryParam(value="filterType") String filterType, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit, if equals to 0, it will not retrieve spaces", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Sort", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="Order", required=false) @QueryParam(value="order") String order, @ApiParam(value="Returning the number of spaces found or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand) throws Exception {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        int n = limit = limit >= 0 ? limit : RestUtils.getLimit(uriInfo);
        if (StringUtils.isBlank((CharSequence)filterType)) {
            filterType = SPACE_FILTER_TYPE_ALL;
        }
        SpaceListAccess listAccess = null;
        SpaceFilter spaceFilter = new SpaceFilter();
        if (StringUtils.isNotBlank((CharSequence)q)) {
            spaceFilter.setSpaceNameSearchCondition(StringUtils.trim((String)q));
        }
        if (StringUtils.isNotBlank((CharSequence)sort)) {
            Sorting.SortBy sortBy = Sorting.SortBy.valueOf((String)sort.toUpperCase());
            Sorting.OrderBy orderBy = Sorting.OrderBy.ASC;
            if (StringUtils.isNotBlank((CharSequence)order)) {
                orderBy = Sorting.OrderBy.valueOf((String)order.toUpperCase());
            }
            spaceFilter.setSorting(new Sorting(sortBy, orderBy));
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_ALL, (CharSequence)filterType)) {
            listAccess = this.spaceService.getVisibleSpacesWithListAccess(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_MEMBER, (CharSequence)filterType)) {
            listAccess = this.spaceService.getMemberSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_MANAGER, (CharSequence)filterType)) {
            listAccess = this.spaceService.getManagerSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_PENDING, (CharSequence)filterType)) {
            listAccess = this.spaceService.getPendingSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_INVITED, (CharSequence)filterType)) {
            listAccess = this.spaceService.getInvitedSpacesByFilter(authenticatedUser, spaceFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPACE_FILTER_TYPE_REQUESTS, (CharSequence)filterType)) {
            listAccess = this.spaceService.getPendingSpaceRequestsToManage(authenticatedUser);
        } else {
            return Response.status((int)400).entity((Object)"Unrecognized space filter type").build();
        }
        ArrayList<DataEntity> spaceInfos = new ArrayList<DataEntity>();
        if (limit > 0) {
            for (Space space : (Space[])listAccess.load(offset, limit)) {
                SpaceEntity spaceInfo = EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand);
                spaceInfos.add(spaceInfo.getDataEntity());
            }
        }
        CollectionEntity collectionSpace = new CollectionEntity(spaceInfos, "spaces", offset, limit);
        if (returnSize) {
            collectionSpace.setSize(listAccess.getSize());
        }
        EntityTag eTag = null;
        eTag = new EntityTag(Integer.toString(collectionSpace.hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            builder = EntityBuilder.getResponseBuilder(collectionSpace, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
            builder.tag(eTag);
            Date date = new Date(System.currentTimeMillis());
            builder.lastModified(date);
            builder.expires(date);
        }
        return builder.build();
    }

    @Override
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Creates a space", httpMethod="POST", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response createSpace(@Context UriInfo uriInfo, @ApiParam(value="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Space object to be created, ex:<br />{<br />\"displayName\": \"My space\",<br />\"description\": \"This is my space\",<br />\"groupId\": \"/spaces/my_space\",<br />\"visibility\": \"private\",<br />\"subscription\": \"validation\"<br />}", required=true) SpaceEntity model) throws Exception {
        if (model == null || model.getDisplayName() == null || model.getDisplayName().length() < 3 || model.getDisplayName().length() > 200 || !SpaceUtils.isValidSpaceName((String)model.getDisplayName())) {
            throw new SpaceException(SpaceException.Code.INVALID_SPACE_NAME);
        }
        if (this.spaceService.getSpaceByDisplayName(model.getDisplayName()) != null) {
            throw new SpaceException(SpaceException.Code.SPACE_ALREADY_EXIST);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = new Space();
        this.fillSpaceFromModel(space, model);
        space.setEditor(authenticatedUser);
        String[] managers = new String[]{authenticatedUser};
        String[] members = new String[]{authenticatedUser};
        space.setManagers(managers);
        space.setMembers(members);
        this.spaceService.createSpace(space, authenticatedUser, model.getInvitedMembers());
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Produces(value={"text/plain"})
    @Path(value="{spaceId}/checkExternals")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Checks if a specific a space contains an external members", httpMethod="GET", response=Response.class, notes="This returns the space if it contains external members")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=400, message="Invalid query input")})
    public Response isSpaceContainsExternals(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="Space Id", required=true) @PathParam(value="spaceId") String spaceId) {
        boolean hasExternals;
        if (spaceId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"space Id is mandatory").build();
        }
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"space not found").build();
        }
        try {
            hasExternals = this.spaceService.isSpaceContainsExternals(Long.valueOf(spaceId));
        }
        catch (Exception e) {
            LOG.error("Error while checking external members on space {}", new Object[]{space.getGroupId(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"server internal error occurred").build();
        }
        return Response.ok((Object)String.valueOf(hasExternals)).type("text/plain").build();
    }

    @Override
    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a specific space by id", httpMethod="GET", response=Response.class, notes="This returns the space in the following cases: <br/><ul><li>the authenticated user is a member of the space</li><li>the space is \"public\"</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getSpaceById(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="Space id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand) throws Exception {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(id);
        if (space == null || "hidden".equals(space.getVisibility()) && !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        long cacheTime = space.getCacheTime();
        String eTagValue = expand == null ? String.valueOf(cacheTime) : String.valueOf((long)(authenticatedUser.hashCode() + expand.hashCode()) + cacheTime);
        EntityTag eTag = new EntityTag(eTagValue, true);
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            SpaceEntity spaceEntity = EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand);
            builder = Response.ok((Object)spaceEntity.getDataEntity(), (String)"application/json");
            builder.tag(eTag);
            builder.lastModified(new Date(cacheTime));
            builder.expires(new Date(cacheTime));
        }
        return builder.build();
    }

    @Override
    @GET
    @Path(value="byPrettyName/{prettyName}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a specific space by pretty name", httpMethod="GET", response=Response.class, notes="This returns the space in the following cases: <br/><ul><li>the authenticated user is a member of the space</li><li>the space is \"public\"</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getSpaceByPrettyName(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="Space id", required=true) @PathParam(value="prettyName") String prettyName, @ApiParam(value="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand) throws Exception {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceByPrettyName(prettyName);
        if (space == null || "hidden".equals(space.getVisibility()) && !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        long cacheTime = space.getCacheTime();
        String eTagValue = expand == null ? String.valueOf(cacheTime) : String.valueOf((long)expand.hashCode() + cacheTime);
        EntityTag eTag = new EntityTag(eTagValue, true);
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            SpaceEntity spaceEntity = EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand);
            builder = Response.ok((Object)spaceEntity.getDataEntity(), (String)"application/json");
            builder.tag(eTag);
            builder.lastModified(new Date(cacheTime));
            builder.expires(new Date(cacheTime));
        }
        return builder.build();
    }

    @Override
    @GET
    @Path(value="byDisplayName/{displayName}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a specific space by display name", httpMethod="GET", response=Response.class, notes="This returns the space in the following cases: <br/><ul><li>the authenticated user is a member of the space</li><li>the space is \"public\"</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getSpaceByDisplayName(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="Space id", required=true) @PathParam(value="displayName") String displayName, @ApiParam(value="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand) throws Exception {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceByDisplayName(displayName);
        if (space == null || "hidden".equals(space.getVisibility()) && !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        long cacheTime = space.getCacheTime();
        String eTagValue = expand == null ? String.valueOf(cacheTime) : String.valueOf((long)expand.hashCode() + cacheTime);
        EntityTag eTag = new EntityTag(eTagValue, true);
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            SpaceEntity spaceEntity = EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand);
            builder = Response.ok((Object)spaceEntity.getDataEntity(), (String)"application/json");
            builder.tag(eTag);
            builder.lastModified(new Date(cacheTime));
            builder.expires(new Date(cacheTime));
        }
        return builder.build();
    }

    @GET
    @Path(value="{id}/avatar")
    @ApiOperation(value="Gets a space avatar by pretty name", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Resource not found")})
    public Response getSpaceAvatarById(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified, @ApiParam(value="Space pretty name", required=true) @PathParam(value="id") String id, @ApiParam(value="A mandatory valid token that is used to authorize anonymous request", required=false) @QueryParam(value="r") String token) throws IOException {
        boolean isDefault = StringUtils.equals((CharSequence)"default-image", (CharSequence)id);
        Response.ResponseBuilder builder = null;
        Long lastUpdated = null;
        if (!isDefault) {
            InputStream stream;
            if (RestUtils.isAnonymous() && !LinkProvider.isAttachmentTokenValid((String)token, (String)"space", (String)id, (String)"avatar", (String)lastModified)) {
                LOG.warn("An anonymous user attempts to access avatar of space {} without a valid access token", new Object[]{id});
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String authenticatedUser = RestUtils.getCurrentUser();
            Space space = this.spaceService.getSpaceByPrettyName(id);
            if (space == null || "hidden".equals(space.getVisibility()) && RestUtils.isAnonymous() || "hidden".equals(space.getVisibility()) && !RestUtils.isAnonymous() && !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Identity identity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
            Profile profile = identity.getProfile();
            if (profile != null) {
                lastUpdated = profile.getAvatarLastUpdated();
            }
            EntityTag eTag = null;
            if (lastUpdated != null) {
                eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
            }
            Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
            if (builder == null && (stream = this.identityManager.getAvatarInputStream(identity)) != null) {
                builder = Response.ok((Object)stream, (String)"image/png");
                builder.tag(eTag);
            }
        }
        if (builder == null) {
            builder = this.getDefaultAvatarBuilder();
        }
        builder.cacheControl(CACHE_CONTROL);
        builder.lastModified(lastUpdated == null ? DEFAULT_IMAGES_LAST_MODIFED : new Date(lastUpdated));
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            builder.expires(new Date(System.currentTimeMillis() + 604800000L));
        }
        return builder.build();
    }

    @GET
    @Path(value="{id}/banner")
    @ApiOperation(value="Gets a space banner by id", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Resource not found")})
    public Response getSpaceBannerById(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified, @ApiParam(value="Space id", required=true) @PathParam(value="id") String id, @ApiParam(value="A mandatory valid token that is used to authorize anonymous request", required=false) @QueryParam(value="r") String token) throws IOException {
        Response.ResponseBuilder builder;
        boolean isDefault = StringUtils.equals((CharSequence)"default-image", (CharSequence)id);
        if (isDefault) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (RestUtils.isAnonymous() && !LinkProvider.isAttachmentTokenValid((String)token, (String)"space", (String)id, (String)"banner", (String)lastModified)) {
            LOG.warn("An anonymous user attempts to access banner of space {} without a valid access token", new Object[]{id});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String authenticatedUser = RestUtils.getCurrentUser();
        Space space = this.spaceService.getSpaceByPrettyName(id);
        if (space == null || "hidden".equals(space.getVisibility()) && RestUtils.isAnonymous() || "hidden".equals(space.getVisibility()) && !RestUtils.isAnonymous() && !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Identity identity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
        Profile profile = identity.getProfile();
        Long lastUpdated = null;
        if (profile != null) {
            lastUpdated = profile.getBannerLastUpdated();
        }
        EntityTag eTag = null;
        if (lastUpdated != null) {
            eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
        }
        Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
        if (builder == null) {
            InputStream stream = this.identityManager.getBannerInputStream(identity);
            if (stream == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            builder = Response.ok((Object)stream, (String)"image/png");
            builder.tag(eTag);
        }
        builder.cacheControl(CACHE_CONTROL);
        builder.lastModified(lastUpdated == null ? DEFAULT_IMAGES_LAST_MODIFED : new Date(lastUpdated));
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            builder.expires(new Date(System.currentTimeMillis() + 604800000L));
        }
        return builder.build();
    }

    @Override
    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Updates a specific space by id", httpMethod="PUT", response=Response.class, notes="This updates the space in the following cases: <br/><ul><li>the authenticated user is a manager of the space</li><li>the authenticated user is the owner of the space</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response updateSpaceById(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Space object to be updated", required=true) SpaceEntity model) throws Exception {
        if (model == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(id);
        if (space == null || !this.spaceService.isManager(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (!(model.getDisplayName() == null || model.getDisplayName().length() >= 3 && model.getDisplayName().length() <= 200 && SpaceUtils.isValidSpaceName((String)model.getDisplayName()))) {
            throw new SpaceException(SpaceException.Code.INVALID_SPACE_NAME);
        }
        if (StringUtils.isNotBlank((CharSequence)model.getDisplayName()) && !StringUtils.equals((CharSequence)space.getDisplayName(), (CharSequence)model.getDisplayName())) {
            this.spaceService.renameSpace(authenticatedUser, space, model.getDisplayName());
        }
        if (model.getExternalInvitedUsers() != null) {
            String uri = uriInfo.getBaseUri().toString().substring(0, uriInfo.getBaseUri().toString().lastIndexOf("/"));
            StringBuilder url = new StringBuilder(uri);
            PasswordRecoveryService passwordRecoveryService = (PasswordRecoveryService)CommonsUtils.getService(PasswordRecoveryService.class);
            DataStorage dataStorage = (DataStorage)CommonsUtils.getService(DataStorage.class);
            String currentSiteName = CommonsUtils.getCurrentSite().getName();
            Locale locale = null;
            try {
                String currentSiteLocale = dataStorage.getPortalConfig(currentSiteName).getLocale();
                locale = new Locale(currentSiteLocale);
            }
            catch (Exception e) {
                LOG.error((Object)"Failure to retrieve portal config", (Throwable)e);
            }
            for (String externalInvitedUser : model.getExternalInvitedUsers()) {
                String tokenId = passwordRecoveryService.sendExternalRegisterEmail(authenticatedUser, externalInvitedUser, locale, space.getDisplayName(), url);
                this.spaceService.saveSpaceExternalInvitation(space.getId(), externalInvitedUser, tokenId);
            }
        }
        this.fillSpaceFromModel(space, model);
        space.setEditor(authenticatedUser);
        this.spaceService.updateSpace(space, model.getInvitedMembers());
        space = this.spaceService.getSpaceById(space.getId());
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a specific space by id", httpMethod="DELETE", response=Response.class, notes="This deletes the space in the following cases: <br/><ul><li>the authenticated user is a manager of the space</li><li>the authenticated user is the owner of the space</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response deleteSpaceById(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(id);
        if (space == null || !this.spaceService.isManager(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.spaceService.deleteSpace(space);
        return Response.ok().build();
    }

    @Override
    @GET
    @Path(value="{id}/users")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets users of a specific space", httpMethod="GET", response=Response.class, notes="This returns a list of users if the authenticated user is a member or manager of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getSpaceMembers(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="Space id", required=true) @PathParam(value="id") String id, @ApiParam(value="User name search information", required=false) @QueryParam(value="q") String q, @ApiParam(value="Role of the target user in this space: manager, member, invited and pending", required=false, defaultValue="member") @QueryParam(value="role") String role, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of users or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        EntityTag eTag;
        Response.ResponseBuilder builder;
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(id);
        if (space == null || !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        long cacheTime = space.getCacheTime();
        if (StringUtils.isBlank((CharSequence)role)) {
            role = SpaceMemberFilterListAccess.Type.MEMBER.name();
        }
        SpaceMemberFilterListAccess.Type type = SpaceMemberFilterListAccess.Type.valueOf((String)role.toUpperCase());
        ProfileFilter profileFilter = new ProfileFilter();
        profileFilter.setName(q);
        ListAccess spaceIdentitiesListAccess = this.identityManager.getSpaceIdentityByProfileFilter(space, profileFilter, type, true);
        Identity[] spaceIdentities = (Identity[])spaceIdentitiesListAccess.load(offset, limit);
        List profileInfos = null;
        profileInfos = spaceIdentities == null || spaceIdentities.length == 0 ? Collections.emptyList() : Arrays.stream(spaceIdentities).map(identity -> EntityBuilder.buildEntityProfile(space, identity.getProfile(), uriInfo.getPath(), expand).getDataEntity()).collect(Collectors.toList());
        CollectionEntity collectionUser = new CollectionEntity(profileInfos, "users", offset, limit);
        if (returnSize) {
            collectionUser.setSize(spaceIdentitiesListAccess.getSize());
        }
        if ((builder = request.evaluatePreconditions(eTag = new EntityTag(String.valueOf(collectionUser.hashCode()), true))) == null) {
            builder = Response.ok((Object)collectionUser, (String)"application/json");
            builder.tag(eTag);
            builder.lastModified(new Date(cacheTime));
            builder.expires(new Date(cacheTime));
        }
        return builder.build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{id}/users/{userId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Checks if the given user is a member of a specific space or not", httpMethod="GET", response=Response.class, notes="This Checks if user is a member of a specific spacer o not.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response isSpaceMember(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @PathParam(value="id") String id, @ApiParam(value="User id", required=true) @PathParam(value="userId") String userId) {
        Space space = this.spaceService.getSpaceById(id);
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (space == null || !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        boolean isMember = this.spaceService.isMember(space, userId);
        return Response.ok().entity((Object)("{\"isMember\":\"" + isMember + "\"}")).build();
    }

    @GET
    @Path(value="{id}/navigations")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Return list of navigations of a space", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=401, message="Unauthorized")})
    public Response getSpaceNavigations(@Context HttpServletRequest httpRequest, @Context Request request, @ApiParam(value="Space id", required=true) @PathParam(value="id") String spaceId) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null || !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        long cacheTime = space.getCacheTime();
        String eTagValue = String.valueOf(cacheTime);
        EntityTag eTag = new EntityTag(eTagValue, true);
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            List navigations = SpaceUtils.getSpaceNavigations((Space)space, (Locale)httpRequest.getLocale(), (String)authenticatedUser);
            if (navigations == null) {
                return Response.ok(Collections.emptyList()).build();
            }
            List spaceNavigations = navigations.stream().map(node -> {
                BaseEntity app = new BaseEntity(node.getId());
                app.setProperty("label", node.getResolvedLabel());
                app.setProperty("icon", node.getIcon());
                app.setProperty("uri", node.getURI());
                return app.getDataEntity();
            }).collect(Collectors.toList());
            builder = Response.ok(spaceNavigations, (String)"application/json");
            builder.tag(eTag);
            builder.lastModified(new Date(cacheTime));
            builder.expires(new Date(cacheTime));
        }
        return builder.build();
    }

    @GET
    @Path(value="applications")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Return list of applications that a use is allowed to add to a space", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=401, message="Unauthorized")})
    public Response getSpaceApplicationsChoices() {
        try {
            List applications = this.spaceService.getSpacesApplications();
            List spaceApplications = applications.stream().map(application -> {
                application = this.computeApplicationAttributes((Application)application);
                BaseEntity app = new BaseEntity(application.getApplicationName());
                app.setProperty("displayName", application.getDisplayName());
                app.setProperty("contentId", application.getContentId());
                app.setProperty("applicationName", application.getApplicationName());
                app.setProperty("description", application.getDescription());
                app.setProperty("iconUrl", application.getIconURL());
                app.setProperty("removable", true);
                return app.getDataEntity();
            }).collect(Collectors.toList());
            return Response.ok(spaceApplications).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="applications")
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add an application into list of allowed application to instantiate in spaces", httpMethod="POST", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=401, message="Unauthorized")})
    public Response addSpaceApplication(Application application) {
        if (application == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"application is mandatory").build();
        }
        if (application.getContentId() == null || application.getApplicationName() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"application name and contentId are mandatory").build();
        }
        this.spaceService.addSpacesApplication(application);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="applications/{applicationName}")
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes an application from list of allowed application to instantiate in spaces", httpMethod="DELETE", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=401, message="Unauthorized")})
    public Response deleteSpaceApplication(@ApiParam(value="Application name", required=true) @PathParam(value="applicationName") String applicationName) {
        if (applicationName == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"application name is mandatory").build();
        }
        this.spaceService.deleteSpacesApplication(applicationName);
        return Response.noContent().build();
    }

    @GET
    @Path(value="{id}/applications")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Return list of applications of a space", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=401, message="Unauthorized")})
    public Response getSpaceApplications(@ApiParam(value="Space id", required=true) @PathParam(value="id") String spaceId) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null || !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List appList = SpaceUtils.getAppIdList((Space)space);
        ArrayList<String> sortedAppList = new ArrayList<String>();
        try {
            UserNode spaceUserNode = SpaceUtils.getSpaceUserNode((Space)space);
            Collection children = spaceUserNode.getChildren();
            for (UserNode userNode : children) {
                String appId2;
                if (userNode.getPageRef() == null || !appList.contains(appId2 = userNode.getPageRef().getName())) continue;
                sortedAppList.add(appId2);
            }
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        List applications = sortedAppList.stream().map(appId -> {
            Application application = null;
            try {
                application = SpaceUtils.getAppFromPortalContainer((String)appId);
            }
            catch (Exception e) {
                return null;
            }
            if (application == null) {
                String displayName = SpaceUtils.getAppNodeName((Space)space, (String)appId);
                BaseEntity app = new BaseEntity((String)appId);
                app.setProperty("displayName", displayName);
                app.setProperty("description", displayName);
                app.setProperty("removable", SpaceUtils.isRemovableApp((Space)space, (String)appId));
                app.setProperty("order", sortedAppList.indexOf(appId));
                return app.getDataEntity();
            }
            BaseEntity app = new BaseEntity((String)appId);
            app.setProperty("displayName", application.getDisplayName());
            app.setProperty("contentId", application.getContentId());
            app.setProperty("applicationName", application.getApplicationName());
            app.setProperty("description", application.getDescription());
            app.setProperty("iconUrl", application.getIconURL());
            app.setProperty("order", sortedAppList.indexOf(appId));
            app.setProperty("removable", SpaceUtils.isRemovableApp((Space)space, (String)appId));
            return app.getDataEntity();
        }).collect(Collectors.toList());
        return Response.ok(applications).build();
    }

    @DELETE
    @Path(value="{id}/applications/{appId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a selected application of a space", httpMethod="DELETE", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=401, message="Unauthorized")})
    public Response deleteSpaceApplication(@ApiParam(value="Space id", required=true) @PathParam(value="id") String spaceId, @ApiParam(value="Application id", required=true) @PathParam(value="appId") String appId) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null || !this.spaceService.isManager(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List<String> appPartsList = Arrays.asList(space.getApp().split(","));
        String appPartToChange = appPartsList.stream().filter(appPart -> StringUtils.startsWith((CharSequence)appPart, (CharSequence)(appId + ":"))).findFirst().orElse(null);
        if (StringUtils.isBlank((CharSequence)appPartToChange)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String[] appParts = appPartToChange.split(":");
        try {
            this.spaceService.removeApplication(space, appId, appParts[1]);
        }
        catch (SpaceException e) {
            return Response.serverError().entity((Object)e.getLocalizedMessage()).build();
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="{id}/applications")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Add a new application into space", httpMethod="POST", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=401, message="Unauthorized")})
    public Response addSpaceApplication(@ApiParam(value="Space id", required=true) @PathParam(value="id") String spaceId, @ApiParam(value="Application id", required=true) @FormParam(value="appId") String appId) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null || !this.spaceService.isManager(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        try {
            this.spaceService.installApplication(space, appId);
            this.spaceService.activateApplication(space, appId);
        }
        catch (SpaceException e) {
            return Response.serverError().entity((Object)e.getLocalizedMessage()).build();
        }
        return Response.noContent().build();
    }

    @PUT
    @Path(value="{id}/applications/{appId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a selected application of a space", httpMethod="PUT", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=401, message="Unauthorized")})
    public Response moveSpaceApplicationOrder(@ApiParam(value="Space id", required=true) @PathParam(value="id") String spaceId, @ApiParam(value="Application id", required=true) @PathParam(value="appId") String appId, @ApiParam(value="Move transition: 1 to move up, -1 to move down", required=true) @FormParam(value="transition") int transition) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null || !this.spaceService.isManager(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        try {
            this.spaceService.moveApplication(spaceId, appId, transition);
        }
        catch (SpaceException e) {
            return Response.serverError().entity((Object)e.getLocalizedMessage()).build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="{id}/activities")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets space activities by space id", httpMethod="GET", response=Response.class, notes="This returns the space's activities if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    @Deprecated
    @DeprecatedAPI(value="Use activityRestResourcesV1.getActivities instead", insist=true)
    public Response getSpaceActivitiesById(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @PathParam(value="id") String id, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Base time to load older activities (yyyy-MM-dd HH:mm:ss)", required=false) @QueryParam(value="before") String before, @ApiParam(value="Base time to load newer activities (yyyy-MM-dd HH:mm:ss)", required=false) @QueryParam(value="after") String after, @ApiParam(value="Returning the number of activities or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand) throws Exception {
        UriInfo uriInfo2 = uriInfo;
        String string = id;
        int n = offset;
        int n2 = limit;
        String string2 = before;
        String string3 = after;
        boolean bl = returnSize;
        String string4 = expand;
        Object[] objectArray = new Object[]{uriInfo2, string, Conversions.intObject((int)n), Conversions.intObject((int)n2), string2, string3, Conversions.booleanObject((boolean)bl), string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, string, Conversions.intObject((int)n), Conversions.intObject((int)n2), string2, string3, Conversions.booleanObject((boolean)bl), string4, joinPoint};
        SpaceRestResourcesV1$AjcClosure1 spaceRestResourcesV1$AjcClosure1 = new SpaceRestResourcesV1$AjcClosure1(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRestResourcesV1$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @POST
    @Path(value="{id}/activities")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Posts an activity to a specific space", httpMethod="POST", response=Response.class, notes="This posts the activity if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    @Deprecated
    @DeprecatedAPI(value="Use activityRestResourcesV1.postActivity instead", insist=true)
    public Response postActivityOnSpace(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Activity object to be created", required=true) ActivityEntity model) throws Exception {
        UriInfo uriInfo2 = uriInfo;
        String string = id;
        String string2 = expand;
        ActivityEntity activityEntity = model;
        Object[] objectArray = new Object[]{uriInfo2, string, string2, activityEntity};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, uriInfo2, string, string2, activityEntity, joinPoint};
        SpaceRestResourcesV1$AjcClosure3 spaceRestResourcesV1$AjcClosure3 = new SpaceRestResourcesV1$AjcClosure3(objectArray2);
        return (Response)DeprecatedAPIAspect.aspectOf().around(spaceRestResourcesV1$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    private void fillSpaceFromModel(Space space, SpaceEntity model) throws IOException {
        space.setPriority("2");
        if (StringUtils.isNotBlank((CharSequence)model.getDisplayName())) {
            space.setDisplayName(model.getDisplayName());
            space.setDescription(model.getDescription());
            if (StringUtils.isBlank((CharSequence)space.getPrettyName())) {
                space.setPrettyName(model.getDisplayName());
            }
        } else if (StringUtils.isNotBlank((CharSequence)model.getPrettyName())) {
            space.setPrettyName(model.getPrettyName());
            space.setDescription(model.getDescription());
            if (StringUtils.isBlank((CharSequence)space.getDisplayName())) {
                space.setDisplayName(model.getPrettyName());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)model.getTemplate())) {
            space.setTemplate(model.getTemplate());
        }
        if (StringUtils.isNotBlank((CharSequence)model.getBannerId())) {
            this.updateProfileField(space, "banner", model.getBannerId());
        }
        if (StringUtils.isNotBlank((CharSequence)model.getAvatarId())) {
            this.updateProfileField(space, "avatar", model.getAvatarId());
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"hidden", (CharSequence)model.getVisibility())) {
            space.setVisibility("hidden");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"private", (CharSequence)model.getVisibility())) {
            space.setVisibility("private");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"public", (CharSequence)model.getVisibility())) {
            space.setVisibility("public");
        } else if (StringUtils.isBlank((CharSequence)model.getVisibility()) && space.getId() == null) {
            space.setVisibility("private");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"open", (CharSequence)model.getSubscription())) {
            space.setRegistration("open");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"closed", (CharSequence)model.getSubscription())) {
            space.setRegistration("closed");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"validation", (CharSequence)model.getSubscription())) {
            space.setRegistration("validation");
        } else if (StringUtils.isBlank((CharSequence)model.getSubscription()) && space.getId() == null) {
            space.setRegistration("validation");
        }
    }

    @GET
    @Path(value="{id}/externalInvitations")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets external invitations of a specific space", httpMethod="GET", response=Response.class, notes="This returns a list of external invitations if the authenticated user is a member or manager of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getSpaceExternalInvitations(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @PathParam(value="id") String id) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceById(id);
        if (space == null || !this.spaceService.isManager(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List spaceExternalInvitations = this.spaceService.findSpaceExternalInvitationsBySpaceId(id);
        return EntityBuilder.getResponseBuilder(spaceExternalInvitations, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK).build();
    }

    @DELETE
    @Path(value="externalInvitations/{invitationId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Delete a specific external invitation from a specific space", httpMethod="DELETE", response=Response.class, notes="This Delete a specific external invitation from a specific space if the authenticated user is a member or manager of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response declineExternalInvitations(@Context UriInfo uriInfo, @ApiParam(value="invitation id", required=true) @PathParam(value="invitationId") String invitationId) {
        SpaceExternalInvitation spaceExternalInvitation = this.spaceService.getSpaceExternalInvitationById(invitationId);
        if (spaceExternalInvitation == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Space space = this.spaceService.getSpaceById(spaceExternalInvitation.getSpaceId());
        if (space == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!this.spaceService.isManager(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        try {
            this.spaceService.deleteSpaceExternalInvitation(invitationId);
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting invitation", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProfileField(Space space, String name, String value) throws IOException {
        if ("avatar".equals(name) || "banner".equals(name)) {
            UploadResource uploadResource = this.uploadService.getUploadResource(value);
            if (uploadResource == null) {
                throw new IllegalStateException("No uploaded resource found with uploadId = " + value);
            }
            String storeLocation = uploadResource.getStoreLocation();
            try (FileInputStream inputStream = new FileInputStream(storeLocation);){
                if ("avatar".equals(name)) {
                    AvatarAttachment attachment = new AvatarAttachment(null, uploadResource.getFileName(), uploadResource.getMimeType(), (InputStream)inputStream, System.currentTimeMillis());
                    space.setAvatarAttachment(attachment);
                    this.spaceService.updateSpaceAvatar(space);
                } else {
                    BannerAttachment attachment = new BannerAttachment(null, uploadResource.getFileName(), uploadResource.getMimeType(), (InputStream)inputStream, System.currentTimeMillis());
                    space.setBannerAttachment(attachment);
                    this.spaceService.updateSpaceBanner(space);
                }
            }
            finally {
                this.uploadService.removeUploadResource(value);
            }
        }
    }

    private Response.ResponseBuilder getDefaultAvatarBuilder() throws IOException {
        if (this.defaultSpaceAvatar == null) {
            InputStream is = PortalContainer.getInstance().getPortalContext().getResourceAsStream("/skin/images/avatar/DefaultSpaceAvatar.png");
            this.defaultSpaceAvatar = is == null ? new byte[0] : IOUtil.getStreamContentAsBytes((InputStream)is);
        }
        return Response.ok((Object)new ByteArrayInputStream(this.defaultSpaceAvatar), (String)"image/png");
    }

    private Application computeApplicationAttributes(Application application) {
        Application applicationFromContainer = null;
        try {
            applicationFromContainer = SpaceUtils.getAppFromPortalContainer((String)application.getApplicationName());
        }
        catch (Exception e) {
            LOG.debug((Object)"Error retrieving");
        }
        if (applicationFromContainer != null) {
            application = applicationFromContainer;
        }
        return application;
    }

    static {
        SpaceRestResourcesV1.ajc$preClinit();
        LOG = ExoLogger.getLogger(SpaceRestResourcesV1.class);
        CACHE_CONTROL = new CacheControl();
        DEFAULT_IMAGES_LAST_MODIFED = new Date();
    }

    static /* synthetic */ Response getSpaceActivitiesById_aroundBody0(SpaceRestResourcesV1 ajc$this, UriInfo uriInfo, String id, int offset, int limit, String before, String after, boolean returnSize, String expand, JoinPoint joinPoint) {
        return ajc$this.activityRestResourcesV1.getActivities(uriInfo, id, before, after, offset, limit, returnSize, expand);
    }

    static /* synthetic */ Response postActivityOnSpace_aroundBody2(SpaceRestResourcesV1 ajc$this, UriInfo uriInfo, String id, String expand, ActivityEntity model, JoinPoint joinPoint) {
        return ajc$this.activityRestResourcesV1.postActivity(uriInfo, id, expand, model);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpaceRestResourcesV1.java", SpaceRestResourcesV1.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSpaceActivitiesById", "org.exoplatform.social.rest.impl.space.SpaceRestResourcesV1", "javax.ws.rs.core.UriInfo:java.lang.String:int:int:java.lang.String:java.lang.String:boolean:java.lang.String", "uriInfo:id:offset:limit:before:after:returnSize:expand", "java.lang.Exception", "javax.ws.rs.core.Response"), 1121);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "postActivityOnSpace", "org.exoplatform.social.rest.impl.space.SpaceRestResourcesV1", "javax.ws.rs.core.UriInfo:java.lang.String:java.lang.String:org.exoplatform.social.rest.entity.ActivityEntity", "uriInfo:id:expand:model", "java.lang.Exception", "javax.ws.rs.core.Response"), 1145);
    }
}

