/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class UserPortalConfigListener
extends UserEventListener {
    private final Log log = ExoLogger.getLogger(UserPortalConfigListener.class);
    private final UserPortalConfigService portalConfigService;

    public UserPortalConfigListener(UserPortalConfigService portalConfigService) {
        this.portalConfigService = portalConfigService;
    }

    public void preDelete(User user) throws Exception {
        if (this.portalConfigService.getDestroyUserPortal()) {
            String userName = user.getUserName();
            this.log.debug((Object)("About to destroy user site for user " + userName));
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                this.portalConfigService.removeUserPortalConfig("user", userName);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSave(User user, boolean isNew) {
        if (this.portalConfigService.getCreateUserPortal()) {
            String userName = user.getUserName();
            this.log.debug((Object)("About to create user site for user " + userName));
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                this.portalConfigService.createUserSite(userName);
            }
            catch (Exception e) {
                this.log.error((Object)("Could not create user site for user " + userName), (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }
}

