/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api;

import java.util.Locale;
import org.gatein.api.Portal;
import org.gatein.api.PortalRequest;
import org.gatein.api.common.URIResolver;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.security.User;
import org.gatein.api.site.SiteId;

public class BasicPortalRequest
extends PortalRequest {
    private final User user;
    private final SiteId siteId;
    private final NodePath nodePath;
    private final Locale locale;
    private final Portal portal;
    private final URIResolver uriResolver;

    public BasicPortalRequest(User user, SiteId siteId, NodePath nodePath, Locale locale, Portal portal, URIResolver uriResolver) {
        this.user = user;
        this.siteId = siteId;
        this.nodePath = nodePath;
        this.locale = locale;
        this.portal = portal;
        this.uriResolver = uriResolver;
    }

    public User getUser() {
        return this.user;
    }

    public SiteId getSiteId() {
        return this.siteId;
    }

    public NodePath getNodePath() {
        return this.nodePath;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Portal getPortal() {
        return this.portal;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public static void setInstance(BasicPortalRequest request) {
        PortalRequest.setInstance((PortalRequest)request);
    }

    public static class BasicURIResolver
    implements URIResolver {
        private String portalURI;

        public BasicURIResolver(String portalURI) {
            this.portalURI = portalURI;
        }

        public String resolveURI(SiteId siteId) {
            String name = siteId.getName();
            if (name.charAt(0) == '/') {
                return this.portalURI + name;
            }
            return this.portalURI + "/" + name;
        }
    }
}

