/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.LogRecord;
import org.apache.juli.FileHandler;

public class AsyncFileHandler
extends FileHandler {
    public static final int OVERFLOW_DROP_LAST = 1;
    public static final int OVERFLOW_DROP_FIRST = 2;
    public static final int OVERFLOW_DROP_FLUSH = 3;
    public static final int OVERFLOW_DROP_CURRENT = 4;
    public static final int DEFAULT_OVERFLOW_DROP_TYPE = 1;
    public static final int DEFAULT_MAX_RECORDS = 10000;
    public static final int OVERFLOW_DROP_TYPE = Integer.parseInt(System.getProperty("org.apache.juli.AsyncOverflowDropType", Integer.toString(1)));
    public static final int MAX_RECORDS = Integer.parseInt(System.getProperty("org.apache.juli.AsyncMaxRecordCount", Integer.toString(10000)));
    protected static final LinkedBlockingDeque<LogEntry> queue = new LinkedBlockingDeque(MAX_RECORDS);
    protected static final LoggerThread logger = new LoggerThread();
    private final Object closeLock = new Object();
    protected volatile boolean closed = false;

    public AsyncFileHandler() {
        this(null, null, null);
    }

    public AsyncFileHandler(String directory, String prefix, String suffix) {
        this(directory, prefix, suffix, null);
    }

    public AsyncFileHandler(String directory, String prefix, String suffix, Integer maxDays) {
        super(directory, prefix, suffix, maxDays);
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        LoggerThread.deregisterHandler();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void open() {
        if (!this.closed) {
            return;
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.closed) {
                return;
            }
            this.closed = false;
        }
        LoggerThread.registerHandler();
        super.open();
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        record.getSourceMethodName();
        LogEntry entry = new LogEntry(record, this);
        boolean added = false;
        try {
            while (!added && !queue.offer(entry)) {
                switch (OVERFLOW_DROP_TYPE) {
                    case 1: {
                        queue.pollLast();
                        break;
                    }
                    case 2: {
                        queue.pollFirst();
                        break;
                    }
                    case 3: {
                        added = queue.offer(entry, 1000L, TimeUnit.MILLISECONDS);
                        break;
                    }
                    case 4: {
                        added = true;
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void publishInternal(LogRecord record) {
        super.publish(record);
    }

    static {
        logger.start();
    }

    protected static class LogEntry {
        private final LogRecord record;
        private final AsyncFileHandler handler;

        public LogEntry(LogRecord record, AsyncFileHandler handler) {
            this.record = record;
            this.handler = handler;
        }

        public boolean flush() {
            if (this.handler.closed) {
                return false;
            }
            this.handler.publishInternal(this.record);
            return true;
        }
    }

    protected static class LoggerThread
    extends Thread {
        private static final AtomicInteger handlerCount = new AtomicInteger();

        public static void registerHandler() {
            handlerCount.incrementAndGet();
        }

        public static void deregisterHandler() {
            int newCount = handlerCount.decrementAndGet();
            if (newCount == 0) {
                try {
                    Thread dummyHook = new Thread();
                    Runtime.getRuntime().addShutdownHook(dummyHook);
                    Runtime.getRuntime().removeShutdownHook(dummyHook);
                }
                catch (IllegalStateException ise) {
                    for (int sleepCount = 0; !queue.isEmpty() && sleepCount < 10000; ++sleepCount) {
                        try {
                            Thread.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        public LoggerThread() {
            this.setDaemon(true);
            this.setName("AsyncFileHandlerWriter-" + System.identityHashCode(this));
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        LogEntry entry = queue.take();
                        entry.flush();
                    }
                }
                catch (InterruptedException entry) {
                    continue;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

