/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs;

import org.apache.ecs.Element;
import org.apache.ecs.Printable;
import org.apache.ecs.SinglePartElement;

public class Doctype
extends SinglePartElement
implements Printable {
    public static final String elementName = "!DOCTYPE";
    public static final String PUBLIC = "PUBLIC";
    protected String name;
    protected String visibility;
    protected String identifier;
    protected String uri;

    public Doctype() {
        this.setElementType(elementName);
        this.setCase(1);
        this.updateElementType();
    }

    public Doctype(String string, String string2, String string3) {
        this.setElementType(elementName);
        this.setCase(1);
        this.name = string;
        this.visibility = PUBLIC;
        this.identifier = string2;
        this.uri = string3;
        this.updateElementType();
    }

    public Doctype(String string, String string2, String string3, String string4) {
        this.setElementType(elementName);
        this.setCase(1);
        this.name = string;
        this.visibility = string2;
        this.identifier = string3;
        this.uri = string4;
        this.updateElementType();
    }

    public Doctype addElement(String string) {
        this.addElementToRegistry(string);
        return this;
    }

    public Doctype addElement(String string, String string2) {
        this.addElementToRegistry(string, string2);
        return this;
    }

    public Doctype addElement(String string, Element element) {
        this.addElementToRegistry(string, element);
        return this;
    }

    public Doctype addElement(Element element) {
        this.addElementToRegistry(element);
        return this;
    }

    public Doctype removeElement(String string) {
        this.removeElementFromRegistry(string);
        return this;
    }

    public Doctype setIdentifier(String string) {
        this.identifier = string;
        this.updateElementType();
        return this;
    }

    public Doctype setName(String string) {
        this.name = string;
        this.updateElementType();
        return this;
    }

    public Doctype setUri(String string) {
        this.uri = string;
        this.updateElementType();
        return this;
    }

    public Doctype setVisibility(String string) {
        this.visibility = string;
        this.updateElementType();
        return this;
    }

    protected void updateElementType() {
        this.setElementType("!DOCTYPE " + this.name + " " + this.visibility + " " + this.identifier + " " + this.uri);
    }

    public static class Html40Strict
    extends Doctype {
        public Html40Strict() {
            this.name = "HTML";
            this.visibility = Doctype.PUBLIC;
            this.identifier = "\"-//W3C//DTD HTML 4.0//EN\"";
            this.uri = "\"http://www.w3.org/TR/REC-html40/strict.dtd\"";
            this.updateElementType();
        }
    }

    public static class Html40Transitional
    extends Doctype {
        public Html40Transitional() {
            this.name = "HTML";
            this.visibility = Doctype.PUBLIC;
            this.identifier = "\"-//W3C//DTD HTML 4.0 Transitional//EN\"";
            this.uri = "\"http://www.w3.org/TR/REC-html40/loose.dtd\"";
            this.updateElementType();
        }
    }

    public static class Html40Frameset
    extends Doctype {
        public Html40Frameset() {
            this.name = "HTML";
            this.visibility = Doctype.PUBLIC;
            this.identifier = "\"-//W3C//DTD HTML 4.0 Frameset//EN\"";
            this.uri = "\"http://www.w3.org/TR/REC-html40/frameset.dtd\"";
            this.updateElementType();
        }
    }

    public static class Html401Strict
    extends Doctype {
        public Html401Strict() {
            this.name = "HTML";
            this.visibility = Doctype.PUBLIC;
            this.identifier = "\"-//W3C//DTD HTML 4.01//EN\"";
            this.uri = "\"http://www.w3.org/TR/html4/strict.dtd\"";
            this.updateElementType();
        }
    }

    public static class Html401Transitional
    extends Doctype {
        public Html401Transitional() {
            this.name = "HTML";
            this.visibility = Doctype.PUBLIC;
            this.identifier = "\"-//W3C//DTD HTML 4.01 Transitional//EN\"";
            this.uri = "\"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd\"";
            this.updateElementType();
        }
    }

    public static class Html401Frameset
    extends Doctype {
        public Html401Frameset() {
            this.name = "HTML";
            this.visibility = Doctype.PUBLIC;
            this.identifier = "\"-//W3C//DTD HTML 4.01 Frameset//EN\"";
            this.uri = "\"http://www.w3.org/TR/1999/REC-html401-19991224/frameset.dtd\"";
            this.updateElementType();
        }
    }

    public static class XHtml10Strict
    extends Doctype {
        public XHtml10Strict() {
            this.name = "html";
            this.visibility = Doctype.PUBLIC;
            this.identifier = "\"-//W3C//DTD XHTML 1.0 Strict//EN\"";
            this.uri = "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"";
            this.updateElementType();
        }
    }

    public static class XHtml10Transitional
    extends Doctype {
        public XHtml10Transitional() {
            this.name = "html";
            this.visibility = Doctype.PUBLIC;
            this.identifier = "\"-//W3C//DTD XHTML 1.0 Transitional//EN\"";
            this.uri = "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"";
            this.updateElementType();
        }
    }

    public static class XHtml10Frameset
    extends Doctype {
        public XHtml10Frameset() {
            this.name = "html";
            this.visibility = Doctype.PUBLIC;
            this.identifier = "\"-//W3C//DTD XHTML 1.0 Frameset//EN\"";
            this.uri = "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\"";
            this.updateElementType();
        }
    }
}

