/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.storage;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.wallet.dao.WalletAccountBackupDAO;
import org.exoplatform.wallet.dao.WalletAccountDAO;
import org.exoplatform.wallet.dao.WalletBlockchainStateDAO;
import org.exoplatform.wallet.dao.WalletPrivateKeyDAO;
import org.exoplatform.wallet.entity.WalletBackupEntity;
import org.exoplatform.wallet.entity.WalletBlockchainStateEntity;
import org.exoplatform.wallet.entity.WalletEntity;
import org.exoplatform.wallet.entity.WalletPrivateKeyEntity;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.WalletProvider;
import org.exoplatform.wallet.model.WalletState;
import org.exoplatform.wallet.model.WalletType;
import org.exoplatform.wallet.storage.WalletStorage$AjcClosure1;
import org.exoplatform.wallet.storage.WalletStorage$AjcClosure3;
import org.exoplatform.wallet.utils.WalletUtils;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.CodecInitializer;

public class WalletStorage {
    private static final Log LOG;
    private final WalletAccountDAO walletAccountDAO;
    private final WalletAccountBackupDAO walletAccountBackupDAO;
    private final WalletPrivateKeyDAO privateKeyDAO;
    private final WalletBlockchainStateDAO blockchainStateDAO;
    private AbstractCodec codec;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public WalletStorage(WalletAccountDAO walletAccountDAO, WalletAccountBackupDAO walletAccountBackupDAO, WalletPrivateKeyDAO privateKeyDAO, WalletBlockchainStateDAO blockchainStateDAO, CodecInitializer codecInitializer) {
        this.walletAccountDAO = walletAccountDAO;
        this.walletAccountBackupDAO = walletAccountBackupDAO;
        this.privateKeyDAO = privateKeyDAO;
        this.blockchainStateDAO = blockchainStateDAO;
        if (codecInitializer != null) {
            try {
                this.codec = codecInitializer.getCodec();
            }
            catch (Exception e) {
                LOG.error((Object)"Error initializing codecs", (Throwable)e);
            }
        }
    }

    public Set<Wallet> listWallets() {
        List walletEntities = this.walletAccountDAO.findAll();
        if (walletEntities == null || walletEntities.isEmpty()) {
            return Collections.emptySet();
        }
        return walletEntities.stream().map(this::fromEntity).filter(wallet -> StringUtils.isNotBlank((CharSequence)wallet.getType())).collect(Collectors.toSet());
    }

    public long getWalletsCount() {
        return this.walletAccountDAO.count();
    }

    public Wallet getWalletByIdentityId(long identityId, String contractAddress) {
        WalletEntity walletEntity = (WalletEntity)this.walletAccountDAO.find(Long.valueOf(identityId));
        if (walletEntity == null) {
            return null;
        }
        return this.fromEntity(walletEntity);
    }

    public Wallet getWalletByAddress(String address, String contractAddress) {
        WalletEntity walletEntity = this.walletAccountDAO.findByAddress(address.toLowerCase());
        if (walletEntity == null) {
            return null;
        }
        return this.fromEntity(walletEntity);
    }

    public void retrieveWalletBlockchainState(Wallet wallet, String contractAddress) {
        if (wallet == null) {
            throw new IllegalArgumentException("wallet is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)contractAddress)) {
            throw new IllegalArgumentException("contractAddress is mandatory");
        }
        WalletBlockchainStateEntity blockchainStateEntity = this.blockchainStateDAO.findByWalletIdAndContract(wallet.getTechnicalId(), contractAddress);
        if (blockchainStateEntity != null) {
            wallet.setEtherBalance(Double.valueOf(blockchainStateEntity.getEtherBalance()));
            wallet.setTokenBalance(Double.valueOf(blockchainStateEntity.getTokenBalance()));
            wallet.setIsInitialized(Boolean.valueOf(blockchainStateEntity.isInitialized()));
        }
    }

    public Wallet saveWallet(Wallet wallet, boolean isNew) {
        WalletEntity walletEntity = this.toEntity(wallet);
        walletEntity = isNew ? (WalletEntity)this.walletAccountDAO.create(walletEntity) : (WalletEntity)this.walletAccountDAO.update(walletEntity);
        return this.fromEntity(walletEntity);
    }

    public Wallet saveWalletBackupState(long identityId, boolean backupState) {
        WalletEntity walletEntity = (WalletEntity)this.walletAccountDAO.find(Long.valueOf(identityId));
        walletEntity.setBackedUp(backupState);
        walletEntity = (WalletEntity)this.walletAccountDAO.update(walletEntity);
        return this.fromEntity(walletEntity);
    }

    public Wallet removeWallet(long identityId) {
        WalletEntity walletEntity = (WalletEntity)this.walletAccountDAO.find(Long.valueOf(identityId));
        this.walletAccountDAO.delete(walletEntity);
        return this.fromEntity(walletEntity);
    }

    public String getWalletPrivateKey(long walletId) {
        WalletPrivateKeyEntity privateKeyEntity = this.privateKeyDAO.findByWalletId(walletId);
        if (privateKeyEntity != null && StringUtils.isNotBlank((CharSequence)privateKeyEntity.getKeyContent())) {
            String privateKey = privateKeyEntity.getKeyContent();
            return this.decodeWalletKey(privateKey);
        }
        return null;
    }

    public void removeWalletPrivateKey(long walletId) {
        WalletPrivateKeyEntity privateKeyEntity = this.privateKeyDAO.findByWalletId(walletId);
        if (privateKeyEntity != null) {
            WalletEntity wallet = privateKeyEntity.getWallet();
            this.privateKeyDAO.delete(privateKeyEntity);
            wallet.setPrivateKey(null);
            this.walletAccountDAO.update(wallet);
        }
    }

    public void saveWalletPrivateKey(long walletId, String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new IllegalArgumentException("content is mandatory");
        }
        WalletEntity walletEntity = (WalletEntity)this.walletAccountDAO.find(Long.valueOf(walletId));
        if (walletEntity == null) {
            throw new IllegalStateException("Wallet with id " + walletId + " wasn't found");
        }
        WalletPrivateKeyEntity privateKey = walletEntity.getPrivateKey();
        if (privateKey == null) {
            privateKey = new WalletPrivateKeyEntity();
            privateKey.setId(null);
            privateKey.setWallet(walletEntity);
            walletEntity.setPrivateKey(privateKey);
        } else if (StringUtils.isNotBlank((CharSequence)privateKey.getKeyContent())) {
            LOG.info("Replacing wallet {}/{} private key", new Object[]{walletEntity.getType(), walletEntity.getId()});
        }
        privateKey.setKeyContent(this.encodeWalletKey(content));
        if (privateKey.getId() == null) {
            this.privateKeyDAO.create(privateKey);
        } else {
            this.privateKeyDAO.update(privateKey);
        }
    }

    public void saveWalletBlockchainState(Wallet wallet, String contractAddress) {
        boolean isNew;
        if (StringUtils.isBlank((CharSequence)contractAddress)) {
            throw new IllegalArgumentException("contractAddress is mandatory");
        }
        if (wallet == null) {
            throw new IllegalArgumentException("wallet is mandatory");
        }
        long walletId = wallet.getTechnicalId();
        if (walletId <= 0L) {
            throw new IllegalArgumentException("wallet ID is mandatory");
        }
        WalletBlockchainStateEntity blockchainStateEntity = this.blockchainStateDAO.findByWalletIdAndContract(walletId, contractAddress);
        boolean bl = isNew = blockchainStateEntity == null;
        if (isNew) {
            blockchainStateEntity = new WalletBlockchainStateEntity();
            WalletEntity walletEntity = (WalletEntity)this.walletAccountDAO.find(Long.valueOf(walletId));
            if (walletEntity == null) {
                throw new IllegalStateException("Can't find wallet with id: " + walletId);
            }
            blockchainStateEntity.setWallet(walletEntity);
        }
        blockchainStateEntity.setContractAddress(contractAddress);
        blockchainStateEntity.setEtherBalance(wallet.getEtherBalance() == null ? 0.0 : wallet.getEtherBalance());
        blockchainStateEntity.setTokenBalance(wallet.getTokenBalance() == null ? 0.0 : wallet.getTokenBalance());
        blockchainStateEntity.setInitialized(wallet.getIsInitialized() != null && wallet.getIsInitialized() != false);
        if (isNew) {
            this.blockchainStateDAO.create(blockchainStateEntity);
        } else {
            this.blockchainStateDAO.update(blockchainStateEntity);
        }
    }

    private String decodeWalletKey(String content) {
        return this.codec.decode(content);
    }

    private String encodeWalletKey(String content) {
        return this.codec.encode(content);
    }

    public boolean hasWalletBackup(long walletId) {
        return this.walletAccountBackupDAO.findByWalletId(walletId) != null;
    }

    public boolean hasWallet(long walletId) {
        return this.walletAccountDAO.find(Long.valueOf(walletId)) != null;
    }

    @ExoTransactional
    public void switchToInternalWallet(long walletId) {
        long l = walletId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        WalletStorage$AjcClosure1 walletStorage$AjcClosure1 = new WalletStorage$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(walletStorage$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void switchToWalletProvider(long walletId, WalletProvider provider, String newAddress) {
        long l = walletId;
        WalletProvider walletProvider = provider;
        String string = newAddress;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l), walletProvider, string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.longObject((long)l), walletProvider, string, joinPoint};
        WalletStorage$AjcClosure3 walletStorage$AjcClosure3 = new WalletStorage$AjcClosure3(objectArray2);
        ExoTransactionalAspect.aspectOf().around(walletStorage$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    private Wallet fromEntity(WalletEntity walletEntity) {
        Wallet wallet = new Wallet();
        wallet.setTechnicalId(walletEntity.getId().longValue());
        wallet.setAddress(walletEntity.getAddress());
        wallet.setPassPhrase(walletEntity.getPassPhrase());
        wallet.setEnabled(walletEntity.isEnabled());
        wallet.setInitializationState(walletEntity.getInitializationState().name());
        wallet.setBackedUp(walletEntity.isBackedUp());
        wallet.setProvider(walletEntity.getProvider().name());
        if (walletEntity.getPrivateKey() == null) {
            WalletPrivateKeyEntity privateKey = this.privateKeyDAO.findByWalletId(walletEntity.getId());
            wallet.setHasPrivateKey(privateKey != null);
        } else {
            wallet.setHasPrivateKey(true);
        }
        Identity identity = WalletUtils.getIdentityById((long)walletEntity.getId());
        WalletUtils.computeWalletFromIdentity((Wallet)wallet, (Identity)identity);
        return wallet;
    }

    private WalletEntity toEntity(Wallet wallet) {
        WalletEntity walletEntity = null;
        if (wallet.getTechnicalId() > 0L) {
            walletEntity = (WalletEntity)this.walletAccountDAO.find(Long.valueOf(wallet.getTechnicalId()));
        }
        if (walletEntity == null) {
            walletEntity = new WalletEntity();
        }
        walletEntity.setId(wallet.getTechnicalId());
        walletEntity.setAddress(wallet.getAddress().toLowerCase());
        walletEntity.setEnabled(wallet.isEnabled());
        walletEntity.setInitializationState(WalletState.valueOf((String)wallet.getInitializationState()));
        walletEntity.setPassPhrase(wallet.getPassPhrase());
        walletEntity.setBackedUp(wallet.isBackedUp());
        walletEntity.setType(WalletType.getType((String)wallet.getType()));
        if (wallet.getProvider() != null) {
            walletEntity.setProvider(WalletProvider.valueOf((String)wallet.getProvider()));
        } else if (walletEntity.getProvider() == null) {
            walletEntity.setProvider(WalletProvider.INTERNAL_WALLET);
        }
        return walletEntity;
    }

    static {
        WalletStorage.ajc$preClinit();
        LOG = ExoLogger.getLogger(WalletStorage.class);
    }

    static /* synthetic */ void switchToInternalWallet_aroundBody0(WalletStorage ajc$this, long walletId, JoinPoint joinPoint) {
        WalletBackupEntity walletBackup = ajc$this.walletAccountBackupDAO.findByWalletId(walletId);
        String address = walletBackup.getAddress();
        WalletEntity walletEntity = (WalletEntity)ajc$this.walletAccountDAO.find(Long.valueOf(walletId));
        walletEntity.setAddress(address);
        walletEntity.setProvider(WalletProvider.INTERNAL_WALLET);
        walletEntity.setInitializationState(WalletState.MODIFIED);
        ajc$this.walletAccountDAO.update(walletEntity);
        ajc$this.walletAccountBackupDAO.delete(walletBackup);
    }

    static /* synthetic */ void switchToWalletProvider_aroundBody2(WalletStorage ajc$this, long walletId, WalletProvider provider, String newAddress, JoinPoint joinPoint) {
        WalletEntity walletEntity = (WalletEntity)ajc$this.walletAccountDAO.find(Long.valueOf(walletId));
        if (walletEntity.getProvider() == WalletProvider.INTERNAL_WALLET && walletEntity.getInitializationState() != WalletState.DELETED) {
            boolean isNew;
            WalletBackupEntity walletBackupEntity = ajc$this.walletAccountBackupDAO.findByWalletId(walletId);
            boolean bl = isNew = walletBackupEntity == null;
            if (isNew) {
                walletBackupEntity = new WalletBackupEntity();
                walletBackupEntity.setWallet(walletEntity);
            }
            walletBackupEntity.setAddress(walletEntity.getAddress());
            if (isNew) {
                ajc$this.walletAccountBackupDAO.create(walletBackupEntity);
            } else {
                ajc$this.walletAccountBackupDAO.update(walletBackupEntity);
            }
        }
        walletEntity.setAddress(newAddress);
        walletEntity.setProvider(provider);
        if (walletEntity.getInitializationState() == WalletState.DELETED) {
            walletEntity.setInitializationState(WalletState.MODIFIED);
        }
        ajc$this.walletAccountDAO.update(walletEntity);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WalletStorage.java", WalletStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "switchToInternalWallet", "org.exoplatform.wallet.storage.WalletStorage", "long", "walletId", "", "void"), 318);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "switchToWalletProvider", "org.exoplatform.wallet.storage.WalletStorage", "long:org.exoplatform.wallet.model.WalletProvider:java.lang.String", "walletId:provider:newAddress", "", "void"), 338);
    }
}

