/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.ListIterator;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.HtmlSerializer;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;

public class CompactHtmlSerializer
extends HtmlSerializer {
    private int openPreTags = 0;

    public CompactHtmlSerializer(CleanerProperties props) {
        super(props);
    }

    protected void serialize(TagNode tagNode, Writer writer) throws IOException {
        boolean isPreTag = "pre".equalsIgnoreCase(tagNode.getName());
        if (isPreTag) {
            ++this.openPreTags;
        }
        this.serializeOpenTag(tagNode, writer, false);
        List<? extends BaseToken> tagChildren = tagNode.getAllChildren();
        if (!this.isMinimizedTagSyntax(tagNode)) {
            ListIterator<? extends BaseToken> childrenIt = tagChildren.listIterator();
            while (childrenIt.hasNext()) {
                String content;
                BaseToken item = childrenIt.next();
                if (item instanceof ContentNode) {
                    content = item.toString();
                    if (this.openPreTags > 0) {
                        writer.write(content);
                        continue;
                    }
                    boolean startsWithSpace = content.length() > 0 && Character.isWhitespace(content.charAt(0));
                    boolean endsWithSpace = content.length() > 1 && Character.isWhitespace(content.charAt(content.length() - 1));
                    String string = content = this.dontEscape(tagNode) ? content.trim() : this.escapeText(content.trim());
                    if (startsWithSpace) {
                        writer.write(32);
                    }
                    if (content.length() != 0) {
                        writer.write(content);
                        if (endsWithSpace) {
                            writer.write(32);
                        }
                    }
                    if (!childrenIt.hasNext()) continue;
                    if (!Utils.isWhitespaceString(childrenIt.next())) {
                        writer.write("\n");
                    }
                    childrenIt.previous();
                    continue;
                }
                if (item instanceof CommentNode) {
                    content = ((CommentNode)item).getCommentedContent().trim();
                    writer.write(content);
                    continue;
                }
                if (!(item instanceof BaseToken)) continue;
                item.serialize(this, writer);
            }
            this.serializeEndTag(tagNode, writer, false);
            if (isPreTag) {
                --this.openPreTags;
            }
        }
    }
}

