/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.oauth;

import java.io.IOException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.api.internal.Parameters;
import org.gatein.api.oauth.AccessToken;
import org.gatein.api.oauth.AccessTokenImpl;
import org.gatein.api.oauth.OAuthProvider;
import org.gatein.api.oauth.exception.OAuthApiException;
import org.gatein.api.oauth.exception.OAuthApiExceptionCode;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.gatein.security.oauth.spi.AccessTokenContext;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.spi.SocialNetworkService;

public class BasicOAuthProviderImpl
implements OAuthProvider {
    private final OAuthProviderType internalOAuthProvider;
    private final SocialNetworkService socialNetworkService;
    protected final Log log = ExoLogger.getLogger(this.getClass());

    public BasicOAuthProviderImpl(OAuthProviderType internalOAuthProvider, SocialNetworkService socialNetworkService) {
        Parameters.requireNonNull((Object)internalOAuthProvider, (String)"internalOAuthProvider");
        Parameters.requireNonNull((Object)socialNetworkService, (String)"socialNetworkService");
        this.internalOAuthProvider = internalOAuthProvider;
        this.socialNetworkService = socialNetworkService;
    }

    public String getKey() {
        return this.internalOAuthProvider.getKey();
    }

    public String getFriendlyName() {
        return this.internalOAuthProvider.getFriendlyName();
    }

    public AccessToken loadAccessToken(String username) throws OAuthApiException {
        try {
            AccessTokenContext accessTokenContext = this.socialNetworkService.getOAuthAccessToken(this.internalOAuthProvider, username);
            if (accessTokenContext == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Not found access token for user " + username + " with provider " + this.internalOAuthProvider));
                }
                return null;
            }
            return new AccessTokenImpl(accessTokenContext);
        }
        catch (OAuthException oauthEx) {
            throw new OAuthApiException(this.translateExceptionCode(oauthEx.getExceptionCode()), oauthEx.getMessage(), (Throwable)oauthEx);
        }
    }

    public void saveAccessToken(String username, AccessToken accessToken) throws OAuthApiException {
        AccessTokenContext accessTokenContext = this.getInternalAccessTokenContext(accessToken);
        try {
            this.socialNetworkService.updateOAuthAccessToken(this.internalOAuthProvider, username, accessTokenContext);
        }
        catch (OAuthException oauthEx) {
            throw new OAuthApiException(this.translateExceptionCode(oauthEx.getExceptionCode()), oauthEx.getMessage(), (Throwable)oauthEx);
        }
    }

    public void removeAccessToken(String username) throws OAuthApiException {
        try {
            this.socialNetworkService.removeOAuthAccessToken(this.internalOAuthProvider, username);
        }
        catch (OAuthException oauthEx) {
            throw new OAuthApiException(this.translateExceptionCode(oauthEx.getExceptionCode()), oauthEx.getMessage(), (Throwable)oauthEx);
        }
    }

    public void startOAuthWorkflow(String neededCustomScope) throws OAuthApiException, IOException {
        throw new OAuthApiException(OAuthApiExceptionCode.OTHER_ERROR, "Not supported for this implementation");
    }

    public AccessToken validateTokenAndUpdateScopes(AccessToken accessToken) throws OAuthApiException {
        AccessTokenContext accessTokenContext = this.getInternalAccessTokenContext(accessToken);
        try {
            accessTokenContext = this.internalOAuthProvider.getOauthProviderProcessor().validateTokenAndUpdateScopes(accessTokenContext);
        }
        catch (OAuthException oauthEx) {
            throw new OAuthApiException(this.translateExceptionCode(oauthEx.getExceptionCode()), oauthEx.getMessage(), (Throwable)oauthEx);
        }
        return new AccessTokenImpl(accessTokenContext);
    }

    public void revokeToken(AccessToken accessToken) throws OAuthApiException {
        AccessTokenContext accessTokenContext = this.getInternalAccessTokenContext(accessToken);
        try {
            this.internalOAuthProvider.getOauthProviderProcessor().revokeToken(accessTokenContext);
        }
        catch (OAuthException oauthEx) {
            throw new OAuthApiException(this.translateExceptionCode(oauthEx.getExceptionCode()), oauthEx.getMessage(), (Throwable)oauthEx);
        }
    }

    public <T> T getAuthorizedSocialApiObject(AccessToken accessToken, Class<T> socialApiObjectType) throws OAuthApiException {
        AccessTokenContext accessTokenContext = this.getInternalAccessTokenContext(accessToken);
        Object socialApiObject = this.internalOAuthProvider.getOauthProviderProcessor().getAuthorizedSocialApiObject(accessTokenContext, socialApiObjectType);
        if (socialApiObject == null) {
            throw new OAuthApiException(OAuthApiExceptionCode.SOCIAL_API_OBJECT_NOT_FOUND, "Class '" + socialApiObjectType + "' not supported by processor " + this.internalOAuthProvider.getOauthProviderProcessor());
        }
        return (T)socialApiObject;
    }

    protected OAuthProviderType getInternalOAuthProvider() {
        return this.internalOAuthProvider;
    }

    protected AccessTokenContext getInternalAccessTokenContext(AccessToken accessToken) throws OAuthApiException {
        AccessTokenImpl accessTokenImpl = (AccessTokenImpl)accessToken;
        return accessTokenImpl.getAccessTokenContext();
    }

    private OAuthApiExceptionCode translateExceptionCode(OAuthExceptionCode internalCode) {
        switch (internalCode) {
            case ACCESS_TOKEN_ERROR: {
                return OAuthApiExceptionCode.ACCESS_TOKEN_ERROR;
            }
            case IO_ERROR: {
                return OAuthApiExceptionCode.IO_ERROR;
            }
            case TOKEN_REVOCATION_FAILED: {
                return OAuthApiExceptionCode.TOKEN_REVOCATION_FAILED;
            }
            case PERSISTENCE_ERROR: {
                return OAuthApiExceptionCode.PERSISTENCE_ERROR;
            }
            case DUPLICATE_OAUTH_PROVIDER_USERNAME: {
                return OAuthApiExceptionCode.DUPLICATE_OAUTH_PROVIDER_USERNAME;
            }
        }
        return OAuthApiExceptionCode.OTHER_ERROR;
    }
}

