/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.resources.Errors;

public final class Fraction
extends Number
implements Comparable<Fraction>,
Serializable {
    private static final long serialVersionUID = -4501644254763471216L;
    private static final WeakHashSet<Fraction> POOL = new WeakHashSet<Fraction>(Fraction.class);
    public final int numerator;
    public final int denominator;
    private static final char[][] UNICODES = new char[][]{{'\u0000', '\u0000', '\u2189'}, {'\u00bd', '\u2153', '\u00bc', '\u2155', '\u2159', '\u2150', '\u215b', '\u2151', '\u2152'}, {'\u2154', '\u0000', '\u2156'}, {'\u00be', '\u2157', '\u0000', '\u0000', '\u215c'}, {'\u2158'}, {'\u215a', '\u0000', '\u215d'}, new char[0], {'\u215e'}};

    public Fraction(int n, int n2) {
        this.numerator = n;
        this.denominator = n2;
    }

    public static Fraction valueOf(double d) {
        if (d == 0.0) {
            return new Fraction(0, MathFunctions.isNegativeZero(d) ? -1 : 1);
        }
        if (!Double.isFinite(d)) {
            return new Fraction(Double.isNaN(d) ? 0 : (d >= 0.0 ? 1 : -1), 0);
        }
        long l = Numerics.getSignificand(d);
        int n = Math.getExponent(d) - 52;
        int n2 = Long.numberOfTrailingZeros(l);
        if ((n += n2) > -32 && n < Long.numberOfLeadingZeros(l >>>= n2)) {
            int n3;
            if (n >= 0) {
                l <<= n;
                n3 = 1;
            } else {
                n3 = 1 << -n;
            }
            if ((l & Integer.MIN_VALUE) == 0L) {
                if (d < 0.0) {
                    l = -l;
                }
                return new Fraction((int)l, n3);
            }
        } else {
            double d2 = 4.503599627370495E15 / Math.ceil(Math.abs(d));
            if (d2 > 1.0) {
                int n4;
                n = Numerics.toExp10(Math.getExponent(d2));
                double d3 = DecimalFunctions.pow10(n + 1);
                if (d3 > d2) {
                    d3 = DecimalFunctions.pow10(n);
                }
                assert (d3 >= 1.0 && d3 <= 4.503599627370495E15) : d3;
                try {
                    Fraction fraction = Fraction.simplify(null, Math.round(d * d3), Math.round(d3));
                    if (fraction.doubleValue() == d) {
                        return fraction;
                    }
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
                double d4 = Math.log(d2);
                for (int i = 1; i < 6542 && !((double)(n4 = MathFunctions.primeNumberAt(i)) > d2); ++i) {
                    n = (int)(d4 / Math.log(n4));
                    long l2 = MathFunctions.pow(n4, n);
                    try {
                        Fraction fraction = Fraction.simplify(null, Math.round(d * (double)l2), l2);
                        if (fraction.doubleValue() != d) continue;
                        return fraction;
                    }
                    catch (ArithmeticException arithmeticException) {
                        // empty catch block
                    }
                }
            }
        }
        throw new IllegalArgumentException(Errors.format((short)8, d, Fraction.class));
    }

    public Fraction unique() {
        return POOL.unique(this);
    }

    public Fraction simplify() {
        return Fraction.simplify(this, this.numerator, this.denominator);
    }

    private static Fraction simplify(Fraction fraction, long l, long l2) {
        if (l == Long.MIN_VALUE || l2 == Long.MIN_VALUE) {
            throw new ArithmeticException(Errors.format((short)10, 64));
        }
        if (l == 0L) {
            l2 = Long.signum(l2);
        } else if (l2 == 0L) {
            l = Long.signum(l);
        } else if (l2 % l == 0L) {
            if ((l2 /= l) < 0L) {
                l2 = -l2;
                l = -1L;
            } else {
                l = 1L;
            }
        } else {
            long l3;
            long l4 = Math.abs(l);
            long l5 = l4 % (l3 = Math.abs(l2));
            if (l5 == 0L) {
                l /= l2;
                l2 = 1L;
            } else {
                while ((l5 = (l4 = l3) % (l3 = l5)) != 0L) {
                }
                l /= l3;
                if ((l2 /= l3) < 0L) {
                    l = -l;
                    l2 = -l2;
                }
            }
        }
        return fraction != null && l == (long)fraction.numerator && l2 == (long)fraction.denominator ? fraction : new Fraction(Math.toIntExact(l), Math.toIntExact(l2));
    }

    public Fraction negate() {
        int n = this.numerator;
        int n2 = this.denominator;
        if (n != 0) {
            n = Math.negateExact(n);
        } else if (n2 != 0) {
            n2 = Math.negateExact(n2);
        } else {
            return this;
        }
        return new Fraction(n, n2);
    }

    public Fraction add(Fraction fraction) {
        long l = this.denominator;
        long l2 = fraction.denominator;
        return Fraction.simplify(this, Math.addExact(l2 * (long)this.numerator, l * (long)fraction.numerator), l2 * l);
    }

    public Fraction subtract(Fraction fraction) {
        long l = this.denominator;
        long l2 = fraction.denominator;
        return Fraction.simplify(this, Math.subtractExact(l2 * (long)this.numerator, l * (long)fraction.numerator), l2 * l);
    }

    public Fraction multiply(Fraction fraction) {
        return Fraction.simplify(this, JDK9.multiplyFull(this.numerator, fraction.numerator), JDK9.multiplyFull(this.denominator, fraction.denominator));
    }

    public Fraction divide(Fraction fraction) {
        return Fraction.simplify(this, JDK9.multiplyFull(this.numerator, fraction.denominator), JDK9.multiplyFull(this.denominator, fraction.numerator));
    }

    public int round() {
        int n;
        if (this.denominator == Integer.MIN_VALUE) {
            if (this.numerator < -1073741824) {
                return 1;
            }
            if (this.numerator > 0x40000000) {
                return -1;
            }
            return 0;
        }
        int n2 = this.numerator / this.denominator;
        int n3 = this.numerator % this.denominator;
        if (n3 != 0 && ((n3 = Math.abs(n3 << 1)) > (n = Math.abs(this.denominator)) || n3 == n && (n2 & 1) != 0)) {
            n2 = (this.numerator ^ this.denominator) >= 0 ? ++n2 : --n2;
        }
        return n2;
    }

    public int floor() {
        int n = this.numerator / this.denominator;
        if ((this.numerator ^ this.denominator) < 0 && this.numerator % this.denominator != 0) {
            --n;
        }
        return n;
    }

    public int ceil() {
        int n = this.numerator / this.denominator;
        if ((this.numerator ^ this.denominator) >= 0 && this.numerator % this.denominator != 0) {
            ++n;
        }
        return n;
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public int intValue() {
        return this.numerator / this.denominator;
    }

    @Override
    public short shortValue() {
        int n = this.intValue();
        if ((n & 0xFFFF0000) == 0) {
            return (short)n;
        }
        throw new ArithmeticException(Errors.format((short)10, 16));
    }

    @Override
    public byte byteValue() {
        int n = this.intValue();
        if ((n & 0xFFFFFF00) == 0) {
            return (byte)n;
        }
        throw new ArithmeticException(Errors.format((short)10, 8));
    }

    public int signum() {
        if (this.numerator == 0) {
            return 0;
        }
        return (this.numerator ^ this.denominator) >> 30 | 1;
    }

    @Override
    public int compareTo(Fraction fraction) {
        return Long.signum(JDK9.multiplyFull(this.numerator, fraction.denominator) - JDK9.multiplyFull(fraction.numerator, this.denominator));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Fraction) {
            Fraction fraction = (Fraction)object;
            return this.numerator == fraction.numerator && this.denominator == fraction.denominator;
        }
        return false;
    }

    public int hashCode() {
        return this.numerator + 31 * this.denominator ^ 0xA9A52E90;
    }

    public String toString() {
        switch (this.denominator) {
            case 0: {
                if (this.numerator == 0) break;
                return this.numerator >= 0 ? "\u221e" : "\u2212\u221e";
            }
            case 1: {
                return String.valueOf(this.numerator);
            }
            default: {
                char c;
                char[] cArray;
                int n;
                if (this.numerator < 0 || this.numerator >= UNICODES.length || (n = this.denominator - this.numerator - 1) < 0 || n >= (cArray = UNICODES[this.numerator]).length || (c = cArray[n]) == '\u0000') break;
                return String.valueOf(c);
            }
        }
        return "" + this.numerator + '\u2044' + this.denominator;
    }

    public Fraction(String string) throws NumberFormatException {
        int n;
        ArgumentChecks.ensureNonEmpty("s", string);
        int n2 = string.length();
        if (n2 == 1 && (n = string.charAt(0)) >= 128) {
            for (int i = 0; i < UNICODES.length; ++i) {
                char[] cArray = UNICODES[i];
                for (int j = 0; j < cArray.length; ++j) {
                    if (cArray[j] != n) continue;
                    this.numerator = i;
                    this.denominator = i + j + 1;
                    return;
                }
            }
            if (n == 8734) {
                this.numerator = 1;
                this.denominator = 0;
                return;
            }
        }
        if (string.equals("\u2212\u221e") || string.equals("-\u221e")) {
            this.numerator = -1;
            this.denominator = 0;
            return;
        }
        for (n = 0; n < n2; ++n) {
            switch (string.charAt(n)) {
                case '/': 
                case '\u00f7': 
                case '\u2044': 
                case '\u2215': {
                    this.numerator = Integer.parseInt(string.substring(0, n));
                    this.denominator = Integer.parseInt(string.substring(n + 1));
                    return;
                }
            }
        }
        this.numerator = Integer.parseInt(string);
        this.denominator = 1;
    }
}

